// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DetachNetworkInterface.
 */
class DetachNetworkInterfaceRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the attachment.
     */
    val attachmentId: String? = builder.attachmentId
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Specifies whether to force a detachment.
     * Use the Force parameter only as a last resort to detach a network interface from a failed instance.
     * If you use the Force parameter to detach a network interface, you might not be able to attach a different network interface to the same index on the instance without first stopping and starting the instance.
     * If you force the detachment of a network interface, the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">instance metadata
     * might not get updated. This means that the attributes associated
     * with the detached network interface might still be visible. The
     * instance metadata will get updated when you stop and start the
     * instance.
     */
    val force: Boolean? = builder.force

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DetachNetworkInterfaceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DetachNetworkInterfaceRequest(")
        append("attachmentId=$attachmentId,")
        append("dryRun=$dryRun,")
        append("force=$force)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentId?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (force?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DetachNetworkInterfaceRequest

        if (attachmentId != other.attachmentId) return false
        if (dryRun != other.dryRun) return false
        if (force != other.force) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DetachNetworkInterfaceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DetachNetworkInterfaceRequest
        /**
         * The ID of the attachment.
         */
        fun attachmentId(attachmentId: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Specifies whether to force a detachment.
         * Use the Force parameter only as a last resort to detach a network interface from a failed instance.
         * If you use the Force parameter to detach a network interface, you might not be able to attach a different network interface to the same index on the instance without first stopping and starting the instance.
         * If you force the detachment of a network interface, the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">instance metadata
         * might not get updated. This means that the attributes associated
         * with the detached network interface might still be visible. The
         * instance metadata will get updated when you stop and start the
         * instance.
         */
        fun force(force: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the attachment.
         */
        var attachmentId: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Specifies whether to force a detachment.
         * Use the Force parameter only as a last resort to detach a network interface from a failed instance.
         * If you use the Force parameter to detach a network interface, you might not be able to attach a different network interface to the same index on the instance without first stopping and starting the instance.
         * If you force the detachment of a network interface, the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">instance metadata
         * might not get updated. This means that the attributes associated
         * with the detached network interface might still be visible. The
         * instance metadata will get updated when you stop and start the
         * instance.
         */
        var force: Boolean?

        fun build(): DetachNetworkInterfaceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attachmentId: String? = null
        override var dryRun: Boolean? = null
        override var force: Boolean? = null

        constructor(x: DetachNetworkInterfaceRequest) : this() {
            this.attachmentId = x.attachmentId
            this.dryRun = x.dryRun
            this.force = x.force
        }

        override fun build(): DetachNetworkInterfaceRequest = DetachNetworkInterfaceRequest(this)
        override fun attachmentId(attachmentId: String): FluentBuilder = apply { this.attachmentId = attachmentId }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun force(force: Boolean): FluentBuilder = apply { this.force = force }
    }
}
