// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a set of DHCP options.
 */
class DhcpOptions private constructor(builder: BuilderImpl) {
    /**
     * One or more DHCP options in the set.
     */
    val dhcpConfigurations: List<DhcpConfiguration>? = builder.dhcpConfigurations
    /**
     * The ID of the set of DHCP options.
     */
    val dhcpOptionsId: String? = builder.dhcpOptionsId
    /**
     * The ID of the Amazon Web Services account that owns the DHCP options set.
     */
    val ownerId: String? = builder.ownerId
    /**
     * Any tags assigned to the DHCP options set.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DhcpOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DhcpOptions(")
        append("dhcpConfigurations=$dhcpConfigurations,")
        append("dhcpOptionsId=$dhcpOptionsId,")
        append("ownerId=$ownerId,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dhcpConfigurations?.hashCode() ?: 0
        result = 31 * result + (dhcpOptionsId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DhcpOptions

        if (dhcpConfigurations != other.dhcpConfigurations) return false
        if (dhcpOptionsId != other.dhcpOptionsId) return false
        if (ownerId != other.ownerId) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DhcpOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DhcpOptions
        /**
         * One or more DHCP options in the set.
         */
        fun dhcpConfigurations(dhcpConfigurations: List<DhcpConfiguration>): FluentBuilder
        /**
         * The ID of the set of DHCP options.
         */
        fun dhcpOptionsId(dhcpOptionsId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the DHCP options set.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * Any tags assigned to the DHCP options set.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * One or more DHCP options in the set.
         */
        var dhcpConfigurations: List<DhcpConfiguration>?
        /**
         * The ID of the set of DHCP options.
         */
        var dhcpOptionsId: String?
        /**
         * The ID of the Amazon Web Services account that owns the DHCP options set.
         */
        var ownerId: String?
        /**
         * Any tags assigned to the DHCP options set.
         */
        var tags: List<Tag>?

        fun build(): DhcpOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dhcpConfigurations: List<DhcpConfiguration>? = null
        override var dhcpOptionsId: String? = null
        override var ownerId: String? = null
        override var tags: List<Tag>? = null

        constructor(x: DhcpOptions) : this() {
            this.dhcpConfigurations = x.dhcpConfigurations
            this.dhcpOptionsId = x.dhcpOptionsId
            this.ownerId = x.ownerId
            this.tags = x.tags
        }

        override fun build(): DhcpOptions = DhcpOptions(this)
        override fun dhcpConfigurations(dhcpConfigurations: List<DhcpConfiguration>): FluentBuilder = apply { this.dhcpConfigurations = dhcpConfigurations }
        override fun dhcpOptionsId(dhcpOptionsId: String): FluentBuilder = apply { this.dhcpOptionsId = dhcpOptionsId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
