// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a disk image.
 */
class DiskImageDescription private constructor(builder: BuilderImpl) {
    /**
     * The checksum computed for the disk image.
     */
    val checksum: String? = builder.checksum
    /**
     * The disk image format.
     */
    val format: DiskImageFormat? = builder.format
    /**
     * A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned URL for
     * an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests topic in
     * the Amazon Simple Storage Service Developer Guide.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    val importManifestUrl: String? = builder.importManifestUrl
    /**
     * The size of the disk image, in GiB.
     */
    val size: Long? = builder.size

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DiskImageDescription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DiskImageDescription(")
        append("checksum=$checksum,")
        append("format=$format,")
        append("importManifestUrl=$importManifestUrl,")
        append("size=$size)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checksum?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (importManifestUrl?.hashCode() ?: 0)
        result = 31 * result + (size?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DiskImageDescription

        if (checksum != other.checksum) return false
        if (format != other.format) return false
        if (importManifestUrl != other.importManifestUrl) return false
        if (size != other.size) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DiskImageDescription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DiskImageDescription
        /**
         * The checksum computed for the disk image.
         */
        fun checksum(checksum: String): FluentBuilder
        /**
         * The disk image format.
         */
        fun format(format: DiskImageFormat): FluentBuilder
        /**
         * A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned URL for
         * an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests topic in
         * the Amazon Simple Storage Service Developer Guide.
         * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
         */
        fun importManifestUrl(importManifestUrl: String): FluentBuilder
        /**
         * The size of the disk image, in GiB.
         */
        fun size(size: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The checksum computed for the disk image.
         */
        var checksum: String?
        /**
         * The disk image format.
         */
        var format: DiskImageFormat?
        /**
         * A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned URL for
         * an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests topic in
         * the Amazon Simple Storage Service Developer Guide.
         * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
         */
        var importManifestUrl: String?
        /**
         * The size of the disk image, in GiB.
         */
        var size: Long?

        fun build(): DiskImageDescription
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var checksum: String? = null
        override var format: DiskImageFormat? = null
        override var importManifestUrl: String? = null
        override var size: Long? = null

        constructor(x: DiskImageDescription) : this() {
            this.checksum = x.checksum
            this.format = x.format
            this.importManifestUrl = x.importManifestUrl
            this.size = x.size
        }

        override fun build(): DiskImageDescription = DiskImageDescription(this)
        override fun checksum(checksum: String): FluentBuilder = apply { this.checksum = checksum }
        override fun format(format: DiskImageFormat): FluentBuilder = apply { this.format = format }
        override fun importManifestUrl(importManifestUrl: String): FluentBuilder = apply { this.importManifestUrl = importManifestUrl }
        override fun size(size: Long): FluentBuilder = apply { this.size = size }
    }
}
