// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a disk image.
 */
class DiskImageDetail private constructor(builder: BuilderImpl) {
    /**
     * The size of the disk image, in GiB.
     */
    val bytes: Long? = builder.bytes
    /**
     * The disk image format.
     */
    val format: DiskImageFormat? = builder.format
    /**
     * A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3 presigned URL.
     * For information about creating a presigned URL for an Amazon S3 object, read the "Query String Request Authentication
     * Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests topic in the Amazon Simple Storage Service Developer
     * Guide.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    val importManifestUrl: String? = builder.importManifestUrl

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DiskImageDetail = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DiskImageDetail(")
        append("bytes=$bytes,")
        append("format=$format,")
        append("importManifestUrl=$importManifestUrl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytes?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (importManifestUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DiskImageDetail

        if (bytes != other.bytes) return false
        if (format != other.format) return false
        if (importManifestUrl != other.importManifestUrl) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DiskImageDetail = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DiskImageDetail
        /**
         * The size of the disk image, in GiB.
         */
        fun bytes(bytes: Long): FluentBuilder
        /**
         * The disk image format.
         */
        fun format(format: DiskImageFormat): FluentBuilder
        /**
         * A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3 presigned URL.
         * For information about creating a presigned URL for an Amazon S3 object, read the "Query String Request Authentication
         * Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests topic in the Amazon Simple Storage Service Developer
         * Guide.
         * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
         */
        fun importManifestUrl(importManifestUrl: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The size of the disk image, in GiB.
         */
        var bytes: Long?
        /**
         * The disk image format.
         */
        var format: DiskImageFormat?
        /**
         * A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3 presigned URL.
         * For information about creating a presigned URL for an Amazon S3 object, read the "Query String Request Authentication
         * Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests topic in the Amazon Simple Storage Service Developer
         * Guide.
         * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
         */
        var importManifestUrl: String?

        fun build(): DiskImageDetail
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bytes: Long? = null
        override var format: DiskImageFormat? = null
        override var importManifestUrl: String? = null

        constructor(x: DiskImageDetail) : this() {
            this.bytes = x.bytes
            this.format = x.format
            this.importManifestUrl = x.importManifestUrl
        }

        override fun build(): DiskImageDetail = DiskImageDetail(this)
        override fun bytes(bytes: Long): FluentBuilder = apply { this.bytes = bytes }
        override fun format(format: DiskImageFormat): FluentBuilder = apply { this.format = format }
        override fun importManifestUrl(importManifestUrl: String): FluentBuilder = apply { this.importManifestUrl = importManifestUrl }
    }
}
