// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the Amazon EBS features supported by the instance type.
 */
class EbsInfo private constructor(builder: BuilderImpl) {
    /**
     * Describes the optimized EBS performance for the instance type.
     */
    val ebsOptimizedInfo: EbsOptimizedInfo? = builder.ebsOptimizedInfo
    /**
     * Indicates whether the instance type is Amazon EBS-optimized. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized
     * instances in Amazon EC2 User Guide.
     */
    val ebsOptimizedSupport: EbsOptimizedSupport? = builder.ebsOptimizedSupport
    /**
     * Indicates whether Amazon EBS encryption is supported.
     */
    val encryptionSupport: EbsEncryptionSupport? = builder.encryptionSupport
    /**
     * Indicates whether non-volatile memory express (NVMe) is supported.
     */
    val nvmeSupport: EbsNvmeSupport? = builder.nvmeSupport

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EbsInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EbsInfo(")
        append("ebsOptimizedInfo=$ebsOptimizedInfo,")
        append("ebsOptimizedSupport=$ebsOptimizedSupport,")
        append("encryptionSupport=$encryptionSupport,")
        append("nvmeSupport=$nvmeSupport)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ebsOptimizedInfo?.hashCode() ?: 0
        result = 31 * result + (ebsOptimizedSupport?.hashCode() ?: 0)
        result = 31 * result + (encryptionSupport?.hashCode() ?: 0)
        result = 31 * result + (nvmeSupport?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EbsInfo

        if (ebsOptimizedInfo != other.ebsOptimizedInfo) return false
        if (ebsOptimizedSupport != other.ebsOptimizedSupport) return false
        if (encryptionSupport != other.encryptionSupport) return false
        if (nvmeSupport != other.nvmeSupport) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EbsInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EbsInfo
        /**
         * Describes the optimized EBS performance for the instance type.
         */
        fun ebsOptimizedInfo(ebsOptimizedInfo: EbsOptimizedInfo): FluentBuilder
        /**
         * Indicates whether the instance type is Amazon EBS-optimized. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized
         * instances in Amazon EC2 User Guide.
         */
        fun ebsOptimizedSupport(ebsOptimizedSupport: EbsOptimizedSupport): FluentBuilder
        /**
         * Indicates whether Amazon EBS encryption is supported.
         */
        fun encryptionSupport(encryptionSupport: EbsEncryptionSupport): FluentBuilder
        /**
         * Indicates whether non-volatile memory express (NVMe) is supported.
         */
        fun nvmeSupport(nvmeSupport: EbsNvmeSupport): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Describes the optimized EBS performance for the instance type.
         */
        var ebsOptimizedInfo: EbsOptimizedInfo?
        /**
         * Indicates whether the instance type is Amazon EBS-optimized. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized
         * instances in Amazon EC2 User Guide.
         */
        var ebsOptimizedSupport: EbsOptimizedSupport?
        /**
         * Indicates whether Amazon EBS encryption is supported.
         */
        var encryptionSupport: EbsEncryptionSupport?
        /**
         * Indicates whether non-volatile memory express (NVMe) is supported.
         */
        var nvmeSupport: EbsNvmeSupport?

        fun build(): EbsInfo
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EbsOptimizedInfo] inside the given [block]
         */
        fun ebsOptimizedInfo(block: EbsOptimizedInfo.DslBuilder.() -> kotlin.Unit) {
            this.ebsOptimizedInfo = EbsOptimizedInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var ebsOptimizedInfo: EbsOptimizedInfo? = null
        override var ebsOptimizedSupport: EbsOptimizedSupport? = null
        override var encryptionSupport: EbsEncryptionSupport? = null
        override var nvmeSupport: EbsNvmeSupport? = null

        constructor(x: EbsInfo) : this() {
            this.ebsOptimizedInfo = x.ebsOptimizedInfo
            this.ebsOptimizedSupport = x.ebsOptimizedSupport
            this.encryptionSupport = x.encryptionSupport
            this.nvmeSupport = x.nvmeSupport
        }

        override fun build(): EbsInfo = EbsInfo(this)
        override fun ebsOptimizedInfo(ebsOptimizedInfo: EbsOptimizedInfo): FluentBuilder = apply { this.ebsOptimizedInfo = ebsOptimizedInfo }
        override fun ebsOptimizedSupport(ebsOptimizedSupport: EbsOptimizedSupport): FluentBuilder = apply { this.ebsOptimizedSupport = ebsOptimizedSupport }
        override fun encryptionSupport(encryptionSupport: EbsEncryptionSupport): FluentBuilder = apply { this.encryptionSupport = encryptionSupport }
        override fun nvmeSupport(nvmeSupport: EbsNvmeSupport): FluentBuilder = apply { this.nvmeSupport = nvmeSupport }
    }
}
