// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a parameter used to set up an EBS volume in a block device mapping.
 */
class EbsInstanceBlockDevice private constructor(builder: BuilderImpl) {
    /**
     * The time stamp when the attachment initiated.
     */
    val attachTime: Instant? = builder.attachTime
    /**
     * Indicates whether the volume is deleted on instance termination.
     */
    val deleteOnTermination: Boolean? = builder.deleteOnTermination
    /**
     * The attachment state.
     */
    val status: AttachmentStatus? = builder.status
    /**
     * The ID of the EBS volume.
     */
    val volumeId: String? = builder.volumeId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EbsInstanceBlockDevice = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EbsInstanceBlockDevice(")
        append("attachTime=$attachTime,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("status=$status,")
        append("volumeId=$volumeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachTime?.hashCode() ?: 0
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EbsInstanceBlockDevice

        if (attachTime != other.attachTime) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (status != other.status) return false
        if (volumeId != other.volumeId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EbsInstanceBlockDevice = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EbsInstanceBlockDevice
        /**
         * The time stamp when the attachment initiated.
         */
        fun attachTime(attachTime: Instant): FluentBuilder
        /**
         * Indicates whether the volume is deleted on instance termination.
         */
        fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder
        /**
         * The attachment state.
         */
        fun status(status: AttachmentStatus): FluentBuilder
        /**
         * The ID of the EBS volume.
         */
        fun volumeId(volumeId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time stamp when the attachment initiated.
         */
        var attachTime: Instant?
        /**
         * Indicates whether the volume is deleted on instance termination.
         */
        var deleteOnTermination: Boolean?
        /**
         * The attachment state.
         */
        var status: AttachmentStatus?
        /**
         * The ID of the EBS volume.
         */
        var volumeId: String?

        fun build(): EbsInstanceBlockDevice
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attachTime: Instant? = null
        override var deleteOnTermination: Boolean? = null
        override var status: AttachmentStatus? = null
        override var volumeId: String? = null

        constructor(x: EbsInstanceBlockDevice) : this() {
            this.attachTime = x.attachTime
            this.deleteOnTermination = x.deleteOnTermination
            this.status = x.status
            this.volumeId = x.volumeId
        }

        override fun build(): EbsInstanceBlockDevice = EbsInstanceBlockDevice(this)
        override fun attachTime(attachTime: Instant): FluentBuilder = apply { this.attachTime = attachTime }
        override fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder = apply { this.deleteOnTermination = deleteOnTermination }
        override fun status(status: AttachmentStatus): FluentBuilder = apply { this.status = status }
        override fun volumeId(volumeId: String): FluentBuilder = apply { this.volumeId = volumeId }
    }
}
