// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the optimized EBS performance for supported instance types.
 */
class EbsOptimizedInfo private constructor(builder: BuilderImpl) {
    /**
     * The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
     */
    val baselineBandwidthInMbps: Int? = builder.baselineBandwidthInMbps
    /**
     * The baseline input/output storage operations per seconds for an EBS-optimized instance type.
     */
    val baselineIops: Int? = builder.baselineIops
    /**
     * The baseline throughput performance for an EBS-optimized instance type, in MB/s.
     */
    val baselineThroughputInMBps: Double? = builder.baselineThroughputInMBps
    /**
     * The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
     */
    val maximumBandwidthInMbps: Int? = builder.maximumBandwidthInMbps
    /**
     * The maximum input/output storage operations per second for an EBS-optimized instance type.
     */
    val maximumIops: Int? = builder.maximumIops
    /**
     * The maximum throughput performance for an EBS-optimized instance type, in MB/s.
     */
    val maximumThroughputInMBps: Double? = builder.maximumThroughputInMBps

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EbsOptimizedInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EbsOptimizedInfo(")
        append("baselineBandwidthInMbps=$baselineBandwidthInMbps,")
        append("baselineIops=$baselineIops,")
        append("baselineThroughputInMBps=$baselineThroughputInMBps,")
        append("maximumBandwidthInMbps=$maximumBandwidthInMbps,")
        append("maximumIops=$maximumIops,")
        append("maximumThroughputInMBps=$maximumThroughputInMBps)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baselineBandwidthInMbps ?: 0
        result = 31 * result + (baselineIops ?: 0)
        result = 31 * result + (baselineThroughputInMBps?.hashCode() ?: 0)
        result = 31 * result + (maximumBandwidthInMbps ?: 0)
        result = 31 * result + (maximumIops ?: 0)
        result = 31 * result + (maximumThroughputInMBps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EbsOptimizedInfo

        if (baselineBandwidthInMbps != other.baselineBandwidthInMbps) return false
        if (baselineIops != other.baselineIops) return false
        if (baselineThroughputInMBps != other.baselineThroughputInMBps) return false
        if (maximumBandwidthInMbps != other.maximumBandwidthInMbps) return false
        if (maximumIops != other.maximumIops) return false
        if (maximumThroughputInMBps != other.maximumThroughputInMBps) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EbsOptimizedInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EbsOptimizedInfo
        /**
         * The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
         */
        fun baselineBandwidthInMbps(baselineBandwidthInMbps: Int): FluentBuilder
        /**
         * The baseline input/output storage operations per seconds for an EBS-optimized instance type.
         */
        fun baselineIops(baselineIops: Int): FluentBuilder
        /**
         * The baseline throughput performance for an EBS-optimized instance type, in MB/s.
         */
        fun baselineThroughputInMBps(baselineThroughputInMBps: Double): FluentBuilder
        /**
         * The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
         */
        fun maximumBandwidthInMbps(maximumBandwidthInMbps: Int): FluentBuilder
        /**
         * The maximum input/output storage operations per second for an EBS-optimized instance type.
         */
        fun maximumIops(maximumIops: Int): FluentBuilder
        /**
         * The maximum throughput performance for an EBS-optimized instance type, in MB/s.
         */
        fun maximumThroughputInMBps(maximumThroughputInMBps: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
         */
        var baselineBandwidthInMbps: Int?
        /**
         * The baseline input/output storage operations per seconds for an EBS-optimized instance type.
         */
        var baselineIops: Int?
        /**
         * The baseline throughput performance for an EBS-optimized instance type, in MB/s.
         */
        var baselineThroughputInMBps: Double?
        /**
         * The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
         */
        var maximumBandwidthInMbps: Int?
        /**
         * The maximum input/output storage operations per second for an EBS-optimized instance type.
         */
        var maximumIops: Int?
        /**
         * The maximum throughput performance for an EBS-optimized instance type, in MB/s.
         */
        var maximumThroughputInMBps: Double?

        fun build(): EbsOptimizedInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var baselineBandwidthInMbps: Int? = null
        override var baselineIops: Int? = null
        override var baselineThroughputInMBps: Double? = null
        override var maximumBandwidthInMbps: Int? = null
        override var maximumIops: Int? = null
        override var maximumThroughputInMBps: Double? = null

        constructor(x: EbsOptimizedInfo) : this() {
            this.baselineBandwidthInMbps = x.baselineBandwidthInMbps
            this.baselineIops = x.baselineIops
            this.baselineThroughputInMBps = x.baselineThroughputInMBps
            this.maximumBandwidthInMbps = x.maximumBandwidthInMbps
            this.maximumIops = x.maximumIops
            this.maximumThroughputInMBps = x.maximumThroughputInMBps
        }

        override fun build(): EbsOptimizedInfo = EbsOptimizedInfo(this)
        override fun baselineBandwidthInMbps(baselineBandwidthInMbps: Int): FluentBuilder = apply { this.baselineBandwidthInMbps = baselineBandwidthInMbps }
        override fun baselineIops(baselineIops: Int): FluentBuilder = apply { this.baselineIops = baselineIops }
        override fun baselineThroughputInMBps(baselineThroughputInMBps: Double): FluentBuilder = apply { this.baselineThroughputInMBps = baselineThroughputInMBps }
        override fun maximumBandwidthInMbps(maximumBandwidthInMbps: Int): FluentBuilder = apply { this.maximumBandwidthInMbps = maximumBandwidthInMbps }
        override fun maximumIops(maximumIops: Int): FluentBuilder = apply { this.maximumIops = maximumIops }
        override fun maximumThroughputInMBps(maximumThroughputInMBps: Double): FluentBuilder = apply { this.maximumThroughputInMBps = maximumThroughputInMBps }
    }
}
