// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the association between an instance and an Elastic Graphics accelerator.
 */
class ElasticGpuAssociation private constructor(builder: BuilderImpl) {
    /**
     * The ID of the association.
     */
    val elasticGpuAssociationId: String? = builder.elasticGpuAssociationId
    /**
     * The state of the association between the instance and the
     * Elastic Graphics accelerator.
     */
    val elasticGpuAssociationState: String? = builder.elasticGpuAssociationState
    /**
     * The time the Elastic Graphics accelerator was associated with the instance.
     */
    val elasticGpuAssociationTime: String? = builder.elasticGpuAssociationTime
    /**
     * The ID of the Elastic Graphics accelerator.
     */
    val elasticGpuId: String? = builder.elasticGpuId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ElasticGpuAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ElasticGpuAssociation(")
        append("elasticGpuAssociationId=$elasticGpuAssociationId,")
        append("elasticGpuAssociationState=$elasticGpuAssociationState,")
        append("elasticGpuAssociationTime=$elasticGpuAssociationTime,")
        append("elasticGpuId=$elasticGpuId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = elasticGpuAssociationId?.hashCode() ?: 0
        result = 31 * result + (elasticGpuAssociationState?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuAssociationTime?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ElasticGpuAssociation

        if (elasticGpuAssociationId != other.elasticGpuAssociationId) return false
        if (elasticGpuAssociationState != other.elasticGpuAssociationState) return false
        if (elasticGpuAssociationTime != other.elasticGpuAssociationTime) return false
        if (elasticGpuId != other.elasticGpuId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ElasticGpuAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ElasticGpuAssociation
        /**
         * The ID of the association.
         */
        fun elasticGpuAssociationId(elasticGpuAssociationId: String): FluentBuilder
        /**
         * The state of the association between the instance and the
         * Elastic Graphics accelerator.
         */
        fun elasticGpuAssociationState(elasticGpuAssociationState: String): FluentBuilder
        /**
         * The time the Elastic Graphics accelerator was associated with the instance.
         */
        fun elasticGpuAssociationTime(elasticGpuAssociationTime: String): FluentBuilder
        /**
         * The ID of the Elastic Graphics accelerator.
         */
        fun elasticGpuId(elasticGpuId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the association.
         */
        var elasticGpuAssociationId: String?
        /**
         * The state of the association between the instance and the
         * Elastic Graphics accelerator.
         */
        var elasticGpuAssociationState: String?
        /**
         * The time the Elastic Graphics accelerator was associated with the instance.
         */
        var elasticGpuAssociationTime: String?
        /**
         * The ID of the Elastic Graphics accelerator.
         */
        var elasticGpuId: String?

        fun build(): ElasticGpuAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var elasticGpuAssociationId: String? = null
        override var elasticGpuAssociationState: String? = null
        override var elasticGpuAssociationTime: String? = null
        override var elasticGpuId: String? = null

        constructor(x: ElasticGpuAssociation) : this() {
            this.elasticGpuAssociationId = x.elasticGpuAssociationId
            this.elasticGpuAssociationState = x.elasticGpuAssociationState
            this.elasticGpuAssociationTime = x.elasticGpuAssociationTime
            this.elasticGpuId = x.elasticGpuId
        }

        override fun build(): ElasticGpuAssociation = ElasticGpuAssociation(this)
        override fun elasticGpuAssociationId(elasticGpuAssociationId: String): FluentBuilder = apply { this.elasticGpuAssociationId = elasticGpuAssociationId }
        override fun elasticGpuAssociationState(elasticGpuAssociationState: String): FluentBuilder = apply { this.elasticGpuAssociationState = elasticGpuAssociationState }
        override fun elasticGpuAssociationTime(elasticGpuAssociationTime: String): FluentBuilder = apply { this.elasticGpuAssociationTime = elasticGpuAssociationTime }
        override fun elasticGpuId(elasticGpuId: String): FluentBuilder = apply { this.elasticGpuId = elasticGpuId }
    }
}
