// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the association between an instance and an elastic inference accelerator.
 */
class ElasticInferenceAcceleratorAssociation private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the elastic inference accelerator.
     */
    val elasticInferenceAcceleratorArn: String? = builder.elasticInferenceAcceleratorArn
    /**
     * The ID of the association.
     */
    val elasticInferenceAcceleratorAssociationId: String? = builder.elasticInferenceAcceleratorAssociationId
    /**
     * The state of the elastic inference accelerator.
     */
    val elasticInferenceAcceleratorAssociationState: String? = builder.elasticInferenceAcceleratorAssociationState
    /**
     * The time at which the elastic inference accelerator is associated with an instance.
     */
    val elasticInferenceAcceleratorAssociationTime: Instant? = builder.elasticInferenceAcceleratorAssociationTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ElasticInferenceAcceleratorAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ElasticInferenceAcceleratorAssociation(")
        append("elasticInferenceAcceleratorArn=$elasticInferenceAcceleratorArn,")
        append("elasticInferenceAcceleratorAssociationId=$elasticInferenceAcceleratorAssociationId,")
        append("elasticInferenceAcceleratorAssociationState=$elasticInferenceAcceleratorAssociationState,")
        append("elasticInferenceAcceleratorAssociationTime=$elasticInferenceAcceleratorAssociationTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = elasticInferenceAcceleratorArn?.hashCode() ?: 0
        result = 31 * result + (elasticInferenceAcceleratorAssociationId?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAcceleratorAssociationState?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAcceleratorAssociationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ElasticInferenceAcceleratorAssociation

        if (elasticInferenceAcceleratorArn != other.elasticInferenceAcceleratorArn) return false
        if (elasticInferenceAcceleratorAssociationId != other.elasticInferenceAcceleratorAssociationId) return false
        if (elasticInferenceAcceleratorAssociationState != other.elasticInferenceAcceleratorAssociationState) return false
        if (elasticInferenceAcceleratorAssociationTime != other.elasticInferenceAcceleratorAssociationTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ElasticInferenceAcceleratorAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ElasticInferenceAcceleratorAssociation
        /**
         * The Amazon Resource Name (ARN) of the elastic inference accelerator.
         */
        fun elasticInferenceAcceleratorArn(elasticInferenceAcceleratorArn: String): FluentBuilder
        /**
         * The ID of the association.
         */
        fun elasticInferenceAcceleratorAssociationId(elasticInferenceAcceleratorAssociationId: String): FluentBuilder
        /**
         * The state of the elastic inference accelerator.
         */
        fun elasticInferenceAcceleratorAssociationState(elasticInferenceAcceleratorAssociationState: String): FluentBuilder
        /**
         * The time at which the elastic inference accelerator is associated with an instance.
         */
        fun elasticInferenceAcceleratorAssociationTime(elasticInferenceAcceleratorAssociationTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the elastic inference accelerator.
         */
        var elasticInferenceAcceleratorArn: String?
        /**
         * The ID of the association.
         */
        var elasticInferenceAcceleratorAssociationId: String?
        /**
         * The state of the elastic inference accelerator.
         */
        var elasticInferenceAcceleratorAssociationState: String?
        /**
         * The time at which the elastic inference accelerator is associated with an instance.
         */
        var elasticInferenceAcceleratorAssociationTime: Instant?

        fun build(): ElasticInferenceAcceleratorAssociation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var elasticInferenceAcceleratorArn: String? = null
        override var elasticInferenceAcceleratorAssociationId: String? = null
        override var elasticInferenceAcceleratorAssociationState: String? = null
        override var elasticInferenceAcceleratorAssociationTime: Instant? = null

        constructor(x: ElasticInferenceAcceleratorAssociation) : this() {
            this.elasticInferenceAcceleratorArn = x.elasticInferenceAcceleratorArn
            this.elasticInferenceAcceleratorAssociationId = x.elasticInferenceAcceleratorAssociationId
            this.elasticInferenceAcceleratorAssociationState = x.elasticInferenceAcceleratorAssociationState
            this.elasticInferenceAcceleratorAssociationTime = x.elasticInferenceAcceleratorAssociationTime
        }

        override fun build(): ElasticInferenceAcceleratorAssociation = ElasticInferenceAcceleratorAssociation(this)
        override fun elasticInferenceAcceleratorArn(elasticInferenceAcceleratorArn: String): FluentBuilder = apply { this.elasticInferenceAcceleratorArn = elasticInferenceAcceleratorArn }
        override fun elasticInferenceAcceleratorAssociationId(elasticInferenceAcceleratorAssociationId: String): FluentBuilder = apply { this.elasticInferenceAcceleratorAssociationId = elasticInferenceAcceleratorAssociationId }
        override fun elasticInferenceAcceleratorAssociationState(elasticInferenceAcceleratorAssociationState: String): FluentBuilder = apply { this.elasticInferenceAcceleratorAssociationState = elasticInferenceAcceleratorAssociationState }
        override fun elasticInferenceAcceleratorAssociationTime(elasticInferenceAcceleratorAssociationTime: Instant): FluentBuilder = apply { this.elasticInferenceAcceleratorAssociationTime = elasticInferenceAcceleratorAssociationTime }
    }
}
