// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes fast snapshot restores that were successfully enabled.
 */
class EnableFastSnapshotRestoreSuccessItem private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The time at which fast snapshot restores entered the disabled state.
     */
    val disabledTime: Instant? = builder.disabledTime
    /**
     * The time at which fast snapshot restores entered the disabling state.
     */
    val disablingTime: Instant? = builder.disablingTime
    /**
     * The time at which fast snapshot restores entered the enabled state.
     */
    val enabledTime: Instant? = builder.enabledTime
    /**
     * The time at which fast snapshot restores entered the enabling state.
     */
    val enablingTime: Instant? = builder.enablingTime
    /**
     * The time at which fast snapshot restores entered the optimizing state.
     */
    val optimizingTime: Instant? = builder.optimizingTime
    /**
     * The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended for future use.
     */
    val ownerAlias: String? = builder.ownerAlias
    /**
     * The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The ID of the snapshot.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * The state of fast snapshot restores.
     */
    val state: FastSnapshotRestoreStateCode? = builder.state
    /**
     * The reason for the state transition. The possible values are as follows:
     * Client.UserInitiated - The state successfully transitioned to enabling or
     * disabling.
     * Client.UserInitiated - Lifecycle state transition - The state successfully transitioned
     * to optimizing, enabled, or disabled.
     */
    val stateTransitionReason: String? = builder.stateTransitionReason

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EnableFastSnapshotRestoreSuccessItem = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EnableFastSnapshotRestoreSuccessItem(")
        append("availabilityZone=$availabilityZone,")
        append("disabledTime=$disabledTime,")
        append("disablingTime=$disablingTime,")
        append("enabledTime=$enabledTime,")
        append("enablingTime=$enablingTime,")
        append("optimizingTime=$optimizingTime,")
        append("ownerAlias=$ownerAlias,")
        append("ownerId=$ownerId,")
        append("snapshotId=$snapshotId,")
        append("state=$state,")
        append("stateTransitionReason=$stateTransitionReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (disabledTime?.hashCode() ?: 0)
        result = 31 * result + (disablingTime?.hashCode() ?: 0)
        result = 31 * result + (enabledTime?.hashCode() ?: 0)
        result = 31 * result + (enablingTime?.hashCode() ?: 0)
        result = 31 * result + (optimizingTime?.hashCode() ?: 0)
        result = 31 * result + (ownerAlias?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateTransitionReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EnableFastSnapshotRestoreSuccessItem

        if (availabilityZone != other.availabilityZone) return false
        if (disabledTime != other.disabledTime) return false
        if (disablingTime != other.disablingTime) return false
        if (enabledTime != other.enabledTime) return false
        if (enablingTime != other.enablingTime) return false
        if (optimizingTime != other.optimizingTime) return false
        if (ownerAlias != other.ownerAlias) return false
        if (ownerId != other.ownerId) return false
        if (snapshotId != other.snapshotId) return false
        if (state != other.state) return false
        if (stateTransitionReason != other.stateTransitionReason) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EnableFastSnapshotRestoreSuccessItem = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EnableFastSnapshotRestoreSuccessItem
        /**
         * The Availability Zone.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The time at which fast snapshot restores entered the disabled state.
         */
        fun disabledTime(disabledTime: Instant): FluentBuilder
        /**
         * The time at which fast snapshot restores entered the disabling state.
         */
        fun disablingTime(disablingTime: Instant): FluentBuilder
        /**
         * The time at which fast snapshot restores entered the enabled state.
         */
        fun enabledTime(enabledTime: Instant): FluentBuilder
        /**
         * The time at which fast snapshot restores entered the enabling state.
         */
        fun enablingTime(enablingTime: Instant): FluentBuilder
        /**
         * The time at which fast snapshot restores entered the optimizing state.
         */
        fun optimizingTime(optimizingTime: Instant): FluentBuilder
        /**
         * The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended for future use.
         */
        fun ownerAlias(ownerAlias: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The ID of the snapshot.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * The state of fast snapshot restores.
         */
        fun state(state: FastSnapshotRestoreStateCode): FluentBuilder
        /**
         * The reason for the state transition. The possible values are as follows:
         * Client.UserInitiated - The state successfully transitioned to enabling or
         * disabling.
         * Client.UserInitiated - Lifecycle state transition - The state successfully transitioned
         * to optimizing, enabled, or disabled.
         */
        fun stateTransitionReason(stateTransitionReason: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone.
         */
        var availabilityZone: String?
        /**
         * The time at which fast snapshot restores entered the disabled state.
         */
        var disabledTime: Instant?
        /**
         * The time at which fast snapshot restores entered the disabling state.
         */
        var disablingTime: Instant?
        /**
         * The time at which fast snapshot restores entered the enabled state.
         */
        var enabledTime: Instant?
        /**
         * The time at which fast snapshot restores entered the enabling state.
         */
        var enablingTime: Instant?
        /**
         * The time at which fast snapshot restores entered the optimizing state.
         */
        var optimizingTime: Instant?
        /**
         * The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended for future use.
         */
        var ownerAlias: String?
        /**
         * The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.
         */
        var ownerId: String?
        /**
         * The ID of the snapshot.
         */
        var snapshotId: String?
        /**
         * The state of fast snapshot restores.
         */
        var state: FastSnapshotRestoreStateCode?
        /**
         * The reason for the state transition. The possible values are as follows:
         * Client.UserInitiated - The state successfully transitioned to enabling or
         * disabling.
         * Client.UserInitiated - Lifecycle state transition - The state successfully transitioned
         * to optimizing, enabled, or disabled.
         */
        var stateTransitionReason: String?

        fun build(): EnableFastSnapshotRestoreSuccessItem
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var disabledTime: Instant? = null
        override var disablingTime: Instant? = null
        override var enabledTime: Instant? = null
        override var enablingTime: Instant? = null
        override var optimizingTime: Instant? = null
        override var ownerAlias: String? = null
        override var ownerId: String? = null
        override var snapshotId: String? = null
        override var state: FastSnapshotRestoreStateCode? = null
        override var stateTransitionReason: String? = null

        constructor(x: EnableFastSnapshotRestoreSuccessItem) : this() {
            this.availabilityZone = x.availabilityZone
            this.disabledTime = x.disabledTime
            this.disablingTime = x.disablingTime
            this.enabledTime = x.enabledTime
            this.enablingTime = x.enablingTime
            this.optimizingTime = x.optimizingTime
            this.ownerAlias = x.ownerAlias
            this.ownerId = x.ownerId
            this.snapshotId = x.snapshotId
            this.state = x.state
            this.stateTransitionReason = x.stateTransitionReason
        }

        override fun build(): EnableFastSnapshotRestoreSuccessItem = EnableFastSnapshotRestoreSuccessItem(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun disabledTime(disabledTime: Instant): FluentBuilder = apply { this.disabledTime = disabledTime }
        override fun disablingTime(disablingTime: Instant): FluentBuilder = apply { this.disablingTime = disablingTime }
        override fun enabledTime(enabledTime: Instant): FluentBuilder = apply { this.enabledTime = enabledTime }
        override fun enablingTime(enablingTime: Instant): FluentBuilder = apply { this.enablingTime = enablingTime }
        override fun optimizingTime(optimizingTime: Instant): FluentBuilder = apply { this.optimizingTime = optimizingTime }
        override fun ownerAlias(ownerAlias: String): FluentBuilder = apply { this.ownerAlias = ownerAlias }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun state(state: FastSnapshotRestoreStateCode): FluentBuilder = apply { this.state = state }
        override fun stateTransitionReason(stateTransitionReason: String): FluentBuilder = apply { this.stateTransitionReason = stateTransitionReason }
    }
}
