// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an EC2 Fleet or Spot Fleet event.
 */
class EventInformation private constructor(builder: BuilderImpl) {
    /**
     * The description of the event.
     */
    val eventDescription: String? = builder.eventDescription
    /**
     * The event.
     * error events:
     * iamFleetRoleInvalid - The EC2 Fleet or Spot Fleet does not have the required
     * permissions either to launch or terminate an instance.
     * allLaunchSpecsTemporarilyBlacklisted - None of the configurations
     * are valid, and several attempts to launch instances have failed. For more
     * information, see the description of the event.
     * spotInstanceCountLimitExceeded - You've reached the limit on the
     * number of Spot Instances that you can launch.
     * spotFleetRequestConfigurationInvalid - The configuration is not
     * valid. For more information, see the description of the event.
     * fleetRequestChange events:
     * active - The EC2 Fleet or Spot Fleet request has been validated and Amazon EC2 is
     * attempting to maintain the target number of running instances.
     * cancelled - The EC2 Fleet or Spot Fleet request is canceled and has no running
     * instances. The EC2 Fleet or Spot Fleet will be deleted two days after its instances are
     * terminated.
     * cancelled_running - The EC2 Fleet or Spot Fleet request is canceled and does
     * not launch additional instances. Its existing instances continue to run until
     * they are interrupted or terminated. The request remains in this state until all
     * instances are interrupted or terminated.
     * cancelled_terminating - The EC2 Fleet or Spot Fleet request is canceled and
     * its instances are terminating. The request remains in this state until all
     * instances are terminated.
     * expired - The EC2 Fleet or Spot Fleet request has expired. If the request was
     * created with TerminateInstancesWithExpiration set, a subsequent
     * terminated event indicates that the instances are
     * terminated.
     * modify_in_progress - The EC2 Fleet or Spot Fleet request is being modified.
     * The request remains in this state until the modification is fully
     * processed.
     * modify_succeeded - The EC2 Fleet or Spot Fleet request was modified.
     * submitted - The EC2 Fleet or Spot Fleet request is being evaluated and Amazon EC2
     * is preparing to launch the target number of instances.
     * progress - The EC2 Fleet or Spot Fleet request is in the process of being fulfilled.
     * instanceChange events:
     * launched - A new instance was launched.
     * terminated - An instance was terminated by the user.
     * termination_notified - An instance termination notification was
     * sent when a Spot Instance was terminated by Amazon EC2 during scale-down, when the target
     * capacity of the fleet was modified down, for example, from a target capacity of
     * 4 to a target capacity of 3.
     * Information events:
     * fleetProgressHalted - The price in every launch specification is
     * not valid because it is below the Spot price (all the launch specifications have
     * produced launchSpecUnusable events). A launch specification might
     * become valid if the Spot price changes.
     * launchSpecTemporarilyBlacklisted - The configuration is not valid
     * and several attempts to launch instances have failed. For more information, see
     * the description of the event.
     * launchSpecUnusable - The price in a launch specification is not
     * valid because it is below the Spot price.
     * registerWithLoadBalancersFailed - An attempt to register
     * instances with load balancers failed. For more information, see the description
     * of the event.
     */
    val eventSubType: String? = builder.eventSubType
    /**
     * The ID of the instance. This information is available only for
     * instanceChange events.
     */
    val instanceId: String? = builder.instanceId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EventInformation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EventInformation(")
        append("eventDescription=$eventDescription,")
        append("eventSubType=$eventSubType,")
        append("instanceId=$instanceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventDescription?.hashCode() ?: 0
        result = 31 * result + (eventSubType?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EventInformation

        if (eventDescription != other.eventDescription) return false
        if (eventSubType != other.eventSubType) return false
        if (instanceId != other.instanceId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EventInformation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EventInformation
        /**
         * The description of the event.
         */
        fun eventDescription(eventDescription: String): FluentBuilder
        /**
         * The event.
         * error events:
         * iamFleetRoleInvalid - The EC2 Fleet or Spot Fleet does not have the required
         * permissions either to launch or terminate an instance.
         * allLaunchSpecsTemporarilyBlacklisted - None of the configurations
         * are valid, and several attempts to launch instances have failed. For more
         * information, see the description of the event.
         * spotInstanceCountLimitExceeded - You've reached the limit on the
         * number of Spot Instances that you can launch.
         * spotFleetRequestConfigurationInvalid - The configuration is not
         * valid. For more information, see the description of the event.
         * fleetRequestChange events:
         * active - The EC2 Fleet or Spot Fleet request has been validated and Amazon EC2 is
         * attempting to maintain the target number of running instances.
         * cancelled - The EC2 Fleet or Spot Fleet request is canceled and has no running
         * instances. The EC2 Fleet or Spot Fleet will be deleted two days after its instances are
         * terminated.
         * cancelled_running - The EC2 Fleet or Spot Fleet request is canceled and does
         * not launch additional instances. Its existing instances continue to run until
         * they are interrupted or terminated. The request remains in this state until all
         * instances are interrupted or terminated.
         * cancelled_terminating - The EC2 Fleet or Spot Fleet request is canceled and
         * its instances are terminating. The request remains in this state until all
         * instances are terminated.
         * expired - The EC2 Fleet or Spot Fleet request has expired. If the request was
         * created with TerminateInstancesWithExpiration set, a subsequent
         * terminated event indicates that the instances are
         * terminated.
         * modify_in_progress - The EC2 Fleet or Spot Fleet request is being modified.
         * The request remains in this state until the modification is fully
         * processed.
         * modify_succeeded - The EC2 Fleet or Spot Fleet request was modified.
         * submitted - The EC2 Fleet or Spot Fleet request is being evaluated and Amazon EC2
         * is preparing to launch the target number of instances.
         * progress - The EC2 Fleet or Spot Fleet request is in the process of being fulfilled.
         * instanceChange events:
         * launched - A new instance was launched.
         * terminated - An instance was terminated by the user.
         * termination_notified - An instance termination notification was
         * sent when a Spot Instance was terminated by Amazon EC2 during scale-down, when the target
         * capacity of the fleet was modified down, for example, from a target capacity of
         * 4 to a target capacity of 3.
         * Information events:
         * fleetProgressHalted - The price in every launch specification is
         * not valid because it is below the Spot price (all the launch specifications have
         * produced launchSpecUnusable events). A launch specification might
         * become valid if the Spot price changes.
         * launchSpecTemporarilyBlacklisted - The configuration is not valid
         * and several attempts to launch instances have failed. For more information, see
         * the description of the event.
         * launchSpecUnusable - The price in a launch specification is not
         * valid because it is below the Spot price.
         * registerWithLoadBalancersFailed - An attempt to register
         * instances with load balancers failed. For more information, see the description
         * of the event.
         */
        fun eventSubType(eventSubType: String): FluentBuilder
        /**
         * The ID of the instance. This information is available only for
         * instanceChange events.
         */
        fun instanceId(instanceId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the event.
         */
        var eventDescription: String?
        /**
         * The event.
         * error events:
         * iamFleetRoleInvalid - The EC2 Fleet or Spot Fleet does not have the required
         * permissions either to launch or terminate an instance.
         * allLaunchSpecsTemporarilyBlacklisted - None of the configurations
         * are valid, and several attempts to launch instances have failed. For more
         * information, see the description of the event.
         * spotInstanceCountLimitExceeded - You've reached the limit on the
         * number of Spot Instances that you can launch.
         * spotFleetRequestConfigurationInvalid - The configuration is not
         * valid. For more information, see the description of the event.
         * fleetRequestChange events:
         * active - The EC2 Fleet or Spot Fleet request has been validated and Amazon EC2 is
         * attempting to maintain the target number of running instances.
         * cancelled - The EC2 Fleet or Spot Fleet request is canceled and has no running
         * instances. The EC2 Fleet or Spot Fleet will be deleted two days after its instances are
         * terminated.
         * cancelled_running - The EC2 Fleet or Spot Fleet request is canceled and does
         * not launch additional instances. Its existing instances continue to run until
         * they are interrupted or terminated. The request remains in this state until all
         * instances are interrupted or terminated.
         * cancelled_terminating - The EC2 Fleet or Spot Fleet request is canceled and
         * its instances are terminating. The request remains in this state until all
         * instances are terminated.
         * expired - The EC2 Fleet or Spot Fleet request has expired. If the request was
         * created with TerminateInstancesWithExpiration set, a subsequent
         * terminated event indicates that the instances are
         * terminated.
         * modify_in_progress - The EC2 Fleet or Spot Fleet request is being modified.
         * The request remains in this state until the modification is fully
         * processed.
         * modify_succeeded - The EC2 Fleet or Spot Fleet request was modified.
         * submitted - The EC2 Fleet or Spot Fleet request is being evaluated and Amazon EC2
         * is preparing to launch the target number of instances.
         * progress - The EC2 Fleet or Spot Fleet request is in the process of being fulfilled.
         * instanceChange events:
         * launched - A new instance was launched.
         * terminated - An instance was terminated by the user.
         * termination_notified - An instance termination notification was
         * sent when a Spot Instance was terminated by Amazon EC2 during scale-down, when the target
         * capacity of the fleet was modified down, for example, from a target capacity of
         * 4 to a target capacity of 3.
         * Information events:
         * fleetProgressHalted - The price in every launch specification is
         * not valid because it is below the Spot price (all the launch specifications have
         * produced launchSpecUnusable events). A launch specification might
         * become valid if the Spot price changes.
         * launchSpecTemporarilyBlacklisted - The configuration is not valid
         * and several attempts to launch instances have failed. For more information, see
         * the description of the event.
         * launchSpecUnusable - The price in a launch specification is not
         * valid because it is below the Spot price.
         * registerWithLoadBalancersFailed - An attempt to register
         * instances with load balancers failed. For more information, see the description
         * of the event.
         */
        var eventSubType: String?
        /**
         * The ID of the instance. This information is available only for
         * instanceChange events.
         */
        var instanceId: String?

        fun build(): EventInformation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var eventDescription: String? = null
        override var eventSubType: String? = null
        override var instanceId: String? = null

        constructor(x: EventInformation) : this() {
            this.eventDescription = x.eventDescription
            this.eventSubType = x.eventSubType
            this.instanceId = x.instanceId
        }

        override fun build(): EventInformation = EventInformation(this)
        override fun eventDescription(eventDescription: String): FluentBuilder = apply { this.eventDescription = eventDescription }
        override fun eventSubType(eventSubType: String): FluentBuilder = apply { this.eventSubType = eventSubType }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
    }
}
