// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an explanation code for an unreachable path. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes.
 */
class Explanation private constructor(builder: BuilderImpl) {
    /**
     * The network ACL.
     */
    val acl: AnalysisComponent? = builder.acl
    /**
     * The network ACL rule.
     */
    val aclRule: AnalysisAclRule? = builder.aclRule
    /**
     * The IPv4 address, in CIDR notation.
     */
    val address: String? = builder.address
    /**
     * The IPv4 addresses, in CIDR notation.
     */
    val addresses: List<String>? = builder.addresses
    /**
     * The resource to which the component is attached.
     */
    val attachedTo: AnalysisComponent? = builder.attachedTo
    /**
     * The Availability Zones.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The CIDR ranges.
     */
    val cidrs: List<String>? = builder.cidrs
    /**
     * The listener for a Classic Load Balancer.
     */
    val classicLoadBalancerListener: AnalysisLoadBalancerListener? = builder.classicLoadBalancerListener
    /**
     * The component.
     */
    val component: AnalysisComponent? = builder.component
    /**
     * The customer gateway.
     */
    val customerGateway: AnalysisComponent? = builder.customerGateway
    /**
     * The destination.
     */
    val destination: AnalysisComponent? = builder.destination
    /**
     * The destination VPC.
     */
    val destinationVpc: AnalysisComponent? = builder.destinationVpc
    /**
     * The direction. The following are possible values:
     * egress
     * ingress
     */
    val direction: String? = builder.direction
    /**
     * The load balancer listener.
     */
    val elasticLoadBalancerListener: AnalysisComponent? = builder.elasticLoadBalancerListener
    /**
     * The explanation code.
     */
    val explanationCode: String? = builder.explanationCode
    /**
     * The route table.
     */
    val ingressRouteTable: AnalysisComponent? = builder.ingressRouteTable
    /**
     * The internet gateway.
     */
    val internetGateway: AnalysisComponent? = builder.internetGateway
    /**
     * The Amazon Resource Name (ARN) of the load balancer.
     */
    val loadBalancerArn: String? = builder.loadBalancerArn
    /**
     * The listener port of the load balancer.
     */
    val loadBalancerListenerPort: Int? = builder.loadBalancerListenerPort
    /**
     * The target.
     */
    val loadBalancerTarget: AnalysisLoadBalancerTarget? = builder.loadBalancerTarget
    /**
     * The target group.
     */
    val loadBalancerTargetGroup: AnalysisComponent? = builder.loadBalancerTargetGroup
    /**
     * The target groups.
     */
    val loadBalancerTargetGroups: List<AnalysisComponent>? = builder.loadBalancerTargetGroups
    /**
     * The target port.
     */
    val loadBalancerTargetPort: Int? = builder.loadBalancerTargetPort
    /**
     * The missing component.
     */
    val missingComponent: String? = builder.missingComponent
    /**
     * The NAT gateway.
     */
    val natGateway: AnalysisComponent? = builder.natGateway
    /**
     * The network interface.
     */
    val networkInterface: AnalysisComponent? = builder.networkInterface
    /**
     * The packet field.
     */
    val packetField: String? = builder.packetField
    /**
     * The port.
     */
    val port: Int? = builder.port
    /**
     * The port ranges.
     */
    val portRanges: List<PortRange>? = builder.portRanges
    /**
     * The prefix list.
     */
    val prefixList: AnalysisComponent? = builder.prefixList
    /**
     * The protocols.
     */
    val protocols: List<String>? = builder.protocols
    /**
     * The route table.
     */
    val routeTable: AnalysisComponent? = builder.routeTable
    /**
     * The route table route.
     */
    val routeTableRoute: AnalysisRouteTableRoute? = builder.routeTableRoute
    /**
     * The security group.
     */
    val securityGroup: AnalysisComponent? = builder.securityGroup
    /**
     * The security group rule.
     */
    val securityGroupRule: AnalysisSecurityGroupRule? = builder.securityGroupRule
    /**
     * The security groups.
     */
    val securityGroups: List<AnalysisComponent>? = builder.securityGroups
    /**
     * The source VPC.
     */
    val sourceVpc: AnalysisComponent? = builder.sourceVpc
    /**
     * The state.
     */
    val state: String? = builder.state
    /**
     * The subnet.
     */
    val subnet: AnalysisComponent? = builder.subnet
    /**
     * The route table for the subnet.
     */
    val subnetRouteTable: AnalysisComponent? = builder.subnetRouteTable
    /**
     * The component VPC.
     */
    val vpc: AnalysisComponent? = builder.vpc
    /**
     * The VPC endpoint.
     */
    val vpcEndpoint: AnalysisComponent? = builder.vpcEndpoint
    /**
     * The VPC peering connection.
     */
    val vpcPeeringConnection: AnalysisComponent? = builder.vpcPeeringConnection
    /**
     * The VPN connection.
     */
    val vpnConnection: AnalysisComponent? = builder.vpnConnection
    /**
     * The VPN gateway.
     */
    val vpnGateway: AnalysisComponent? = builder.vpnGateway

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Explanation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Explanation(")
        append("acl=$acl,")
        append("aclRule=$aclRule,")
        append("address=$address,")
        append("addresses=$addresses,")
        append("attachedTo=$attachedTo,")
        append("availabilityZones=$availabilityZones,")
        append("cidrs=$cidrs,")
        append("classicLoadBalancerListener=$classicLoadBalancerListener,")
        append("component=$component,")
        append("customerGateway=$customerGateway,")
        append("destination=$destination,")
        append("destinationVpc=$destinationVpc,")
        append("direction=$direction,")
        append("elasticLoadBalancerListener=$elasticLoadBalancerListener,")
        append("explanationCode=$explanationCode,")
        append("ingressRouteTable=$ingressRouteTable,")
        append("internetGateway=$internetGateway,")
        append("loadBalancerArn=$loadBalancerArn,")
        append("loadBalancerListenerPort=$loadBalancerListenerPort,")
        append("loadBalancerTarget=$loadBalancerTarget,")
        append("loadBalancerTargetGroup=$loadBalancerTargetGroup,")
        append("loadBalancerTargetGroups=$loadBalancerTargetGroups,")
        append("loadBalancerTargetPort=$loadBalancerTargetPort,")
        append("missingComponent=$missingComponent,")
        append("natGateway=$natGateway,")
        append("networkInterface=$networkInterface,")
        append("packetField=$packetField,")
        append("port=$port,")
        append("portRanges=$portRanges,")
        append("prefixList=$prefixList,")
        append("protocols=$protocols,")
        append("routeTable=$routeTable,")
        append("routeTableRoute=$routeTableRoute,")
        append("securityGroup=$securityGroup,")
        append("securityGroupRule=$securityGroupRule,")
        append("securityGroups=$securityGroups,")
        append("sourceVpc=$sourceVpc,")
        append("state=$state,")
        append("subnet=$subnet,")
        append("subnetRouteTable=$subnetRouteTable,")
        append("vpc=$vpc,")
        append("vpcEndpoint=$vpcEndpoint,")
        append("vpcPeeringConnection=$vpcPeeringConnection,")
        append("vpnConnection=$vpnConnection,")
        append("vpnGateway=$vpnGateway)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acl?.hashCode() ?: 0
        result = 31 * result + (aclRule?.hashCode() ?: 0)
        result = 31 * result + (address?.hashCode() ?: 0)
        result = 31 * result + (addresses?.hashCode() ?: 0)
        result = 31 * result + (attachedTo?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (cidrs?.hashCode() ?: 0)
        result = 31 * result + (classicLoadBalancerListener?.hashCode() ?: 0)
        result = 31 * result + (component?.hashCode() ?: 0)
        result = 31 * result + (customerGateway?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (destinationVpc?.hashCode() ?: 0)
        result = 31 * result + (direction?.hashCode() ?: 0)
        result = 31 * result + (elasticLoadBalancerListener?.hashCode() ?: 0)
        result = 31 * result + (explanationCode?.hashCode() ?: 0)
        result = 31 * result + (ingressRouteTable?.hashCode() ?: 0)
        result = 31 * result + (internetGateway?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerArn?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerListenerPort ?: 0)
        result = 31 * result + (loadBalancerTarget?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerTargetGroup?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerTargetGroups?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerTargetPort ?: 0)
        result = 31 * result + (missingComponent?.hashCode() ?: 0)
        result = 31 * result + (natGateway?.hashCode() ?: 0)
        result = 31 * result + (networkInterface?.hashCode() ?: 0)
        result = 31 * result + (packetField?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (portRanges?.hashCode() ?: 0)
        result = 31 * result + (prefixList?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (routeTable?.hashCode() ?: 0)
        result = 31 * result + (routeTableRoute?.hashCode() ?: 0)
        result = 31 * result + (securityGroup?.hashCode() ?: 0)
        result = 31 * result + (securityGroupRule?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sourceVpc?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnet?.hashCode() ?: 0)
        result = 31 * result + (subnetRouteTable?.hashCode() ?: 0)
        result = 31 * result + (vpc?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpoint?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnection?.hashCode() ?: 0)
        result = 31 * result + (vpnConnection?.hashCode() ?: 0)
        result = 31 * result + (vpnGateway?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Explanation

        if (acl != other.acl) return false
        if (aclRule != other.aclRule) return false
        if (address != other.address) return false
        if (addresses != other.addresses) return false
        if (attachedTo != other.attachedTo) return false
        if (availabilityZones != other.availabilityZones) return false
        if (cidrs != other.cidrs) return false
        if (classicLoadBalancerListener != other.classicLoadBalancerListener) return false
        if (component != other.component) return false
        if (customerGateway != other.customerGateway) return false
        if (destination != other.destination) return false
        if (destinationVpc != other.destinationVpc) return false
        if (direction != other.direction) return false
        if (elasticLoadBalancerListener != other.elasticLoadBalancerListener) return false
        if (explanationCode != other.explanationCode) return false
        if (ingressRouteTable != other.ingressRouteTable) return false
        if (internetGateway != other.internetGateway) return false
        if (loadBalancerArn != other.loadBalancerArn) return false
        if (loadBalancerListenerPort != other.loadBalancerListenerPort) return false
        if (loadBalancerTarget != other.loadBalancerTarget) return false
        if (loadBalancerTargetGroup != other.loadBalancerTargetGroup) return false
        if (loadBalancerTargetGroups != other.loadBalancerTargetGroups) return false
        if (loadBalancerTargetPort != other.loadBalancerTargetPort) return false
        if (missingComponent != other.missingComponent) return false
        if (natGateway != other.natGateway) return false
        if (networkInterface != other.networkInterface) return false
        if (packetField != other.packetField) return false
        if (port != other.port) return false
        if (portRanges != other.portRanges) return false
        if (prefixList != other.prefixList) return false
        if (protocols != other.protocols) return false
        if (routeTable != other.routeTable) return false
        if (routeTableRoute != other.routeTableRoute) return false
        if (securityGroup != other.securityGroup) return false
        if (securityGroupRule != other.securityGroupRule) return false
        if (securityGroups != other.securityGroups) return false
        if (sourceVpc != other.sourceVpc) return false
        if (state != other.state) return false
        if (subnet != other.subnet) return false
        if (subnetRouteTable != other.subnetRouteTable) return false
        if (vpc != other.vpc) return false
        if (vpcEndpoint != other.vpcEndpoint) return false
        if (vpcPeeringConnection != other.vpcPeeringConnection) return false
        if (vpnConnection != other.vpnConnection) return false
        if (vpnGateway != other.vpnGateway) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Explanation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Explanation
        /**
         * The network ACL.
         */
        fun acl(acl: AnalysisComponent): FluentBuilder
        /**
         * The network ACL rule.
         */
        fun aclRule(aclRule: AnalysisAclRule): FluentBuilder
        /**
         * The IPv4 address, in CIDR notation.
         */
        fun address(address: String): FluentBuilder
        /**
         * The IPv4 addresses, in CIDR notation.
         */
        fun addresses(addresses: List<String>): FluentBuilder
        /**
         * The resource to which the component is attached.
         */
        fun attachedTo(attachedTo: AnalysisComponent): FluentBuilder
        /**
         * The Availability Zones.
         */
        fun availabilityZones(availabilityZones: List<String>): FluentBuilder
        /**
         * The CIDR ranges.
         */
        fun cidrs(cidrs: List<String>): FluentBuilder
        /**
         * The listener for a Classic Load Balancer.
         */
        fun classicLoadBalancerListener(classicLoadBalancerListener: AnalysisLoadBalancerListener): FluentBuilder
        /**
         * The component.
         */
        fun component(component: AnalysisComponent): FluentBuilder
        /**
         * The customer gateway.
         */
        fun customerGateway(customerGateway: AnalysisComponent): FluentBuilder
        /**
         * The destination.
         */
        fun destination(destination: AnalysisComponent): FluentBuilder
        /**
         * The destination VPC.
         */
        fun destinationVpc(destinationVpc: AnalysisComponent): FluentBuilder
        /**
         * The direction. The following are possible values:
         * egress
         * ingress
         */
        fun direction(direction: String): FluentBuilder
        /**
         * The load balancer listener.
         */
        fun elasticLoadBalancerListener(elasticLoadBalancerListener: AnalysisComponent): FluentBuilder
        /**
         * The explanation code.
         */
        fun explanationCode(explanationCode: String): FluentBuilder
        /**
         * The route table.
         */
        fun ingressRouteTable(ingressRouteTable: AnalysisComponent): FluentBuilder
        /**
         * The internet gateway.
         */
        fun internetGateway(internetGateway: AnalysisComponent): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the load balancer.
         */
        fun loadBalancerArn(loadBalancerArn: String): FluentBuilder
        /**
         * The listener port of the load balancer.
         */
        fun loadBalancerListenerPort(loadBalancerListenerPort: Int): FluentBuilder
        /**
         * The target.
         */
        fun loadBalancerTarget(loadBalancerTarget: AnalysisLoadBalancerTarget): FluentBuilder
        /**
         * The target group.
         */
        fun loadBalancerTargetGroup(loadBalancerTargetGroup: AnalysisComponent): FluentBuilder
        /**
         * The target groups.
         */
        fun loadBalancerTargetGroups(loadBalancerTargetGroups: List<AnalysisComponent>): FluentBuilder
        /**
         * The target port.
         */
        fun loadBalancerTargetPort(loadBalancerTargetPort: Int): FluentBuilder
        /**
         * The missing component.
         */
        fun missingComponent(missingComponent: String): FluentBuilder
        /**
         * The NAT gateway.
         */
        fun natGateway(natGateway: AnalysisComponent): FluentBuilder
        /**
         * The network interface.
         */
        fun networkInterface(networkInterface: AnalysisComponent): FluentBuilder
        /**
         * The packet field.
         */
        fun packetField(packetField: String): FluentBuilder
        /**
         * The port.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The port ranges.
         */
        fun portRanges(portRanges: List<PortRange>): FluentBuilder
        /**
         * The prefix list.
         */
        fun prefixList(prefixList: AnalysisComponent): FluentBuilder
        /**
         * The protocols.
         */
        fun protocols(protocols: List<String>): FluentBuilder
        /**
         * The route table.
         */
        fun routeTable(routeTable: AnalysisComponent): FluentBuilder
        /**
         * The route table route.
         */
        fun routeTableRoute(routeTableRoute: AnalysisRouteTableRoute): FluentBuilder
        /**
         * The security group.
         */
        fun securityGroup(securityGroup: AnalysisComponent): FluentBuilder
        /**
         * The security group rule.
         */
        fun securityGroupRule(securityGroupRule: AnalysisSecurityGroupRule): FluentBuilder
        /**
         * The security groups.
         */
        fun securityGroups(securityGroups: List<AnalysisComponent>): FluentBuilder
        /**
         * The source VPC.
         */
        fun sourceVpc(sourceVpc: AnalysisComponent): FluentBuilder
        /**
         * The state.
         */
        fun state(state: String): FluentBuilder
        /**
         * The subnet.
         */
        fun subnet(subnet: AnalysisComponent): FluentBuilder
        /**
         * The route table for the subnet.
         */
        fun subnetRouteTable(subnetRouteTable: AnalysisComponent): FluentBuilder
        /**
         * The component VPC.
         */
        fun vpc(vpc: AnalysisComponent): FluentBuilder
        /**
         * The VPC endpoint.
         */
        fun vpcEndpoint(vpcEndpoint: AnalysisComponent): FluentBuilder
        /**
         * The VPC peering connection.
         */
        fun vpcPeeringConnection(vpcPeeringConnection: AnalysisComponent): FluentBuilder
        /**
         * The VPN connection.
         */
        fun vpnConnection(vpnConnection: AnalysisComponent): FluentBuilder
        /**
         * The VPN gateway.
         */
        fun vpnGateway(vpnGateway: AnalysisComponent): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The network ACL.
         */
        var acl: AnalysisComponent?
        /**
         * The network ACL rule.
         */
        var aclRule: AnalysisAclRule?
        /**
         * The IPv4 address, in CIDR notation.
         */
        var address: String?
        /**
         * The IPv4 addresses, in CIDR notation.
         */
        var addresses: List<String>?
        /**
         * The resource to which the component is attached.
         */
        var attachedTo: AnalysisComponent?
        /**
         * The Availability Zones.
         */
        var availabilityZones: List<String>?
        /**
         * The CIDR ranges.
         */
        var cidrs: List<String>?
        /**
         * The listener for a Classic Load Balancer.
         */
        var classicLoadBalancerListener: AnalysisLoadBalancerListener?
        /**
         * The component.
         */
        var component: AnalysisComponent?
        /**
         * The customer gateway.
         */
        var customerGateway: AnalysisComponent?
        /**
         * The destination.
         */
        var destination: AnalysisComponent?
        /**
         * The destination VPC.
         */
        var destinationVpc: AnalysisComponent?
        /**
         * The direction. The following are possible values:
         * egress
         * ingress
         */
        var direction: String?
        /**
         * The load balancer listener.
         */
        var elasticLoadBalancerListener: AnalysisComponent?
        /**
         * The explanation code.
         */
        var explanationCode: String?
        /**
         * The route table.
         */
        var ingressRouteTable: AnalysisComponent?
        /**
         * The internet gateway.
         */
        var internetGateway: AnalysisComponent?
        /**
         * The Amazon Resource Name (ARN) of the load balancer.
         */
        var loadBalancerArn: String?
        /**
         * The listener port of the load balancer.
         */
        var loadBalancerListenerPort: Int?
        /**
         * The target.
         */
        var loadBalancerTarget: AnalysisLoadBalancerTarget?
        /**
         * The target group.
         */
        var loadBalancerTargetGroup: AnalysisComponent?
        /**
         * The target groups.
         */
        var loadBalancerTargetGroups: List<AnalysisComponent>?
        /**
         * The target port.
         */
        var loadBalancerTargetPort: Int?
        /**
         * The missing component.
         */
        var missingComponent: String?
        /**
         * The NAT gateway.
         */
        var natGateway: AnalysisComponent?
        /**
         * The network interface.
         */
        var networkInterface: AnalysisComponent?
        /**
         * The packet field.
         */
        var packetField: String?
        /**
         * The port.
         */
        var port: Int?
        /**
         * The port ranges.
         */
        var portRanges: List<PortRange>?
        /**
         * The prefix list.
         */
        var prefixList: AnalysisComponent?
        /**
         * The protocols.
         */
        var protocols: List<String>?
        /**
         * The route table.
         */
        var routeTable: AnalysisComponent?
        /**
         * The route table route.
         */
        var routeTableRoute: AnalysisRouteTableRoute?
        /**
         * The security group.
         */
        var securityGroup: AnalysisComponent?
        /**
         * The security group rule.
         */
        var securityGroupRule: AnalysisSecurityGroupRule?
        /**
         * The security groups.
         */
        var securityGroups: List<AnalysisComponent>?
        /**
         * The source VPC.
         */
        var sourceVpc: AnalysisComponent?
        /**
         * The state.
         */
        var state: String?
        /**
         * The subnet.
         */
        var subnet: AnalysisComponent?
        /**
         * The route table for the subnet.
         */
        var subnetRouteTable: AnalysisComponent?
        /**
         * The component VPC.
         */
        var vpc: AnalysisComponent?
        /**
         * The VPC endpoint.
         */
        var vpcEndpoint: AnalysisComponent?
        /**
         * The VPC peering connection.
         */
        var vpcPeeringConnection: AnalysisComponent?
        /**
         * The VPN connection.
         */
        var vpnConnection: AnalysisComponent?
        /**
         * The VPN gateway.
         */
        var vpnGateway: AnalysisComponent?

        fun build(): Explanation
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun acl(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.acl = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisAclRule] inside the given [block]
         */
        fun aclRule(block: AnalysisAclRule.DslBuilder.() -> kotlin.Unit) {
            this.aclRule = AnalysisAclRule.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun attachedTo(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.attachedTo = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisLoadBalancerListener] inside the given [block]
         */
        fun classicLoadBalancerListener(block: AnalysisLoadBalancerListener.DslBuilder.() -> kotlin.Unit) {
            this.classicLoadBalancerListener = AnalysisLoadBalancerListener.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun component(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.component = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun customerGateway(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.customerGateway = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun destination(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.destination = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun destinationVpc(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.destinationVpc = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun elasticLoadBalancerListener(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.elasticLoadBalancerListener = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun ingressRouteTable(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.ingressRouteTable = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun internetGateway(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.internetGateway = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisLoadBalancerTarget] inside the given [block]
         */
        fun loadBalancerTarget(block: AnalysisLoadBalancerTarget.DslBuilder.() -> kotlin.Unit) {
            this.loadBalancerTarget = AnalysisLoadBalancerTarget.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun loadBalancerTargetGroup(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.loadBalancerTargetGroup = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun natGateway(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.natGateway = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun networkInterface(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.networkInterface = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun prefixList(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.prefixList = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun routeTable(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.routeTable = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisRouteTableRoute] inside the given [block]
         */
        fun routeTableRoute(block: AnalysisRouteTableRoute.DslBuilder.() -> kotlin.Unit) {
            this.routeTableRoute = AnalysisRouteTableRoute.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun securityGroup(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.securityGroup = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisSecurityGroupRule] inside the given [block]
         */
        fun securityGroupRule(block: AnalysisSecurityGroupRule.DslBuilder.() -> kotlin.Unit) {
            this.securityGroupRule = AnalysisSecurityGroupRule.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun sourceVpc(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.sourceVpc = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun subnet(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.subnet = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun subnetRouteTable(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.subnetRouteTable = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun vpc(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.vpc = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun vpcEndpoint(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.vpcEndpoint = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun vpcPeeringConnection(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.vpcPeeringConnection = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun vpnConnection(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.vpnConnection = AnalysisComponent.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AnalysisComponent] inside the given [block]
         */
        fun vpnGateway(block: AnalysisComponent.DslBuilder.() -> kotlin.Unit) {
            this.vpnGateway = AnalysisComponent.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var acl: AnalysisComponent? = null
        override var aclRule: AnalysisAclRule? = null
        override var address: String? = null
        override var addresses: List<String>? = null
        override var attachedTo: AnalysisComponent? = null
        override var availabilityZones: List<String>? = null
        override var cidrs: List<String>? = null
        override var classicLoadBalancerListener: AnalysisLoadBalancerListener? = null
        override var component: AnalysisComponent? = null
        override var customerGateway: AnalysisComponent? = null
        override var destination: AnalysisComponent? = null
        override var destinationVpc: AnalysisComponent? = null
        override var direction: String? = null
        override var elasticLoadBalancerListener: AnalysisComponent? = null
        override var explanationCode: String? = null
        override var ingressRouteTable: AnalysisComponent? = null
        override var internetGateway: AnalysisComponent? = null
        override var loadBalancerArn: String? = null
        override var loadBalancerListenerPort: Int? = null
        override var loadBalancerTarget: AnalysisLoadBalancerTarget? = null
        override var loadBalancerTargetGroup: AnalysisComponent? = null
        override var loadBalancerTargetGroups: List<AnalysisComponent>? = null
        override var loadBalancerTargetPort: Int? = null
        override var missingComponent: String? = null
        override var natGateway: AnalysisComponent? = null
        override var networkInterface: AnalysisComponent? = null
        override var packetField: String? = null
        override var port: Int? = null
        override var portRanges: List<PortRange>? = null
        override var prefixList: AnalysisComponent? = null
        override var protocols: List<String>? = null
        override var routeTable: AnalysisComponent? = null
        override var routeTableRoute: AnalysisRouteTableRoute? = null
        override var securityGroup: AnalysisComponent? = null
        override var securityGroupRule: AnalysisSecurityGroupRule? = null
        override var securityGroups: List<AnalysisComponent>? = null
        override var sourceVpc: AnalysisComponent? = null
        override var state: String? = null
        override var subnet: AnalysisComponent? = null
        override var subnetRouteTable: AnalysisComponent? = null
        override var vpc: AnalysisComponent? = null
        override var vpcEndpoint: AnalysisComponent? = null
        override var vpcPeeringConnection: AnalysisComponent? = null
        override var vpnConnection: AnalysisComponent? = null
        override var vpnGateway: AnalysisComponent? = null

        constructor(x: Explanation) : this() {
            this.acl = x.acl
            this.aclRule = x.aclRule
            this.address = x.address
            this.addresses = x.addresses
            this.attachedTo = x.attachedTo
            this.availabilityZones = x.availabilityZones
            this.cidrs = x.cidrs
            this.classicLoadBalancerListener = x.classicLoadBalancerListener
            this.component = x.component
            this.customerGateway = x.customerGateway
            this.destination = x.destination
            this.destinationVpc = x.destinationVpc
            this.direction = x.direction
            this.elasticLoadBalancerListener = x.elasticLoadBalancerListener
            this.explanationCode = x.explanationCode
            this.ingressRouteTable = x.ingressRouteTable
            this.internetGateway = x.internetGateway
            this.loadBalancerArn = x.loadBalancerArn
            this.loadBalancerListenerPort = x.loadBalancerListenerPort
            this.loadBalancerTarget = x.loadBalancerTarget
            this.loadBalancerTargetGroup = x.loadBalancerTargetGroup
            this.loadBalancerTargetGroups = x.loadBalancerTargetGroups
            this.loadBalancerTargetPort = x.loadBalancerTargetPort
            this.missingComponent = x.missingComponent
            this.natGateway = x.natGateway
            this.networkInterface = x.networkInterface
            this.packetField = x.packetField
            this.port = x.port
            this.portRanges = x.portRanges
            this.prefixList = x.prefixList
            this.protocols = x.protocols
            this.routeTable = x.routeTable
            this.routeTableRoute = x.routeTableRoute
            this.securityGroup = x.securityGroup
            this.securityGroupRule = x.securityGroupRule
            this.securityGroups = x.securityGroups
            this.sourceVpc = x.sourceVpc
            this.state = x.state
            this.subnet = x.subnet
            this.subnetRouteTable = x.subnetRouteTable
            this.vpc = x.vpc
            this.vpcEndpoint = x.vpcEndpoint
            this.vpcPeeringConnection = x.vpcPeeringConnection
            this.vpnConnection = x.vpnConnection
            this.vpnGateway = x.vpnGateway
        }

        override fun build(): Explanation = Explanation(this)
        override fun acl(acl: AnalysisComponent): FluentBuilder = apply { this.acl = acl }
        override fun aclRule(aclRule: AnalysisAclRule): FluentBuilder = apply { this.aclRule = aclRule }
        override fun address(address: String): FluentBuilder = apply { this.address = address }
        override fun addresses(addresses: List<String>): FluentBuilder = apply { this.addresses = addresses }
        override fun attachedTo(attachedTo: AnalysisComponent): FluentBuilder = apply { this.attachedTo = attachedTo }
        override fun availabilityZones(availabilityZones: List<String>): FluentBuilder = apply { this.availabilityZones = availabilityZones }
        override fun cidrs(cidrs: List<String>): FluentBuilder = apply { this.cidrs = cidrs }
        override fun classicLoadBalancerListener(classicLoadBalancerListener: AnalysisLoadBalancerListener): FluentBuilder = apply { this.classicLoadBalancerListener = classicLoadBalancerListener }
        override fun component(component: AnalysisComponent): FluentBuilder = apply { this.component = component }
        override fun customerGateway(customerGateway: AnalysisComponent): FluentBuilder = apply { this.customerGateway = customerGateway }
        override fun destination(destination: AnalysisComponent): FluentBuilder = apply { this.destination = destination }
        override fun destinationVpc(destinationVpc: AnalysisComponent): FluentBuilder = apply { this.destinationVpc = destinationVpc }
        override fun direction(direction: String): FluentBuilder = apply { this.direction = direction }
        override fun elasticLoadBalancerListener(elasticLoadBalancerListener: AnalysisComponent): FluentBuilder = apply { this.elasticLoadBalancerListener = elasticLoadBalancerListener }
        override fun explanationCode(explanationCode: String): FluentBuilder = apply { this.explanationCode = explanationCode }
        override fun ingressRouteTable(ingressRouteTable: AnalysisComponent): FluentBuilder = apply { this.ingressRouteTable = ingressRouteTable }
        override fun internetGateway(internetGateway: AnalysisComponent): FluentBuilder = apply { this.internetGateway = internetGateway }
        override fun loadBalancerArn(loadBalancerArn: String): FluentBuilder = apply { this.loadBalancerArn = loadBalancerArn }
        override fun loadBalancerListenerPort(loadBalancerListenerPort: Int): FluentBuilder = apply { this.loadBalancerListenerPort = loadBalancerListenerPort }
        override fun loadBalancerTarget(loadBalancerTarget: AnalysisLoadBalancerTarget): FluentBuilder = apply { this.loadBalancerTarget = loadBalancerTarget }
        override fun loadBalancerTargetGroup(loadBalancerTargetGroup: AnalysisComponent): FluentBuilder = apply { this.loadBalancerTargetGroup = loadBalancerTargetGroup }
        override fun loadBalancerTargetGroups(loadBalancerTargetGroups: List<AnalysisComponent>): FluentBuilder = apply { this.loadBalancerTargetGroups = loadBalancerTargetGroups }
        override fun loadBalancerTargetPort(loadBalancerTargetPort: Int): FluentBuilder = apply { this.loadBalancerTargetPort = loadBalancerTargetPort }
        override fun missingComponent(missingComponent: String): FluentBuilder = apply { this.missingComponent = missingComponent }
        override fun natGateway(natGateway: AnalysisComponent): FluentBuilder = apply { this.natGateway = natGateway }
        override fun networkInterface(networkInterface: AnalysisComponent): FluentBuilder = apply { this.networkInterface = networkInterface }
        override fun packetField(packetField: String): FluentBuilder = apply { this.packetField = packetField }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun portRanges(portRanges: List<PortRange>): FluentBuilder = apply { this.portRanges = portRanges }
        override fun prefixList(prefixList: AnalysisComponent): FluentBuilder = apply { this.prefixList = prefixList }
        override fun protocols(protocols: List<String>): FluentBuilder = apply { this.protocols = protocols }
        override fun routeTable(routeTable: AnalysisComponent): FluentBuilder = apply { this.routeTable = routeTable }
        override fun routeTableRoute(routeTableRoute: AnalysisRouteTableRoute): FluentBuilder = apply { this.routeTableRoute = routeTableRoute }
        override fun securityGroup(securityGroup: AnalysisComponent): FluentBuilder = apply { this.securityGroup = securityGroup }
        override fun securityGroupRule(securityGroupRule: AnalysisSecurityGroupRule): FluentBuilder = apply { this.securityGroupRule = securityGroupRule }
        override fun securityGroups(securityGroups: List<AnalysisComponent>): FluentBuilder = apply { this.securityGroups = securityGroups }
        override fun sourceVpc(sourceVpc: AnalysisComponent): FluentBuilder = apply { this.sourceVpc = sourceVpc }
        override fun state(state: String): FluentBuilder = apply { this.state = state }
        override fun subnet(subnet: AnalysisComponent): FluentBuilder = apply { this.subnet = subnet }
        override fun subnetRouteTable(subnetRouteTable: AnalysisComponent): FluentBuilder = apply { this.subnetRouteTable = subnetRouteTable }
        override fun vpc(vpc: AnalysisComponent): FluentBuilder = apply { this.vpc = vpc }
        override fun vpcEndpoint(vpcEndpoint: AnalysisComponent): FluentBuilder = apply { this.vpcEndpoint = vpcEndpoint }
        override fun vpcPeeringConnection(vpcPeeringConnection: AnalysisComponent): FluentBuilder = apply { this.vpcPeeringConnection = vpcPeeringConnection }
        override fun vpnConnection(vpnConnection: AnalysisComponent): FluentBuilder = apply { this.vpnConnection = vpnConnection }
        override fun vpnGateway(vpnGateway: AnalysisComponent): FluentBuilder = apply { this.vpnGateway = vpnGateway }
    }
}
