// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ExportImageRequest private constructor(builder: BuilderImpl) {
    /**
     * Token to enable idempotency for export image requests.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A description of the image being exported. The maximum length is 255 characters.
     */
    val description: String? = builder.description
    /**
     * The disk image format.
     */
    val diskImageFormat: DiskImageFormat? = builder.diskImageFormat
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the image.
     */
    val imageId: String? = builder.imageId
    /**
     * The name of the role that grants VM Import/Export permission to export images to your Amazon
     * S3 bucket. If this parameter is not specified, the default role is named 'vmimport'.
     */
    val roleName: String? = builder.roleName
    /**
     * Information about the destination Amazon S3 bucket. The bucket must exist and grant WRITE
     * and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
     */
    val s3ExportLocation: ExportTaskS3LocationRequest? = builder.s3ExportLocation
    /**
     * The tags to apply to the export image task during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExportImageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExportImageRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("diskImageFormat=$diskImageFormat,")
        append("dryRun=$dryRun,")
        append("imageId=$imageId,")
        append("roleName=$roleName,")
        append("s3ExportLocation=$s3ExportLocation,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (diskImageFormat?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (s3ExportLocation?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportImageRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (diskImageFormat != other.diskImageFormat) return false
        if (dryRun != other.dryRun) return false
        if (imageId != other.imageId) return false
        if (roleName != other.roleName) return false
        if (s3ExportLocation != other.s3ExportLocation) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExportImageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExportImageRequest
        /**
         * Token to enable idempotency for export image requests.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A description of the image being exported. The maximum length is 255 characters.
         */
        fun description(description: String): FluentBuilder
        /**
         * The disk image format.
         */
        fun diskImageFormat(diskImageFormat: DiskImageFormat): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the image.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The name of the role that grants VM Import/Export permission to export images to your Amazon
         * S3 bucket. If this parameter is not specified, the default role is named 'vmimport'.
         */
        fun roleName(roleName: String): FluentBuilder
        /**
         * Information about the destination Amazon S3 bucket. The bucket must exist and grant WRITE
         * and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
         */
        fun s3ExportLocation(s3ExportLocation: ExportTaskS3LocationRequest): FluentBuilder
        /**
         * The tags to apply to the export image task during creation.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Token to enable idempotency for export image requests.
         */
        var clientToken: String?
        /**
         * A description of the image being exported. The maximum length is 255 characters.
         */
        var description: String?
        /**
         * The disk image format.
         */
        var diskImageFormat: DiskImageFormat?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the image.
         */
        var imageId: String?
        /**
         * The name of the role that grants VM Import/Export permission to export images to your Amazon
         * S3 bucket. If this parameter is not specified, the default role is named 'vmimport'.
         */
        var roleName: String?
        /**
         * Information about the destination Amazon S3 bucket. The bucket must exist and grant WRITE
         * and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
         */
        var s3ExportLocation: ExportTaskS3LocationRequest?
        /**
         * The tags to apply to the export image task during creation.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): ExportImageRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ExportTaskS3LocationRequest] inside the given [block]
         */
        fun s3ExportLocation(block: ExportTaskS3LocationRequest.DslBuilder.() -> kotlin.Unit) {
            this.s3ExportLocation = ExportTaskS3LocationRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var diskImageFormat: DiskImageFormat? = null
        override var dryRun: Boolean? = null
        override var imageId: String? = null
        override var roleName: String? = null
        override var s3ExportLocation: ExportTaskS3LocationRequest? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: ExportImageRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.diskImageFormat = x.diskImageFormat
            this.dryRun = x.dryRun
            this.imageId = x.imageId
            this.roleName = x.roleName
            this.s3ExportLocation = x.s3ExportLocation
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): ExportImageRequest = ExportImageRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun diskImageFormat(diskImageFormat: DiskImageFormat): FluentBuilder = apply { this.diskImageFormat = diskImageFormat }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun roleName(roleName: String): FluentBuilder = apply { this.roleName = roleName }
        override fun s3ExportLocation(s3ExportLocation: ExportTaskS3LocationRequest): FluentBuilder = apply { this.s3ExportLocation = s3ExportLocation }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
