// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ExportImageResponse private constructor(builder: BuilderImpl) {
    /**
     * A description of the image being exported.
     */
    val description: String? = builder.description
    /**
     * The disk image format for the exported image.
     */
    val diskImageFormat: DiskImageFormat? = builder.diskImageFormat
    /**
     * The ID of the export image task.
     */
    val exportImageTaskId: String? = builder.exportImageTaskId
    /**
     * The ID of the image.
     */
    val imageId: String? = builder.imageId
    /**
     * The percent complete of the export image task.
     */
    val progress: String? = builder.progress
    /**
     * The name of the role that grants VM Import/Export permission to export images to your Amazon
     * S3 bucket.
     */
    val roleName: String? = builder.roleName
    /**
     * Information about the destination Amazon S3 bucket.
     */
    val s3ExportLocation: ExportTaskS3Location? = builder.s3ExportLocation
    /**
     * The status of the export image task. The possible values are active, completed,
     * deleting, and deleted.
     */
    val status: String? = builder.status
    /**
     * The status message for the export image task.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * Any tags assigned to the export image task.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExportImageResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExportImageResponse(")
        append("description=$description,")
        append("diskImageFormat=$diskImageFormat,")
        append("exportImageTaskId=$exportImageTaskId,")
        append("imageId=$imageId,")
        append("progress=$progress,")
        append("roleName=$roleName,")
        append("s3ExportLocation=$s3ExportLocation,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (diskImageFormat?.hashCode() ?: 0)
        result = 31 * result + (exportImageTaskId?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (s3ExportLocation?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportImageResponse

        if (description != other.description) return false
        if (diskImageFormat != other.diskImageFormat) return false
        if (exportImageTaskId != other.exportImageTaskId) return false
        if (imageId != other.imageId) return false
        if (progress != other.progress) return false
        if (roleName != other.roleName) return false
        if (s3ExportLocation != other.s3ExportLocation) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExportImageResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExportImageResponse
        /**
         * A description of the image being exported.
         */
        fun description(description: String): FluentBuilder
        /**
         * The disk image format for the exported image.
         */
        fun diskImageFormat(diskImageFormat: DiskImageFormat): FluentBuilder
        /**
         * The ID of the export image task.
         */
        fun exportImageTaskId(exportImageTaskId: String): FluentBuilder
        /**
         * The ID of the image.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The percent complete of the export image task.
         */
        fun progress(progress: String): FluentBuilder
        /**
         * The name of the role that grants VM Import/Export permission to export images to your Amazon
         * S3 bucket.
         */
        fun roleName(roleName: String): FluentBuilder
        /**
         * Information about the destination Amazon S3 bucket.
         */
        fun s3ExportLocation(s3ExportLocation: ExportTaskS3Location): FluentBuilder
        /**
         * The status of the export image task. The possible values are active, completed,
         * deleting, and deleted.
         */
        fun status(status: String): FluentBuilder
        /**
         * The status message for the export image task.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * Any tags assigned to the export image task.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description of the image being exported.
         */
        var description: String?
        /**
         * The disk image format for the exported image.
         */
        var diskImageFormat: DiskImageFormat?
        /**
         * The ID of the export image task.
         */
        var exportImageTaskId: String?
        /**
         * The ID of the image.
         */
        var imageId: String?
        /**
         * The percent complete of the export image task.
         */
        var progress: String?
        /**
         * The name of the role that grants VM Import/Export permission to export images to your Amazon
         * S3 bucket.
         */
        var roleName: String?
        /**
         * Information about the destination Amazon S3 bucket.
         */
        var s3ExportLocation: ExportTaskS3Location?
        /**
         * The status of the export image task. The possible values are active, completed,
         * deleting, and deleted.
         */
        var status: String?
        /**
         * The status message for the export image task.
         */
        var statusMessage: String?
        /**
         * Any tags assigned to the export image task.
         */
        var tags: List<Tag>?

        fun build(): ExportImageResponse
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ExportTaskS3Location] inside the given [block]
         */
        fun s3ExportLocation(block: ExportTaskS3Location.DslBuilder.() -> kotlin.Unit) {
            this.s3ExportLocation = ExportTaskS3Location.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var diskImageFormat: DiskImageFormat? = null
        override var exportImageTaskId: String? = null
        override var imageId: String? = null
        override var progress: String? = null
        override var roleName: String? = null
        override var s3ExportLocation: ExportTaskS3Location? = null
        override var status: String? = null
        override var statusMessage: String? = null
        override var tags: List<Tag>? = null

        constructor(x: ExportImageResponse) : this() {
            this.description = x.description
            this.diskImageFormat = x.diskImageFormat
            this.exportImageTaskId = x.exportImageTaskId
            this.imageId = x.imageId
            this.progress = x.progress
            this.roleName = x.roleName
            this.s3ExportLocation = x.s3ExportLocation
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.tags = x.tags
        }

        override fun build(): ExportImageResponse = ExportImageResponse(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun diskImageFormat(diskImageFormat: DiskImageFormat): FluentBuilder = apply { this.diskImageFormat = diskImageFormat }
        override fun exportImageTaskId(exportImageTaskId: String): FluentBuilder = apply { this.exportImageTaskId = exportImageTaskId }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun progress(progress: String): FluentBuilder = apply { this.progress = progress }
        override fun roleName(roleName: String): FluentBuilder = apply { this.roleName = roleName }
        override fun s3ExportLocation(s3ExportLocation: ExportTaskS3Location): FluentBuilder = apply { this.s3ExportLocation = s3ExportLocation }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
