// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the format and location for the export task.
 */
class ExportToS3Task private constructor(builder: BuilderImpl) {
    /**
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     */
    val containerFormat: ContainerFormat? = builder.containerFormat
    /**
     * The format for the exported image.
     */
    val diskImageFormat: DiskImageFormat? = builder.diskImageFormat
    /**
     * The Amazon S3 bucket for the destination image. The destination bucket must exist and grant
     * WRITE and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
     */
    val s3Bucket: String? = builder.s3Bucket
    /**
     * The encryption key for your S3 bucket.
     */
    val s3Key: String? = builder.s3Key

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExportToS3Task = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExportToS3Task(")
        append("containerFormat=$containerFormat,")
        append("diskImageFormat=$diskImageFormat,")
        append("s3Bucket=$s3Bucket,")
        append("s3Key=$s3Key)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerFormat?.hashCode() ?: 0
        result = 31 * result + (diskImageFormat?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3Key?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportToS3Task

        if (containerFormat != other.containerFormat) return false
        if (diskImageFormat != other.diskImageFormat) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Key != other.s3Key) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExportToS3Task = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExportToS3Task
        /**
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
         * exported.
         */
        fun containerFormat(containerFormat: ContainerFormat): FluentBuilder
        /**
         * The format for the exported image.
         */
        fun diskImageFormat(diskImageFormat: DiskImageFormat): FluentBuilder
        /**
         * The Amazon S3 bucket for the destination image. The destination bucket must exist and grant
         * WRITE and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
         */
        fun s3Bucket(s3Bucket: String): FluentBuilder
        /**
         * The encryption key for your S3 bucket.
         */
        fun s3Key(s3Key: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
         * exported.
         */
        var containerFormat: ContainerFormat?
        /**
         * The format for the exported image.
         */
        var diskImageFormat: DiskImageFormat?
        /**
         * The Amazon S3 bucket for the destination image. The destination bucket must exist and grant
         * WRITE and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
         */
        var s3Bucket: String?
        /**
         * The encryption key for your S3 bucket.
         */
        var s3Key: String?

        fun build(): ExportToS3Task
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var containerFormat: ContainerFormat? = null
        override var diskImageFormat: DiskImageFormat? = null
        override var s3Bucket: String? = null
        override var s3Key: String? = null

        constructor(x: ExportToS3Task) : this() {
            this.containerFormat = x.containerFormat
            this.diskImageFormat = x.diskImageFormat
            this.s3Bucket = x.s3Bucket
            this.s3Key = x.s3Key
        }

        override fun build(): ExportToS3Task = ExportToS3Task(this)
        override fun containerFormat(containerFormat: ContainerFormat): FluentBuilder = apply { this.containerFormat = containerFormat }
        override fun diskImageFormat(diskImageFormat: DiskImageFormat): FluentBuilder = apply { this.diskImageFormat = diskImageFormat }
        override fun s3Bucket(s3Bucket: String): FluentBuilder = apply { this.s3Bucket = s3Bucket }
        override fun s3Key(s3Key: String): FluentBuilder = apply { this.s3Key = s3Key }
    }
}
