// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an export instance task.
 */
class ExportToS3TaskSpecification private constructor(builder: BuilderImpl) {
    /**
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     */
    val containerFormat: ContainerFormat? = builder.containerFormat
    /**
     * The format for the exported image.
     */
    val diskImageFormat: DiskImageFormat? = builder.diskImageFormat
    /**
     * The Amazon S3 bucket for the destination image. The destination bucket must exist and grant
     * WRITE and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
     */
    val s3Bucket: String? = builder.s3Bucket
    /**
     * The image is written to a single object in the Amazon S3 bucket at the S3 key s3prefix +
     * exportTaskId + '.' + diskImageFormat.
     */
    val s3Prefix: String? = builder.s3Prefix

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExportToS3TaskSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExportToS3TaskSpecification(")
        append("containerFormat=$containerFormat,")
        append("diskImageFormat=$diskImageFormat,")
        append("s3Bucket=$s3Bucket,")
        append("s3Prefix=$s3Prefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerFormat?.hashCode() ?: 0
        result = 31 * result + (diskImageFormat?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportToS3TaskSpecification

        if (containerFormat != other.containerFormat) return false
        if (diskImageFormat != other.diskImageFormat) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Prefix != other.s3Prefix) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExportToS3TaskSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExportToS3TaskSpecification
        /**
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
         * exported.
         */
        fun containerFormat(containerFormat: ContainerFormat): FluentBuilder
        /**
         * The format for the exported image.
         */
        fun diskImageFormat(diskImageFormat: DiskImageFormat): FluentBuilder
        /**
         * The Amazon S3 bucket for the destination image. The destination bucket must exist and grant
         * WRITE and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
         */
        fun s3Bucket(s3Bucket: String): FluentBuilder
        /**
         * The image is written to a single object in the Amazon S3 bucket at the S3 key s3prefix +
         * exportTaskId + '.' + diskImageFormat.
         */
        fun s3Prefix(s3Prefix: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
         * exported.
         */
        var containerFormat: ContainerFormat?
        /**
         * The format for the exported image.
         */
        var diskImageFormat: DiskImageFormat?
        /**
         * The Amazon S3 bucket for the destination image. The destination bucket must exist and grant
         * WRITE and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.
         */
        var s3Bucket: String?
        /**
         * The image is written to a single object in the Amazon S3 bucket at the S3 key s3prefix +
         * exportTaskId + '.' + diskImageFormat.
         */
        var s3Prefix: String?

        fun build(): ExportToS3TaskSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var containerFormat: ContainerFormat? = null
        override var diskImageFormat: DiskImageFormat? = null
        override var s3Bucket: String? = null
        override var s3Prefix: String? = null

        constructor(x: ExportToS3TaskSpecification) : this() {
            this.containerFormat = x.containerFormat
            this.diskImageFormat = x.diskImageFormat
            this.s3Bucket = x.s3Bucket
            this.s3Prefix = x.s3Prefix
        }

        override fun build(): ExportToS3TaskSpecification = ExportToS3TaskSpecification(this)
        override fun containerFormat(containerFormat: ContainerFormat): FluentBuilder = apply { this.containerFormat = containerFormat }
        override fun diskImageFormat(diskImageFormat: DiskImageFormat): FluentBuilder = apply { this.diskImageFormat = diskImageFormat }
        override fun s3Bucket(s3Bucket: String): FluentBuilder = apply { this.s3Bucket = s3Bucket }
        override fun s3Prefix(s3Prefix: String): FluentBuilder = apply { this.s3Prefix = s3Prefix }
    }
}
