// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an EC2 Fleet.
 */
class FleetData private constructor(builder: BuilderImpl) {
    /**
     * The progress of the EC2 Fleet. If there is an error, the status is error. After
     * all requests are placed, the status is pending_fulfillment. If the size of the
     * EC2 Fleet is equal to or greater than its target capacity, the status is fulfilled.
     * If the size of the EC2 Fleet is decreased, the status is pending_termination while
     * instances are terminating.
     */
    val activityStatus: FleetActivityStatus? = builder.activityStatus
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency.
     * Constraints: Maximum 64 ASCII characters
     */
    val clientToken: String? = builder.clientToken
    /**
     * Reserved.
     */
    val context: String? = builder.context
    /**
     * The creation date and time of the EC2 Fleet.
     */
    val createTime: Instant? = builder.createTime
    /**
     * Information about the instances that could not be launched by the fleet. Valid only when
     * Type is set to instant.
     */
    val errors: List<DescribeFleetError>? = builder.errors
    /**
     * Indicates whether running instances should be terminated if the target capacity of the
     * EC2 Fleet is decreased below the current size of the EC2 Fleet.
     */
    val excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy? = builder.excessCapacityTerminationPolicy
    /**
     * The ID of the EC2 Fleet.
     */
    val fleetId: String? = builder.fleetId
    /**
     * The state of the EC2 Fleet.
     */
    val fleetState: FleetStateCode? = builder.fleetState
    /**
     * The number of units fulfilled by this request compared to the set target
     * capacity.
     */
    val fulfilledCapacity: Double? = builder.fulfilledCapacity
    /**
     * The number of units fulfilled by this request compared to the set target On-Demand
     * capacity.
     */
    val fulfilledOnDemandCapacity: Double? = builder.fulfilledOnDemandCapacity
    /**
     * Information about the instances that were launched by the fleet. Valid only when
     * Type is set to instant.
     */
    val instances: List<DescribeFleetsInstances>? = builder.instances
    /**
     * The launch template and overrides.
     */
    val launchTemplateConfigs: List<FleetLaunchTemplateConfig>? = builder.launchTemplateConfigs
    /**
     * The allocation strategy of On-Demand Instances in an EC2 Fleet.
     */
    val onDemandOptions: OnDemandOptions? = builder.onDemandOptions
    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for
     * fleets of type maintain. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet
     * health checks in the Amazon EC2 User Guide.
     */
    val replaceUnhealthyInstances: Boolean? = builder.replaceUnhealthyInstances
    /**
     * The configuration of Spot Instances in an EC2 Fleet.
     */
    val spotOptions: SpotOptions? = builder.spotOptions
    /**
     * The tags for an EC2 Fleet resource.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The number of units to request. You can choose to set the target capacity in terms of
     * instances or a performance characteristic that is important to your application workload,
     * such as vCPUs, memory, or I/O. If the request type is maintain, you can
     * specify a target capacity of 0 and add capacity later.
     */
    val targetCapacitySpecification: TargetCapacitySpecification? = builder.targetCapacitySpecification
    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    val terminateInstancesWithExpiration: Boolean? = builder.terminateInstancesWithExpiration
    /**
     * The type of request. Indicates whether the EC2 Fleet only requests the target
     * capacity, or also attempts to maintain it. If you request a certain target
     * capacity, EC2 Fleet only places the required requests; it does not attempt to replenish
     * instances if capacity is diminished, and it does not submit requests in alternative
     * capacity pools if capacity is unavailable. To maintain a certain target capacity, EC2 Fleet
     * places the required requests to meet this target capacity. It also automatically
     * replenishes any interrupted Spot Instances. Default: maintain.
     */
    val type: FleetType? = builder.type
    /**
     * The start date and time of the request, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     * The default is to start fulfilling the request immediately.
     */
    val validFrom: Instant? = builder.validFrom
    /**
     * The end date and time of the request, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     * At this point, no new instance requests are placed or able to fulfill the request. The
     * default end date is 7 days from the current date.
     */
    val validUntil: Instant? = builder.validUntil

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FleetData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FleetData(")
        append("activityStatus=$activityStatus,")
        append("clientToken=$clientToken,")
        append("context=$context,")
        append("createTime=$createTime,")
        append("errors=$errors,")
        append("excessCapacityTerminationPolicy=$excessCapacityTerminationPolicy,")
        append("fleetId=$fleetId,")
        append("fleetState=$fleetState,")
        append("fulfilledCapacity=$fulfilledCapacity,")
        append("fulfilledOnDemandCapacity=$fulfilledOnDemandCapacity,")
        append("instances=$instances,")
        append("launchTemplateConfigs=$launchTemplateConfigs,")
        append("onDemandOptions=$onDemandOptions,")
        append("replaceUnhealthyInstances=$replaceUnhealthyInstances,")
        append("spotOptions=$spotOptions,")
        append("tags=$tags,")
        append("targetCapacitySpecification=$targetCapacitySpecification,")
        append("terminateInstancesWithExpiration=$terminateInstancesWithExpiration,")
        append("type=$type,")
        append("validFrom=$validFrom,")
        append("validUntil=$validUntil)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityStatus?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (excessCapacityTerminationPolicy?.hashCode() ?: 0)
        result = 31 * result + (fleetId?.hashCode() ?: 0)
        result = 31 * result + (fleetState?.hashCode() ?: 0)
        result = 31 * result + (fulfilledCapacity?.hashCode() ?: 0)
        result = 31 * result + (fulfilledOnDemandCapacity?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateConfigs?.hashCode() ?: 0)
        result = 31 * result + (onDemandOptions?.hashCode() ?: 0)
        result = 31 * result + (replaceUnhealthyInstances?.hashCode() ?: 0)
        result = 31 * result + (spotOptions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetCapacitySpecification?.hashCode() ?: 0)
        result = 31 * result + (terminateInstancesWithExpiration?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validUntil?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FleetData

        if (activityStatus != other.activityStatus) return false
        if (clientToken != other.clientToken) return false
        if (context != other.context) return false
        if (createTime != other.createTime) return false
        if (errors != other.errors) return false
        if (excessCapacityTerminationPolicy != other.excessCapacityTerminationPolicy) return false
        if (fleetId != other.fleetId) return false
        if (fleetState != other.fleetState) return false
        if (fulfilledCapacity != other.fulfilledCapacity) return false
        if (fulfilledOnDemandCapacity != other.fulfilledOnDemandCapacity) return false
        if (instances != other.instances) return false
        if (launchTemplateConfigs != other.launchTemplateConfigs) return false
        if (onDemandOptions != other.onDemandOptions) return false
        if (replaceUnhealthyInstances != other.replaceUnhealthyInstances) return false
        if (spotOptions != other.spotOptions) return false
        if (tags != other.tags) return false
        if (targetCapacitySpecification != other.targetCapacitySpecification) return false
        if (terminateInstancesWithExpiration != other.terminateInstancesWithExpiration) return false
        if (type != other.type) return false
        if (validFrom != other.validFrom) return false
        if (validUntil != other.validUntil) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FleetData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FleetData
        /**
         * The progress of the EC2 Fleet. If there is an error, the status is error. After
         * all requests are placed, the status is pending_fulfillment. If the size of the
         * EC2 Fleet is equal to or greater than its target capacity, the status is fulfilled.
         * If the size of the EC2 Fleet is decreased, the status is pending_termination while
         * instances are terminating.
         */
        fun activityStatus(activityStatus: FleetActivityStatus): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         * Constraints: Maximum 64 ASCII characters
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Reserved.
         */
        fun context(context: String): FluentBuilder
        /**
         * The creation date and time of the EC2 Fleet.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * Information about the instances that could not be launched by the fleet. Valid only when
         * Type is set to instant.
         */
        fun errors(errors: List<DescribeFleetError>): FluentBuilder
        /**
         * Indicates whether running instances should be terminated if the target capacity of the
         * EC2 Fleet is decreased below the current size of the EC2 Fleet.
         */
        fun excessCapacityTerminationPolicy(excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy): FluentBuilder
        /**
         * The ID of the EC2 Fleet.
         */
        fun fleetId(fleetId: String): FluentBuilder
        /**
         * The state of the EC2 Fleet.
         */
        fun fleetState(fleetState: FleetStateCode): FluentBuilder
        /**
         * The number of units fulfilled by this request compared to the set target
         * capacity.
         */
        fun fulfilledCapacity(fulfilledCapacity: Double): FluentBuilder
        /**
         * The number of units fulfilled by this request compared to the set target On-Demand
         * capacity.
         */
        fun fulfilledOnDemandCapacity(fulfilledOnDemandCapacity: Double): FluentBuilder
        /**
         * Information about the instances that were launched by the fleet. Valid only when
         * Type is set to instant.
         */
        fun instances(instances: List<DescribeFleetsInstances>): FluentBuilder
        /**
         * The launch template and overrides.
         */
        fun launchTemplateConfigs(launchTemplateConfigs: List<FleetLaunchTemplateConfig>): FluentBuilder
        /**
         * The allocation strategy of On-Demand Instances in an EC2 Fleet.
         */
        fun onDemandOptions(onDemandOptions: OnDemandOptions): FluentBuilder
        /**
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for
         * fleets of type maintain. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet
         * health checks in the Amazon EC2 User Guide.
         */
        fun replaceUnhealthyInstances(replaceUnhealthyInstances: Boolean): FluentBuilder
        /**
         * The configuration of Spot Instances in an EC2 Fleet.
         */
        fun spotOptions(spotOptions: SpotOptions): FluentBuilder
        /**
         * The tags for an EC2 Fleet resource.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The number of units to request. You can choose to set the target capacity in terms of
         * instances or a performance characteristic that is important to your application workload,
         * such as vCPUs, memory, or I/O. If the request type is maintain, you can
         * specify a target capacity of 0 and add capacity later.
         */
        fun targetCapacitySpecification(targetCapacitySpecification: TargetCapacitySpecification): FluentBuilder
        /**
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         */
        fun terminateInstancesWithExpiration(terminateInstancesWithExpiration: Boolean): FluentBuilder
        /**
         * The type of request. Indicates whether the EC2 Fleet only requests the target
         * capacity, or also attempts to maintain it. If you request a certain target
         * capacity, EC2 Fleet only places the required requests; it does not attempt to replenish
         * instances if capacity is diminished, and it does not submit requests in alternative
         * capacity pools if capacity is unavailable. To maintain a certain target capacity, EC2 Fleet
         * places the required requests to meet this target capacity. It also automatically
         * replenishes any interrupted Spot Instances. Default: maintain.
         */
        fun type(type: FleetType): FluentBuilder
        /**
         * The start date and time of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * The default is to start fulfilling the request immediately.
         */
        fun validFrom(validFrom: Instant): FluentBuilder
        /**
         * The end date and time of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * At this point, no new instance requests are placed or able to fulfill the request. The
         * default end date is 7 days from the current date.
         */
        fun validUntil(validUntil: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The progress of the EC2 Fleet. If there is an error, the status is error. After
         * all requests are placed, the status is pending_fulfillment. If the size of the
         * EC2 Fleet is equal to or greater than its target capacity, the status is fulfilled.
         * If the size of the EC2 Fleet is decreased, the status is pending_termination while
         * instances are terminating.
         */
        var activityStatus: FleetActivityStatus?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         * Constraints: Maximum 64 ASCII characters
         */
        var clientToken: String?
        /**
         * Reserved.
         */
        var context: String?
        /**
         * The creation date and time of the EC2 Fleet.
         */
        var createTime: Instant?
        /**
         * Information about the instances that could not be launched by the fleet. Valid only when
         * Type is set to instant.
         */
        var errors: List<DescribeFleetError>?
        /**
         * Indicates whether running instances should be terminated if the target capacity of the
         * EC2 Fleet is decreased below the current size of the EC2 Fleet.
         */
        var excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy?
        /**
         * The ID of the EC2 Fleet.
         */
        var fleetId: String?
        /**
         * The state of the EC2 Fleet.
         */
        var fleetState: FleetStateCode?
        /**
         * The number of units fulfilled by this request compared to the set target
         * capacity.
         */
        var fulfilledCapacity: Double?
        /**
         * The number of units fulfilled by this request compared to the set target On-Demand
         * capacity.
         */
        var fulfilledOnDemandCapacity: Double?
        /**
         * Information about the instances that were launched by the fleet. Valid only when
         * Type is set to instant.
         */
        var instances: List<DescribeFleetsInstances>?
        /**
         * The launch template and overrides.
         */
        var launchTemplateConfigs: List<FleetLaunchTemplateConfig>?
        /**
         * The allocation strategy of On-Demand Instances in an EC2 Fleet.
         */
        var onDemandOptions: OnDemandOptions?
        /**
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for
         * fleets of type maintain. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet
         * health checks in the Amazon EC2 User Guide.
         */
        var replaceUnhealthyInstances: Boolean?
        /**
         * The configuration of Spot Instances in an EC2 Fleet.
         */
        var spotOptions: SpotOptions?
        /**
         * The tags for an EC2 Fleet resource.
         */
        var tags: List<Tag>?
        /**
         * The number of units to request. You can choose to set the target capacity in terms of
         * instances or a performance characteristic that is important to your application workload,
         * such as vCPUs, memory, or I/O. If the request type is maintain, you can
         * specify a target capacity of 0 and add capacity later.
         */
        var targetCapacitySpecification: TargetCapacitySpecification?
        /**
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         */
        var terminateInstancesWithExpiration: Boolean?
        /**
         * The type of request. Indicates whether the EC2 Fleet only requests the target
         * capacity, or also attempts to maintain it. If you request a certain target
         * capacity, EC2 Fleet only places the required requests; it does not attempt to replenish
         * instances if capacity is diminished, and it does not submit requests in alternative
         * capacity pools if capacity is unavailable. To maintain a certain target capacity, EC2 Fleet
         * places the required requests to meet this target capacity. It also automatically
         * replenishes any interrupted Spot Instances. Default: maintain.
         */
        var type: FleetType?
        /**
         * The start date and time of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * The default is to start fulfilling the request immediately.
         */
        var validFrom: Instant?
        /**
         * The end date and time of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * At this point, no new instance requests are placed or able to fulfill the request. The
         * default end date is 7 days from the current date.
         */
        var validUntil: Instant?

        fun build(): FleetData
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.OnDemandOptions] inside the given [block]
         */
        fun onDemandOptions(block: OnDemandOptions.DslBuilder.() -> kotlin.Unit) {
            this.onDemandOptions = OnDemandOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotOptions] inside the given [block]
         */
        fun spotOptions(block: SpotOptions.DslBuilder.() -> kotlin.Unit) {
            this.spotOptions = SpotOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TargetCapacitySpecification] inside the given [block]
         */
        fun targetCapacitySpecification(block: TargetCapacitySpecification.DslBuilder.() -> kotlin.Unit) {
            this.targetCapacitySpecification = TargetCapacitySpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activityStatus: FleetActivityStatus? = null
        override var clientToken: String? = null
        override var context: String? = null
        override var createTime: Instant? = null
        override var errors: List<DescribeFleetError>? = null
        override var excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy? = null
        override var fleetId: String? = null
        override var fleetState: FleetStateCode? = null
        override var fulfilledCapacity: Double? = null
        override var fulfilledOnDemandCapacity: Double? = null
        override var instances: List<DescribeFleetsInstances>? = null
        override var launchTemplateConfigs: List<FleetLaunchTemplateConfig>? = null
        override var onDemandOptions: OnDemandOptions? = null
        override var replaceUnhealthyInstances: Boolean? = null
        override var spotOptions: SpotOptions? = null
        override var tags: List<Tag>? = null
        override var targetCapacitySpecification: TargetCapacitySpecification? = null
        override var terminateInstancesWithExpiration: Boolean? = null
        override var type: FleetType? = null
        override var validFrom: Instant? = null
        override var validUntil: Instant? = null

        constructor(x: FleetData) : this() {
            this.activityStatus = x.activityStatus
            this.clientToken = x.clientToken
            this.context = x.context
            this.createTime = x.createTime
            this.errors = x.errors
            this.excessCapacityTerminationPolicy = x.excessCapacityTerminationPolicy
            this.fleetId = x.fleetId
            this.fleetState = x.fleetState
            this.fulfilledCapacity = x.fulfilledCapacity
            this.fulfilledOnDemandCapacity = x.fulfilledOnDemandCapacity
            this.instances = x.instances
            this.launchTemplateConfigs = x.launchTemplateConfigs
            this.onDemandOptions = x.onDemandOptions
            this.replaceUnhealthyInstances = x.replaceUnhealthyInstances
            this.spotOptions = x.spotOptions
            this.tags = x.tags
            this.targetCapacitySpecification = x.targetCapacitySpecification
            this.terminateInstancesWithExpiration = x.terminateInstancesWithExpiration
            this.type = x.type
            this.validFrom = x.validFrom
            this.validUntil = x.validUntil
        }

        override fun build(): FleetData = FleetData(this)
        override fun activityStatus(activityStatus: FleetActivityStatus): FluentBuilder = apply { this.activityStatus = activityStatus }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun context(context: String): FluentBuilder = apply { this.context = context }
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun errors(errors: List<DescribeFleetError>): FluentBuilder = apply { this.errors = errors }
        override fun excessCapacityTerminationPolicy(excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy): FluentBuilder = apply { this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy }
        override fun fleetId(fleetId: String): FluentBuilder = apply { this.fleetId = fleetId }
        override fun fleetState(fleetState: FleetStateCode): FluentBuilder = apply { this.fleetState = fleetState }
        override fun fulfilledCapacity(fulfilledCapacity: Double): FluentBuilder = apply { this.fulfilledCapacity = fulfilledCapacity }
        override fun fulfilledOnDemandCapacity(fulfilledOnDemandCapacity: Double): FluentBuilder = apply { this.fulfilledOnDemandCapacity = fulfilledOnDemandCapacity }
        override fun instances(instances: List<DescribeFleetsInstances>): FluentBuilder = apply { this.instances = instances }
        override fun launchTemplateConfigs(launchTemplateConfigs: List<FleetLaunchTemplateConfig>): FluentBuilder = apply { this.launchTemplateConfigs = launchTemplateConfigs }
        override fun onDemandOptions(onDemandOptions: OnDemandOptions): FluentBuilder = apply { this.onDemandOptions = onDemandOptions }
        override fun replaceUnhealthyInstances(replaceUnhealthyInstances: Boolean): FluentBuilder = apply { this.replaceUnhealthyInstances = replaceUnhealthyInstances }
        override fun spotOptions(spotOptions: SpotOptions): FluentBuilder = apply { this.spotOptions = spotOptions }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun targetCapacitySpecification(targetCapacitySpecification: TargetCapacitySpecification): FluentBuilder = apply { this.targetCapacitySpecification = targetCapacitySpecification }
        override fun terminateInstancesWithExpiration(terminateInstancesWithExpiration: Boolean): FluentBuilder = apply { this.terminateInstancesWithExpiration = terminateInstancesWithExpiration }
        override fun type(type: FleetType): FluentBuilder = apply { this.type = type }
        override fun validFrom(validFrom: Instant): FluentBuilder = apply { this.validFrom = validFrom }
        override fun validUntil(validUntil: Instant): FluentBuilder = apply { this.validUntil = validUntil }
    }
}
