// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes overrides for a launch template.
 */
class FleetLaunchTemplateOverridesRequest private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone in which to launch the instances.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The instance type.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * The maximum price per unit hour that you are willing to pay for a Spot Instance.
     */
    val maxPrice: String? = builder.maxPrice
    /**
     * The location where the instance launched, if applicable.
     */
    val placement: Placement? = builder.placement
    /**
     * The priority for the launch template override. The highest priority is launched
     * first.
     * If the On-Demand AllocationStrategy is set to prioritized,
     * EC2 Fleet uses priority to determine which launch template override to use first in fulfilling
     * On-Demand capacity.
     * If the Spot AllocationStrategy is set to
     * capacity-optimized-prioritized, EC2 Fleet uses priority on a best-effort basis
     * to determine which launch template override to use in fulfilling Spot capacity, but
     * optimizes for capacity first.
     * Valid values are whole numbers starting at 0. The lower the number, the
     * higher the priority. If no number is set, the launch template override has the lowest
     * priority. You can set the same priority for different launch template overrides.
     */
    val priority: Double? = builder.priority
    /**
     * The IDs of the subnets in which to launch the instances. Separate multiple subnet IDs using commas (for example, subnet-1234abcdeexample1, subnet-0987cdef6example2). A request of type instant can have only one subnet ID.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The number of units provided by the specified instance type.
     */
    val weightedCapacity: Double? = builder.weightedCapacity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FleetLaunchTemplateOverridesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FleetLaunchTemplateOverridesRequest(")
        append("availabilityZone=$availabilityZone,")
        append("instanceType=$instanceType,")
        append("maxPrice=$maxPrice,")
        append("placement=$placement,")
        append("priority=$priority,")
        append("subnetId=$subnetId,")
        append("weightedCapacity=$weightedCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (maxPrice?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (priority?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (weightedCapacity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FleetLaunchTemplateOverridesRequest

        if (availabilityZone != other.availabilityZone) return false
        if (instanceType != other.instanceType) return false
        if (maxPrice != other.maxPrice) return false
        if (placement != other.placement) return false
        if (priority != other.priority) return false
        if (subnetId != other.subnetId) return false
        if (weightedCapacity != other.weightedCapacity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FleetLaunchTemplateOverridesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FleetLaunchTemplateOverridesRequest
        /**
         * The Availability Zone in which to launch the instances.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         */
        fun maxPrice(maxPrice: String): FluentBuilder
        /**
         * The location where the instance launched, if applicable.
         */
        fun placement(placement: Placement): FluentBuilder
        /**
         * The priority for the launch template override. The highest priority is launched
         * first.
         * If the On-Demand AllocationStrategy is set to prioritized,
         * EC2 Fleet uses priority to determine which launch template override to use first in fulfilling
         * On-Demand capacity.
         * If the Spot AllocationStrategy is set to
         * capacity-optimized-prioritized, EC2 Fleet uses priority on a best-effort basis
         * to determine which launch template override to use in fulfilling Spot capacity, but
         * optimizes for capacity first.
         * Valid values are whole numbers starting at 0. The lower the number, the
         * higher the priority. If no number is set, the launch template override has the lowest
         * priority. You can set the same priority for different launch template overrides.
         */
        fun priority(priority: Double): FluentBuilder
        /**
         * The IDs of the subnets in which to launch the instances. Separate multiple subnet IDs using commas (for example, subnet-1234abcdeexample1, subnet-0987cdef6example2). A request of type instant can have only one subnet ID.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The number of units provided by the specified instance type.
         */
        fun weightedCapacity(weightedCapacity: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone in which to launch the instances.
         */
        var availabilityZone: String?
        /**
         * The instance type.
         */
        var instanceType: InstanceType?
        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         */
        var maxPrice: String?
        /**
         * The location where the instance launched, if applicable.
         */
        var placement: Placement?
        /**
         * The priority for the launch template override. The highest priority is launched
         * first.
         * If the On-Demand AllocationStrategy is set to prioritized,
         * EC2 Fleet uses priority to determine which launch template override to use first in fulfilling
         * On-Demand capacity.
         * If the Spot AllocationStrategy is set to
         * capacity-optimized-prioritized, EC2 Fleet uses priority on a best-effort basis
         * to determine which launch template override to use in fulfilling Spot capacity, but
         * optimizes for capacity first.
         * Valid values are whole numbers starting at 0. The lower the number, the
         * higher the priority. If no number is set, the launch template override has the lowest
         * priority. You can set the same priority for different launch template overrides.
         */
        var priority: Double?
        /**
         * The IDs of the subnets in which to launch the instances. Separate multiple subnet IDs using commas (for example, subnet-1234abcdeexample1, subnet-0987cdef6example2). A request of type instant can have only one subnet ID.
         */
        var subnetId: String?
        /**
         * The number of units provided by the specified instance type.
         */
        var weightedCapacity: Double?

        fun build(): FleetLaunchTemplateOverridesRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Placement] inside the given [block]
         */
        fun placement(block: Placement.DslBuilder.() -> kotlin.Unit) {
            this.placement = Placement.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var instanceType: InstanceType? = null
        override var maxPrice: String? = null
        override var placement: Placement? = null
        override var priority: Double? = null
        override var subnetId: String? = null
        override var weightedCapacity: Double? = null

        constructor(x: FleetLaunchTemplateOverridesRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.instanceType = x.instanceType
            this.maxPrice = x.maxPrice
            this.placement = x.placement
            this.priority = x.priority
            this.subnetId = x.subnetId
            this.weightedCapacity = x.weightedCapacity
        }

        override fun build(): FleetLaunchTemplateOverridesRequest = FleetLaunchTemplateOverridesRequest(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun maxPrice(maxPrice: String): FluentBuilder = apply { this.maxPrice = maxPrice }
        override fun placement(placement: Placement): FluentBuilder = apply { this.placement = placement }
        override fun priority(priority: Double): FluentBuilder = apply { this.priority = priority }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun weightedCapacity(weightedCapacity: Double): FluentBuilder = apply { this.weightedCapacity = weightedCapacity }
    }
}
