// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the Amazon EC2 launch template and the launch template version that can be used
 * by a Spot Fleet request to configure Amazon EC2 instances. For information about launch templates,
 * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a launch template in the
 * Amazon EC2 User Guide for Linux Instances.
 */
class FleetLaunchTemplateSpecification private constructor(builder: BuilderImpl) {
    /**
     * The ID of the launch template. If you specify the template ID, you can't specify the
     * template name.
     */
    val launchTemplateId: String? = builder.launchTemplateId
    /**
     * The name of the launch template. If you specify the template name, you can't specify
     * the template ID.
     */
    val launchTemplateName: String? = builder.launchTemplateName
    /**
     * The launch template version number, $Latest, or $Default.
     * You must specify a value, otherwise the request fails.
     * If the value is $Latest, Amazon EC2 uses the latest version of the launch
     * template.
     * If the value is $Default, Amazon EC2 uses the default version of the launch
     * template.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FleetLaunchTemplateSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FleetLaunchTemplateSpecification(")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = launchTemplateId?.hashCode() ?: 0
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FleetLaunchTemplateSpecification

        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FleetLaunchTemplateSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FleetLaunchTemplateSpecification
        /**
         * The ID of the launch template. If you specify the template ID, you can't specify the
         * template name.
         */
        fun launchTemplateId(launchTemplateId: String): FluentBuilder
        /**
         * The name of the launch template. If you specify the template name, you can't specify
         * the template ID.
         */
        fun launchTemplateName(launchTemplateName: String): FluentBuilder
        /**
         * The launch template version number, $Latest, or $Default.
         * You must specify a value, otherwise the request fails.
         * If the value is $Latest, Amazon EC2 uses the latest version of the launch
         * template.
         * If the value is $Default, Amazon EC2 uses the default version of the launch
         * template.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the launch template. If you specify the template ID, you can't specify the
         * template name.
         */
        var launchTemplateId: String?
        /**
         * The name of the launch template. If you specify the template name, you can't specify
         * the template ID.
         */
        var launchTemplateName: String?
        /**
         * The launch template version number, $Latest, or $Default.
         * You must specify a value, otherwise the request fails.
         * If the value is $Latest, Amazon EC2 uses the latest version of the launch
         * template.
         * If the value is $Default, Amazon EC2 uses the default version of the launch
         * template.
         */
        var version: String?

        fun build(): FleetLaunchTemplateSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var launchTemplateId: String? = null
        override var launchTemplateName: String? = null
        override var version: String? = null

        constructor(x: FleetLaunchTemplateSpecification) : this() {
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.version = x.version
        }

        override fun build(): FleetLaunchTemplateSpecification = FleetLaunchTemplateSpecification(this)
        override fun launchTemplateId(launchTemplateId: String): FluentBuilder = apply { this.launchTemplateId = launchTemplateId }
        override fun launchTemplateName(launchTemplateName: String): FluentBuilder = apply { this.launchTemplateName = launchTemplateName }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
