// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an
 * elevated risk of being interrupted.
 */
class FleetSpotCapacityRebalance private constructor(builder: BuilderImpl) {
    /**
     * To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance
     * notification is emitted for an existing Spot Instance in the fleet, specify
     * launch. Only available for fleets of type maintain.
     * When a replacement instance is launched, the instance marked for rebalance is not
     * automatically terminated. You can terminate it, or you can leave it running. You are charged for both instances while they are running.
     */
    val replacementStrategy: FleetReplacementStrategy? = builder.replacementStrategy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FleetSpotCapacityRebalance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FleetSpotCapacityRebalance(")
        append("replacementStrategy=$replacementStrategy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = replacementStrategy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FleetSpotCapacityRebalance

        if (replacementStrategy != other.replacementStrategy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FleetSpotCapacityRebalance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FleetSpotCapacityRebalance
        /**
         * To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance
         * notification is emitted for an existing Spot Instance in the fleet, specify
         * launch. Only available for fleets of type maintain.
         * When a replacement instance is launched, the instance marked for rebalance is not
         * automatically terminated. You can terminate it, or you can leave it running. You are charged for both instances while they are running.
         */
        fun replacementStrategy(replacementStrategy: FleetReplacementStrategy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * To allow EC2 Fleet to launch a replacement Spot Instance when an instance rebalance
         * notification is emitted for an existing Spot Instance in the fleet, specify
         * launch. Only available for fleets of type maintain.
         * When a replacement instance is launched, the instance marked for rebalance is not
         * automatically terminated. You can terminate it, or you can leave it running. You are charged for both instances while they are running.
         */
        var replacementStrategy: FleetReplacementStrategy?

        fun build(): FleetSpotCapacityRebalance
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var replacementStrategy: FleetReplacementStrategy? = null

        constructor(x: FleetSpotCapacityRebalance) : this() {
            this.replacementStrategy = x.replacementStrategy
        }

        override fun build(): FleetSpotCapacityRebalance = FleetSpotCapacityRebalance(this)
        override fun replacementStrategy(replacementStrategy: FleetReplacementStrategy): FluentBuilder = apply { this.replacementStrategy = replacementStrategy }
    }
}
