// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a flow log.
 */
class FlowLog private constructor(builder: BuilderImpl) {
    /**
     * The date and time the flow log was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * Information about the error that occurred. Rate limited indicates that
     * CloudWatch Logs throttling has been applied for one or more network interfaces, or that you've
     * reached the limit on the number of log groups that you can create. Access
     * error indicates that the IAM role associated with the flow log does not have
     * sufficient permissions to publish to CloudWatch Logs. Unknown error indicates an
     * internal error.
     */
    val deliverLogsErrorMessage: String? = builder.deliverLogsErrorMessage
    /**
     * The ARN of the IAM role that posts logs to CloudWatch Logs.
     */
    val deliverLogsPermissionArn: String? = builder.deliverLogsPermissionArn
    /**
     * The status of the logs delivery (SUCCESS | FAILED).
     */
    val deliverLogsStatus: String? = builder.deliverLogsStatus
    /**
     * The destination options.
     */
    val destinationOptions: DestinationOptionsResponse? = builder.destinationOptions
    /**
     * The flow log ID.
     */
    val flowLogId: String? = builder.flowLogId
    /**
     * The status of the flow log (ACTIVE).
     */
    val flowLogStatus: String? = builder.flowLogStatus
    /**
     * The destination to which the flow log data is published. Flow log data can be
     * published to an CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs,
     * this element indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which
     * the data is published. If the flow log publishes to Amazon S3, this element indicates the ARN
     * of the Amazon S3 bucket to which the data is published.
     */
    val logDestination: String? = builder.logDestination
    /**
     * The type of destination to which the flow log data is published. Flow log data can be
     * published to CloudWatch Logs or Amazon S3.
     */
    val logDestinationType: LogDestinationType? = builder.logDestinationType
    /**
     * The format of the flow log record.
     */
    val logFormat: String? = builder.logFormat
    /**
     * The name of the flow log group.
     */
    val logGroupName: String? = builder.logGroupName
    /**
     * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
     * instance, the aggregation interval is always 60 seconds (1 minute) or less,
     * regardless of the specified value.
     * Valid Values: 60 | 600
     */
    val maxAggregationInterval: Int? = builder.maxAggregationInterval
    /**
     * The ID of the resource on which the flow log was created.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The tags for the flow log.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of traffic captured for the flow log.
     */
    val trafficType: TrafficType? = builder.trafficType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FlowLog = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FlowLog(")
        append("creationTime=$creationTime,")
        append("deliverLogsErrorMessage=$deliverLogsErrorMessage,")
        append("deliverLogsPermissionArn=$deliverLogsPermissionArn,")
        append("deliverLogsStatus=$deliverLogsStatus,")
        append("destinationOptions=$destinationOptions,")
        append("flowLogId=$flowLogId,")
        append("flowLogStatus=$flowLogStatus,")
        append("logDestination=$logDestination,")
        append("logDestinationType=$logDestinationType,")
        append("logFormat=$logFormat,")
        append("logGroupName=$logGroupName,")
        append("maxAggregationInterval=$maxAggregationInterval,")
        append("resourceId=$resourceId,")
        append("tags=$tags,")
        append("trafficType=$trafficType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deliverLogsErrorMessage?.hashCode() ?: 0)
        result = 31 * result + (deliverLogsPermissionArn?.hashCode() ?: 0)
        result = 31 * result + (deliverLogsStatus?.hashCode() ?: 0)
        result = 31 * result + (destinationOptions?.hashCode() ?: 0)
        result = 31 * result + (flowLogId?.hashCode() ?: 0)
        result = 31 * result + (flowLogStatus?.hashCode() ?: 0)
        result = 31 * result + (logDestination?.hashCode() ?: 0)
        result = 31 * result + (logDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logFormat?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (maxAggregationInterval ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trafficType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FlowLog

        if (creationTime != other.creationTime) return false
        if (deliverLogsErrorMessage != other.deliverLogsErrorMessage) return false
        if (deliverLogsPermissionArn != other.deliverLogsPermissionArn) return false
        if (deliverLogsStatus != other.deliverLogsStatus) return false
        if (destinationOptions != other.destinationOptions) return false
        if (flowLogId != other.flowLogId) return false
        if (flowLogStatus != other.flowLogStatus) return false
        if (logDestination != other.logDestination) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logFormat != other.logFormat) return false
        if (logGroupName != other.logGroupName) return false
        if (maxAggregationInterval != other.maxAggregationInterval) return false
        if (resourceId != other.resourceId) return false
        if (tags != other.tags) return false
        if (trafficType != other.trafficType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FlowLog = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FlowLog
        /**
         * The date and time the flow log was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * Information about the error that occurred. Rate limited indicates that
         * CloudWatch Logs throttling has been applied for one or more network interfaces, or that you've
         * reached the limit on the number of log groups that you can create. Access
         * error indicates that the IAM role associated with the flow log does not have
         * sufficient permissions to publish to CloudWatch Logs. Unknown error indicates an
         * internal error.
         */
        fun deliverLogsErrorMessage(deliverLogsErrorMessage: String): FluentBuilder
        /**
         * The ARN of the IAM role that posts logs to CloudWatch Logs.
         */
        fun deliverLogsPermissionArn(deliverLogsPermissionArn: String): FluentBuilder
        /**
         * The status of the logs delivery (SUCCESS | FAILED).
         */
        fun deliverLogsStatus(deliverLogsStatus: String): FluentBuilder
        /**
         * The destination options.
         */
        fun destinationOptions(destinationOptions: DestinationOptionsResponse): FluentBuilder
        /**
         * The flow log ID.
         */
        fun flowLogId(flowLogId: String): FluentBuilder
        /**
         * The status of the flow log (ACTIVE).
         */
        fun flowLogStatus(flowLogStatus: String): FluentBuilder
        /**
         * The destination to which the flow log data is published. Flow log data can be
         * published to an CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs,
         * this element indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which
         * the data is published. If the flow log publishes to Amazon S3, this element indicates the ARN
         * of the Amazon S3 bucket to which the data is published.
         */
        fun logDestination(logDestination: String): FluentBuilder
        /**
         * The type of destination to which the flow log data is published. Flow log data can be
         * published to CloudWatch Logs or Amazon S3.
         */
        fun logDestinationType(logDestinationType: LogDestinationType): FluentBuilder
        /**
         * The format of the flow log record.
         */
        fun logFormat(logFormat: String): FluentBuilder
        /**
         * The name of the flow log group.
         */
        fun logGroupName(logGroupName: String): FluentBuilder
        /**
         * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.
         * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
         * instance, the aggregation interval is always 60 seconds (1 minute) or less,
         * regardless of the specified value.
         * Valid Values: 60 | 600
         */
        fun maxAggregationInterval(maxAggregationInterval: Int): FluentBuilder
        /**
         * The ID of the resource on which the flow log was created.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The tags for the flow log.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The type of traffic captured for the flow log.
         */
        fun trafficType(trafficType: TrafficType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time the flow log was created.
         */
        var creationTime: Instant?
        /**
         * Information about the error that occurred. Rate limited indicates that
         * CloudWatch Logs throttling has been applied for one or more network interfaces, or that you've
         * reached the limit on the number of log groups that you can create. Access
         * error indicates that the IAM role associated with the flow log does not have
         * sufficient permissions to publish to CloudWatch Logs. Unknown error indicates an
         * internal error.
         */
        var deliverLogsErrorMessage: String?
        /**
         * The ARN of the IAM role that posts logs to CloudWatch Logs.
         */
        var deliverLogsPermissionArn: String?
        /**
         * The status of the logs delivery (SUCCESS | FAILED).
         */
        var deliverLogsStatus: String?
        /**
         * The destination options.
         */
        var destinationOptions: DestinationOptionsResponse?
        /**
         * The flow log ID.
         */
        var flowLogId: String?
        /**
         * The status of the flow log (ACTIVE).
         */
        var flowLogStatus: String?
        /**
         * The destination to which the flow log data is published. Flow log data can be
         * published to an CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs,
         * this element indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which
         * the data is published. If the flow log publishes to Amazon S3, this element indicates the ARN
         * of the Amazon S3 bucket to which the data is published.
         */
        var logDestination: String?
        /**
         * The type of destination to which the flow log data is published. Flow log data can be
         * published to CloudWatch Logs or Amazon S3.
         */
        var logDestinationType: LogDestinationType?
        /**
         * The format of the flow log record.
         */
        var logFormat: String?
        /**
         * The name of the flow log group.
         */
        var logGroupName: String?
        /**
         * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.
         * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
         * instance, the aggregation interval is always 60 seconds (1 minute) or less,
         * regardless of the specified value.
         * Valid Values: 60 | 600
         */
        var maxAggregationInterval: Int?
        /**
         * The ID of the resource on which the flow log was created.
         */
        var resourceId: String?
        /**
         * The tags for the flow log.
         */
        var tags: List<Tag>?
        /**
         * The type of traffic captured for the flow log.
         */
        var trafficType: TrafficType?

        fun build(): FlowLog
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DestinationOptionsResponse] inside the given [block]
         */
        fun destinationOptions(block: DestinationOptionsResponse.DslBuilder.() -> kotlin.Unit) {
            this.destinationOptions = DestinationOptionsResponse.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTime: Instant? = null
        override var deliverLogsErrorMessage: String? = null
        override var deliverLogsPermissionArn: String? = null
        override var deliverLogsStatus: String? = null
        override var destinationOptions: DestinationOptionsResponse? = null
        override var flowLogId: String? = null
        override var flowLogStatus: String? = null
        override var logDestination: String? = null
        override var logDestinationType: LogDestinationType? = null
        override var logFormat: String? = null
        override var logGroupName: String? = null
        override var maxAggregationInterval: Int? = null
        override var resourceId: String? = null
        override var tags: List<Tag>? = null
        override var trafficType: TrafficType? = null

        constructor(x: FlowLog) : this() {
            this.creationTime = x.creationTime
            this.deliverLogsErrorMessage = x.deliverLogsErrorMessage
            this.deliverLogsPermissionArn = x.deliverLogsPermissionArn
            this.deliverLogsStatus = x.deliverLogsStatus
            this.destinationOptions = x.destinationOptions
            this.flowLogId = x.flowLogId
            this.flowLogStatus = x.flowLogStatus
            this.logDestination = x.logDestination
            this.logDestinationType = x.logDestinationType
            this.logFormat = x.logFormat
            this.logGroupName = x.logGroupName
            this.maxAggregationInterval = x.maxAggregationInterval
            this.resourceId = x.resourceId
            this.tags = x.tags
            this.trafficType = x.trafficType
        }

        override fun build(): FlowLog = FlowLog(this)
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun deliverLogsErrorMessage(deliverLogsErrorMessage: String): FluentBuilder = apply { this.deliverLogsErrorMessage = deliverLogsErrorMessage }
        override fun deliverLogsPermissionArn(deliverLogsPermissionArn: String): FluentBuilder = apply { this.deliverLogsPermissionArn = deliverLogsPermissionArn }
        override fun deliverLogsStatus(deliverLogsStatus: String): FluentBuilder = apply { this.deliverLogsStatus = deliverLogsStatus }
        override fun destinationOptions(destinationOptions: DestinationOptionsResponse): FluentBuilder = apply { this.destinationOptions = destinationOptions }
        override fun flowLogId(flowLogId: String): FluentBuilder = apply { this.flowLogId = flowLogId }
        override fun flowLogStatus(flowLogStatus: String): FluentBuilder = apply { this.flowLogStatus = flowLogStatus }
        override fun logDestination(logDestination: String): FluentBuilder = apply { this.logDestination = logDestination }
        override fun logDestinationType(logDestinationType: LogDestinationType): FluentBuilder = apply { this.logDestinationType = logDestinationType }
        override fun logFormat(logFormat: String): FluentBuilder = apply { this.logFormat = logFormat }
        override fun logGroupName(logGroupName: String): FluentBuilder = apply { this.logGroupName = logGroupName }
        override fun maxAggregationInterval(maxAggregationInterval: Int): FluentBuilder = apply { this.maxAggregationInterval = maxAggregationInterval }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun trafficType(trafficType: TrafficType): FluentBuilder = apply { this.trafficType = trafficType }
    }
}
