// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class GetCapacityReservationUsageResponse private constructor(builder: BuilderImpl) {
    /**
     * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
     */
    val availableInstanceCount: Int? = builder.availableInstanceCount
    /**
     * The ID of the Capacity Reservation.
     */
    val capacityReservationId: String? = builder.capacityReservationId
    /**
     * The type of instance for which the Capacity Reservation reserves capacity.
     */
    val instanceType: String? = builder.instanceType
    /**
     * Information about the Capacity Reservation usage.
     */
    val instanceUsages: List<InstanceUsage>? = builder.instanceUsages
    /**
     * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * active - The Capacity Reservation is active and the capacity is available for your use.
     * expired - The Capacity Reservation expired automatically at the date and time specified
     * in your request. The reserved capacity is no longer available for your use.
     * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no
     * longer available for your use.
     * pending - The Capacity Reservation request was successful but the capacity
     * provisioning is still pending.
     * failed - The Capacity Reservation request has failed. A request might fail
     * due to invalid request parameters, capacity constraints, or instance limit constraints.
     * Failed requests are retained for 60 minutes.
     */
    val state: CapacityReservationState? = builder.state
    /**
     * The number of instances for which the Capacity Reservation reserves capacity.
     */
    val totalInstanceCount: Int? = builder.totalInstanceCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetCapacityReservationUsageResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetCapacityReservationUsageResponse(")
        append("availableInstanceCount=$availableInstanceCount,")
        append("capacityReservationId=$capacityReservationId,")
        append("instanceType=$instanceType,")
        append("instanceUsages=$instanceUsages,")
        append("nextToken=$nextToken,")
        append("state=$state,")
        append("totalInstanceCount=$totalInstanceCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availableInstanceCount ?: 0
        result = 31 * result + (capacityReservationId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (instanceUsages?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (totalInstanceCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetCapacityReservationUsageResponse

        if (availableInstanceCount != other.availableInstanceCount) return false
        if (capacityReservationId != other.capacityReservationId) return false
        if (instanceType != other.instanceType) return false
        if (instanceUsages != other.instanceUsages) return false
        if (nextToken != other.nextToken) return false
        if (state != other.state) return false
        if (totalInstanceCount != other.totalInstanceCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetCapacityReservationUsageResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetCapacityReservationUsageResponse
        /**
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         */
        fun availableInstanceCount(availableInstanceCount: Int): FluentBuilder
        /**
         * The ID of the Capacity Reservation.
         */
        fun capacityReservationId(capacityReservationId: String): FluentBuilder
        /**
         * The type of instance for which the Capacity Reservation reserves capacity.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * Information about the Capacity Reservation usage.
         */
        fun instanceUsages(instanceUsages: List<InstanceUsage>): FluentBuilder
        /**
         * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * active - The Capacity Reservation is active and the capacity is available for your use.
         * expired - The Capacity Reservation expired automatically at the date and time specified
         * in your request. The reserved capacity is no longer available for your use.
         * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no
         * longer available for your use.
         * pending - The Capacity Reservation request was successful but the capacity
         * provisioning is still pending.
         * failed - The Capacity Reservation request has failed. A request might fail
         * due to invalid request parameters, capacity constraints, or instance limit constraints.
         * Failed requests are retained for 60 minutes.
         */
        fun state(state: CapacityReservationState): FluentBuilder
        /**
         * The number of instances for which the Capacity Reservation reserves capacity.
         */
        fun totalInstanceCount(totalInstanceCount: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         */
        var availableInstanceCount: Int?
        /**
         * The ID of the Capacity Reservation.
         */
        var capacityReservationId: String?
        /**
         * The type of instance for which the Capacity Reservation reserves capacity.
         */
        var instanceType: String?
        /**
         * Information about the Capacity Reservation usage.
         */
        var instanceUsages: List<InstanceUsage>?
        /**
         * The token to use to retrieve the next page of results. This value is null when there are no more results to return.
         */
        var nextToken: String?
        /**
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * active - The Capacity Reservation is active and the capacity is available for your use.
         * expired - The Capacity Reservation expired automatically at the date and time specified
         * in your request. The reserved capacity is no longer available for your use.
         * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no
         * longer available for your use.
         * pending - The Capacity Reservation request was successful but the capacity
         * provisioning is still pending.
         * failed - The Capacity Reservation request has failed. A request might fail
         * due to invalid request parameters, capacity constraints, or instance limit constraints.
         * Failed requests are retained for 60 minutes.
         */
        var state: CapacityReservationState?
        /**
         * The number of instances for which the Capacity Reservation reserves capacity.
         */
        var totalInstanceCount: Int?

        fun build(): GetCapacityReservationUsageResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availableInstanceCount: Int? = null
        override var capacityReservationId: String? = null
        override var instanceType: String? = null
        override var instanceUsages: List<InstanceUsage>? = null
        override var nextToken: String? = null
        override var state: CapacityReservationState? = null
        override var totalInstanceCount: Int? = null

        constructor(x: GetCapacityReservationUsageResponse) : this() {
            this.availableInstanceCount = x.availableInstanceCount
            this.capacityReservationId = x.capacityReservationId
            this.instanceType = x.instanceType
            this.instanceUsages = x.instanceUsages
            this.nextToken = x.nextToken
            this.state = x.state
            this.totalInstanceCount = x.totalInstanceCount
        }

        override fun build(): GetCapacityReservationUsageResponse = GetCapacityReservationUsageResponse(this)
        override fun availableInstanceCount(availableInstanceCount: Int): FluentBuilder = apply { this.availableInstanceCount = availableInstanceCount }
        override fun capacityReservationId(capacityReservationId: String): FluentBuilder = apply { this.capacityReservationId = capacityReservationId }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun instanceUsages(instanceUsages: List<InstanceUsage>): FluentBuilder = apply { this.instanceUsages = instanceUsages }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun state(state: CapacityReservationState): FluentBuilder = apply { this.state = state }
        override fun totalInstanceCount(totalInstanceCount: Int): FluentBuilder = apply { this.totalInstanceCount = totalInstanceCount }
    }
}
