// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an event in the history of the Spot Fleet request.
 */
class HistoryRecord private constructor(builder: BuilderImpl) {
    /**
     * Information about the event.
     */
    val eventInformation: EventInformation? = builder.eventInformation
    /**
     * The event type.
     * error - An error with the Spot Fleet request.
     * fleetRequestChange - A change in the status or configuration of
     * the Spot Fleet request.
     * instanceChange - An instance was launched or terminated.
     * Information - An informational event.
     */
    val eventType: EventType? = builder.eventType
    /**
     * The date and time of the event, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     */
    val timestamp: Instant? = builder.timestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HistoryRecord = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HistoryRecord(")
        append("eventInformation=$eventInformation,")
        append("eventType=$eventType,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventInformation?.hashCode() ?: 0
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HistoryRecord

        if (eventInformation != other.eventInformation) return false
        if (eventType != other.eventType) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HistoryRecord = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HistoryRecord
        /**
         * Information about the event.
         */
        fun eventInformation(eventInformation: EventInformation): FluentBuilder
        /**
         * The event type.
         * error - An error with the Spot Fleet request.
         * fleetRequestChange - A change in the status or configuration of
         * the Spot Fleet request.
         * instanceChange - An instance was launched or terminated.
         * Information - An informational event.
         */
        fun eventType(eventType: EventType): FluentBuilder
        /**
         * The date and time of the event, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        fun timestamp(timestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the event.
         */
        var eventInformation: EventInformation?
        /**
         * The event type.
         * error - An error with the Spot Fleet request.
         * fleetRequestChange - A change in the status or configuration of
         * the Spot Fleet request.
         * instanceChange - An instance was launched or terminated.
         * Information - An informational event.
         */
        var eventType: EventType?
        /**
         * The date and time of the event, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         */
        var timestamp: Instant?

        fun build(): HistoryRecord
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EventInformation] inside the given [block]
         */
        fun eventInformation(block: EventInformation.DslBuilder.() -> kotlin.Unit) {
            this.eventInformation = EventInformation.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var eventInformation: EventInformation? = null
        override var eventType: EventType? = null
        override var timestamp: Instant? = null

        constructor(x: HistoryRecord) : this() {
            this.eventInformation = x.eventInformation
            this.eventType = x.eventType
            this.timestamp = x.timestamp
        }

        override fun build(): HistoryRecord = HistoryRecord(this)
        override fun eventInformation(eventInformation: EventInformation): FluentBuilder = apply { this.eventInformation = eventInformation }
        override fun eventType(eventType: EventType): FluentBuilder = apply { this.eventType = eventType }
        override fun timestamp(timestamp: Instant): FluentBuilder = apply { this.timestamp = timestamp }
    }
}
