// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the properties of the Dedicated Host.
 */
class Host private constructor(builder: BuilderImpl) {
    /**
     * The time that the Dedicated Host was allocated.
     */
    val allocationTime: Instant? = builder.allocationTime
    /**
     * Indicates whether the Dedicated Host supports multiple instance types of the same instance family.
     * If the value is on, the Dedicated Host supports multiple instance types in the instance family.
     * If the value is off, the Dedicated Host supports a single instance type only.
     */
    val allowsMultipleInstanceTypes: AllowsMultipleInstanceTypes? = builder.allowsMultipleInstanceTypes
    /**
     * Whether auto-placement is on or off.
     */
    val autoPlacement: AutoPlacement? = builder.autoPlacement
    /**
     * The Availability Zone of the Dedicated Host.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The ID of the Availability Zone in which the Dedicated Host is allocated.
     */
    val availabilityZoneId: String? = builder.availabilityZoneId
    /**
     * Information about the instances running on the Dedicated Host.
     */
    val availableCapacity: AvailableCapacity? = builder.availableCapacity
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The ID of the Dedicated Host.
     */
    val hostId: String? = builder.hostId
    /**
     * The hardware specifications of the Dedicated Host.
     */
    val hostProperties: HostProperties? = builder.hostProperties
    /**
     * Indicates whether host recovery is enabled or disabled for the Dedicated Host.
     */
    val hostRecovery: HostRecovery? = builder.hostRecovery
    /**
     * The reservation ID of the Dedicated Host. This returns a null response
     * if the Dedicated Host doesn't have an associated reservation.
     */
    val hostReservationId: String? = builder.hostReservationId
    /**
     * The IDs and instance type that are currently running on the Dedicated
     * Host.
     */
    val instances: List<HostInstance>? = builder.instances
    /**
     * Indicates whether the Dedicated Host is in a host resource group. If
     * memberOfServiceLinkedResourceGroup is
     * true, the host is in a host resource group; otherwise, it is not.
     */
    val memberOfServiceLinkedResourceGroup: Boolean? = builder.memberOfServiceLinkedResourceGroup
    /**
     * The ID of the Amazon Web Services account that owns the Dedicated Host.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The time that the Dedicated Host was released.
     */
    val releaseTime: Instant? = builder.releaseTime
    /**
     * The Dedicated Host's state.
     */
    val state: AllocationState? = builder.state
    /**
     * Any tags assigned to the Dedicated Host.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Host = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Host(")
        append("allocationTime=$allocationTime,")
        append("allowsMultipleInstanceTypes=$allowsMultipleInstanceTypes,")
        append("autoPlacement=$autoPlacement,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availableCapacity=$availableCapacity,")
        append("clientToken=$clientToken,")
        append("hostId=$hostId,")
        append("hostProperties=$hostProperties,")
        append("hostRecovery=$hostRecovery,")
        append("hostReservationId=$hostReservationId,")
        append("instances=$instances,")
        append("memberOfServiceLinkedResourceGroup=$memberOfServiceLinkedResourceGroup,")
        append("ownerId=$ownerId,")
        append("releaseTime=$releaseTime,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationTime?.hashCode() ?: 0
        result = 31 * result + (allowsMultipleInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (autoPlacement?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (availableCapacity?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (hostId?.hashCode() ?: 0)
        result = 31 * result + (hostProperties?.hashCode() ?: 0)
        result = 31 * result + (hostRecovery?.hashCode() ?: 0)
        result = 31 * result + (hostReservationId?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (memberOfServiceLinkedResourceGroup?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (releaseTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Host

        if (allocationTime != other.allocationTime) return false
        if (allowsMultipleInstanceTypes != other.allowsMultipleInstanceTypes) return false
        if (autoPlacement != other.autoPlacement) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availableCapacity != other.availableCapacity) return false
        if (clientToken != other.clientToken) return false
        if (hostId != other.hostId) return false
        if (hostProperties != other.hostProperties) return false
        if (hostRecovery != other.hostRecovery) return false
        if (hostReservationId != other.hostReservationId) return false
        if (instances != other.instances) return false
        if (memberOfServiceLinkedResourceGroup != other.memberOfServiceLinkedResourceGroup) return false
        if (ownerId != other.ownerId) return false
        if (releaseTime != other.releaseTime) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Host = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Host
        /**
         * The time that the Dedicated Host was allocated.
         */
        fun allocationTime(allocationTime: Instant): FluentBuilder
        /**
         * Indicates whether the Dedicated Host supports multiple instance types of the same instance family.
         * If the value is on, the Dedicated Host supports multiple instance types in the instance family.
         * If the value is off, the Dedicated Host supports a single instance type only.
         */
        fun allowsMultipleInstanceTypes(allowsMultipleInstanceTypes: AllowsMultipleInstanceTypes): FluentBuilder
        /**
         * Whether auto-placement is on or off.
         */
        fun autoPlacement(autoPlacement: AutoPlacement): FluentBuilder
        /**
         * The Availability Zone of the Dedicated Host.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The ID of the Availability Zone in which the Dedicated Host is allocated.
         */
        fun availabilityZoneId(availabilityZoneId: String): FluentBuilder
        /**
         * Information about the instances running on the Dedicated Host.
         */
        fun availableCapacity(availableCapacity: AvailableCapacity): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The ID of the Dedicated Host.
         */
        fun hostId(hostId: String): FluentBuilder
        /**
         * The hardware specifications of the Dedicated Host.
         */
        fun hostProperties(hostProperties: HostProperties): FluentBuilder
        /**
         * Indicates whether host recovery is enabled or disabled for the Dedicated Host.
         */
        fun hostRecovery(hostRecovery: HostRecovery): FluentBuilder
        /**
         * The reservation ID of the Dedicated Host. This returns a null response
         * if the Dedicated Host doesn't have an associated reservation.
         */
        fun hostReservationId(hostReservationId: String): FluentBuilder
        /**
         * The IDs and instance type that are currently running on the Dedicated
         * Host.
         */
        fun instances(instances: List<HostInstance>): FluentBuilder
        /**
         * Indicates whether the Dedicated Host is in a host resource group. If
         * memberOfServiceLinkedResourceGroup is
         * true, the host is in a host resource group; otherwise, it is not.
         */
        fun memberOfServiceLinkedResourceGroup(memberOfServiceLinkedResourceGroup: Boolean): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the Dedicated Host.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The time that the Dedicated Host was released.
         */
        fun releaseTime(releaseTime: Instant): FluentBuilder
        /**
         * The Dedicated Host's state.
         */
        fun state(state: AllocationState): FluentBuilder
        /**
         * Any tags assigned to the Dedicated Host.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time that the Dedicated Host was allocated.
         */
        var allocationTime: Instant?
        /**
         * Indicates whether the Dedicated Host supports multiple instance types of the same instance family.
         * If the value is on, the Dedicated Host supports multiple instance types in the instance family.
         * If the value is off, the Dedicated Host supports a single instance type only.
         */
        var allowsMultipleInstanceTypes: AllowsMultipleInstanceTypes?
        /**
         * Whether auto-placement is on or off.
         */
        var autoPlacement: AutoPlacement?
        /**
         * The Availability Zone of the Dedicated Host.
         */
        var availabilityZone: String?
        /**
         * The ID of the Availability Zone in which the Dedicated Host is allocated.
         */
        var availabilityZoneId: String?
        /**
         * Information about the instances running on the Dedicated Host.
         */
        var availableCapacity: AvailableCapacity?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * The ID of the Dedicated Host.
         */
        var hostId: String?
        /**
         * The hardware specifications of the Dedicated Host.
         */
        var hostProperties: HostProperties?
        /**
         * Indicates whether host recovery is enabled or disabled for the Dedicated Host.
         */
        var hostRecovery: HostRecovery?
        /**
         * The reservation ID of the Dedicated Host. This returns a null response
         * if the Dedicated Host doesn't have an associated reservation.
         */
        var hostReservationId: String?
        /**
         * The IDs and instance type that are currently running on the Dedicated
         * Host.
         */
        var instances: List<HostInstance>?
        /**
         * Indicates whether the Dedicated Host is in a host resource group. If
         * memberOfServiceLinkedResourceGroup is
         * true, the host is in a host resource group; otherwise, it is not.
         */
        var memberOfServiceLinkedResourceGroup: Boolean?
        /**
         * The ID of the Amazon Web Services account that owns the Dedicated Host.
         */
        var ownerId: String?
        /**
         * The time that the Dedicated Host was released.
         */
        var releaseTime: Instant?
        /**
         * The Dedicated Host's state.
         */
        var state: AllocationState?
        /**
         * Any tags assigned to the Dedicated Host.
         */
        var tags: List<Tag>?

        fun build(): Host
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AvailableCapacity] inside the given [block]
         */
        fun availableCapacity(block: AvailableCapacity.DslBuilder.() -> kotlin.Unit) {
            this.availableCapacity = AvailableCapacity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.HostProperties] inside the given [block]
         */
        fun hostProperties(block: HostProperties.DslBuilder.() -> kotlin.Unit) {
            this.hostProperties = HostProperties.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationTime: Instant? = null
        override var allowsMultipleInstanceTypes: AllowsMultipleInstanceTypes? = null
        override var autoPlacement: AutoPlacement? = null
        override var availabilityZone: String? = null
        override var availabilityZoneId: String? = null
        override var availableCapacity: AvailableCapacity? = null
        override var clientToken: String? = null
        override var hostId: String? = null
        override var hostProperties: HostProperties? = null
        override var hostRecovery: HostRecovery? = null
        override var hostReservationId: String? = null
        override var instances: List<HostInstance>? = null
        override var memberOfServiceLinkedResourceGroup: Boolean? = null
        override var ownerId: String? = null
        override var releaseTime: Instant? = null
        override var state: AllocationState? = null
        override var tags: List<Tag>? = null

        constructor(x: Host) : this() {
            this.allocationTime = x.allocationTime
            this.allowsMultipleInstanceTypes = x.allowsMultipleInstanceTypes
            this.autoPlacement = x.autoPlacement
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.availableCapacity = x.availableCapacity
            this.clientToken = x.clientToken
            this.hostId = x.hostId
            this.hostProperties = x.hostProperties
            this.hostRecovery = x.hostRecovery
            this.hostReservationId = x.hostReservationId
            this.instances = x.instances
            this.memberOfServiceLinkedResourceGroup = x.memberOfServiceLinkedResourceGroup
            this.ownerId = x.ownerId
            this.releaseTime = x.releaseTime
            this.state = x.state
            this.tags = x.tags
        }

        override fun build(): Host = Host(this)
        override fun allocationTime(allocationTime: Instant): FluentBuilder = apply { this.allocationTime = allocationTime }
        override fun allowsMultipleInstanceTypes(allowsMultipleInstanceTypes: AllowsMultipleInstanceTypes): FluentBuilder = apply { this.allowsMultipleInstanceTypes = allowsMultipleInstanceTypes }
        override fun autoPlacement(autoPlacement: AutoPlacement): FluentBuilder = apply { this.autoPlacement = autoPlacement }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneId(availabilityZoneId: String): FluentBuilder = apply { this.availabilityZoneId = availabilityZoneId }
        override fun availableCapacity(availableCapacity: AvailableCapacity): FluentBuilder = apply { this.availableCapacity = availableCapacity }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun hostId(hostId: String): FluentBuilder = apply { this.hostId = hostId }
        override fun hostProperties(hostProperties: HostProperties): FluentBuilder = apply { this.hostProperties = hostProperties }
        override fun hostRecovery(hostRecovery: HostRecovery): FluentBuilder = apply { this.hostRecovery = hostRecovery }
        override fun hostReservationId(hostReservationId: String): FluentBuilder = apply { this.hostReservationId = hostReservationId }
        override fun instances(instances: List<HostInstance>): FluentBuilder = apply { this.instances = instances }
        override fun memberOfServiceLinkedResourceGroup(memberOfServiceLinkedResourceGroup: Boolean): FluentBuilder = apply { this.memberOfServiceLinkedResourceGroup = memberOfServiceLinkedResourceGroup }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun releaseTime(releaseTime: Instant): FluentBuilder = apply { this.releaseTime = releaseTime }
        override fun state(state: AllocationState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
