// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an instance running on a Dedicated Host.
 */
class HostInstance private constructor(builder: BuilderImpl) {
    /**
     * The ID of instance that is running on the Dedicated Host.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The instance type (for example, m3.medium) of the running instance.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The ID of the Amazon Web Services account that owns the instance.
     */
    val ownerId: String? = builder.ownerId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HostInstance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HostInstance(")
        append("instanceId=$instanceId,")
        append("instanceType=$instanceType,")
        append("ownerId=$ownerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceId?.hashCode() ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HostInstance

        if (instanceId != other.instanceId) return false
        if (instanceType != other.instanceType) return false
        if (ownerId != other.ownerId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HostInstance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HostInstance
        /**
         * The ID of instance that is running on the Dedicated Host.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The instance type (for example, m3.medium) of the running instance.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the instance.
         */
        fun ownerId(ownerId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of instance that is running on the Dedicated Host.
         */
        var instanceId: String?
        /**
         * The instance type (for example, m3.medium) of the running instance.
         */
        var instanceType: String?
        /**
         * The ID of the Amazon Web Services account that owns the instance.
         */
        var ownerId: String?

        fun build(): HostInstance
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var instanceId: String? = null
        override var instanceType: String? = null
        override var ownerId: String? = null

        constructor(x: HostInstance) : this() {
            this.instanceId = x.instanceId
            this.instanceType = x.instanceType
            this.ownerId = x.ownerId
        }

        override fun build(): HostInstance = HostInstance(this)
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
    }
}
