// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Details about the Dedicated Host Reservation offering.
 */
class HostOffering private constructor(builder: BuilderImpl) {
    /**
     * The currency of the offering.
     */
    val currencyCode: CurrencyCodeValues? = builder.currencyCode
    /**
     * The duration of the offering (in seconds).
     */
    val duration: Int? = builder.duration
    /**
     * The hourly price of the offering.
     */
    val hourlyPrice: String? = builder.hourlyPrice
    /**
     * The instance family of the offering.
     */
    val instanceFamily: String? = builder.instanceFamily
    /**
     * The ID of the offering.
     */
    val offeringId: String? = builder.offeringId
    /**
     * The available payment option.
     */
    val paymentOption: PaymentOption? = builder.paymentOption
    /**
     * The upfront price of the offering. Does not apply to No Upfront
     * offerings.
     */
    val upfrontPrice: String? = builder.upfrontPrice

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HostOffering = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HostOffering(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("hourlyPrice=$hourlyPrice,")
        append("instanceFamily=$instanceFamily,")
        append("offeringId=$offeringId,")
        append("paymentOption=$paymentOption,")
        append("upfrontPrice=$upfrontPrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (hourlyPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceFamily?.hashCode() ?: 0)
        result = 31 * result + (offeringId?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (upfrontPrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HostOffering

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (hourlyPrice != other.hourlyPrice) return false
        if (instanceFamily != other.instanceFamily) return false
        if (offeringId != other.offeringId) return false
        if (paymentOption != other.paymentOption) return false
        if (upfrontPrice != other.upfrontPrice) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HostOffering = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HostOffering
        /**
         * The currency of the offering.
         */
        fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder
        /**
         * The duration of the offering (in seconds).
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The hourly price of the offering.
         */
        fun hourlyPrice(hourlyPrice: String): FluentBuilder
        /**
         * The instance family of the offering.
         */
        fun instanceFamily(instanceFamily: String): FluentBuilder
        /**
         * The ID of the offering.
         */
        fun offeringId(offeringId: String): FluentBuilder
        /**
         * The available payment option.
         */
        fun paymentOption(paymentOption: PaymentOption): FluentBuilder
        /**
         * The upfront price of the offering. Does not apply to No Upfront
         * offerings.
         */
        fun upfrontPrice(upfrontPrice: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The currency of the offering.
         */
        var currencyCode: CurrencyCodeValues?
        /**
         * The duration of the offering (in seconds).
         */
        var duration: Int?
        /**
         * The hourly price of the offering.
         */
        var hourlyPrice: String?
        /**
         * The instance family of the offering.
         */
        var instanceFamily: String?
        /**
         * The ID of the offering.
         */
        var offeringId: String?
        /**
         * The available payment option.
         */
        var paymentOption: PaymentOption?
        /**
         * The upfront price of the offering. Does not apply to No Upfront
         * offerings.
         */
        var upfrontPrice: String?

        fun build(): HostOffering
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currencyCode: CurrencyCodeValues? = null
        override var duration: Int? = null
        override var hourlyPrice: String? = null
        override var instanceFamily: String? = null
        override var offeringId: String? = null
        override var paymentOption: PaymentOption? = null
        override var upfrontPrice: String? = null

        constructor(x: HostOffering) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.hourlyPrice = x.hourlyPrice
            this.instanceFamily = x.instanceFamily
            this.offeringId = x.offeringId
            this.paymentOption = x.paymentOption
            this.upfrontPrice = x.upfrontPrice
        }

        override fun build(): HostOffering = HostOffering(this)
        override fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun hourlyPrice(hourlyPrice: String): FluentBuilder = apply { this.hourlyPrice = hourlyPrice }
        override fun instanceFamily(instanceFamily: String): FluentBuilder = apply { this.instanceFamily = instanceFamily }
        override fun offeringId(offeringId: String): FluentBuilder = apply { this.offeringId = offeringId }
        override fun paymentOption(paymentOption: PaymentOption): FluentBuilder = apply { this.paymentOption = paymentOption }
        override fun upfrontPrice(upfrontPrice: String): FluentBuilder = apply { this.upfrontPrice = upfrontPrice }
    }
}
