// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the properties of a Dedicated Host.
 */
class HostProperties private constructor(builder: BuilderImpl) {
    /**
     * The number of cores on the Dedicated Host.
     */
    val cores: Int? = builder.cores
    /**
     * The instance family supported by the Dedicated Host. For example, m5.
     */
    val instanceFamily: String? = builder.instanceFamily
    /**
     * The instance type supported by the Dedicated Host. For example, m5.large.
     * If the host supports multiple instance types, no instanceType
     * is returned.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The number of sockets on the Dedicated Host.
     */
    val sockets: Int? = builder.sockets
    /**
     * The total number of vCPUs on the Dedicated Host.
     */
    val totalVCpus: Int? = builder.totalVCpus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HostProperties = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HostProperties(")
        append("cores=$cores,")
        append("instanceFamily=$instanceFamily,")
        append("instanceType=$instanceType,")
        append("sockets=$sockets,")
        append("totalVCpus=$totalVCpus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cores ?: 0
        result = 31 * result + (instanceFamily?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (sockets ?: 0)
        result = 31 * result + (totalVCpus ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HostProperties

        if (cores != other.cores) return false
        if (instanceFamily != other.instanceFamily) return false
        if (instanceType != other.instanceType) return false
        if (sockets != other.sockets) return false
        if (totalVCpus != other.totalVCpus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HostProperties = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HostProperties
        /**
         * The number of cores on the Dedicated Host.
         */
        fun cores(cores: Int): FluentBuilder
        /**
         * The instance family supported by the Dedicated Host. For example, m5.
         */
        fun instanceFamily(instanceFamily: String): FluentBuilder
        /**
         * The instance type supported by the Dedicated Host. For example, m5.large.
         * If the host supports multiple instance types, no instanceType
         * is returned.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The number of sockets on the Dedicated Host.
         */
        fun sockets(sockets: Int): FluentBuilder
        /**
         * The total number of vCPUs on the Dedicated Host.
         */
        fun totalVCpus(totalVCpus: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of cores on the Dedicated Host.
         */
        var cores: Int?
        /**
         * The instance family supported by the Dedicated Host. For example, m5.
         */
        var instanceFamily: String?
        /**
         * The instance type supported by the Dedicated Host. For example, m5.large.
         * If the host supports multiple instance types, no instanceType
         * is returned.
         */
        var instanceType: String?
        /**
         * The number of sockets on the Dedicated Host.
         */
        var sockets: Int?
        /**
         * The total number of vCPUs on the Dedicated Host.
         */
        var totalVCpus: Int?

        fun build(): HostProperties
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cores: Int? = null
        override var instanceFamily: String? = null
        override var instanceType: String? = null
        override var sockets: Int? = null
        override var totalVCpus: Int? = null

        constructor(x: HostProperties) : this() {
            this.cores = x.cores
            this.instanceFamily = x.instanceFamily
            this.instanceType = x.instanceType
            this.sockets = x.sockets
            this.totalVCpus = x.totalVCpus
        }

        override fun build(): HostProperties = HostProperties(this)
        override fun cores(cores: Int): FluentBuilder = apply { this.cores = cores }
        override fun instanceFamily(instanceFamily: String): FluentBuilder = apply { this.instanceFamily = instanceFamily }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun sockets(sockets: Int): FluentBuilder = apply { this.sockets = sockets }
        override fun totalVCpus(totalVCpus: Int): FluentBuilder = apply { this.totalVCpus = totalVCpus }
    }
}
