// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about the Dedicated Host Reservation and associated Dedicated
 * Hosts.
 */
class HostReservation private constructor(builder: BuilderImpl) {
    /**
     * The number of Dedicated Hosts the reservation is associated with.
     */
    val count: Int? = builder.count
    /**
     * The currency in which the upfrontPrice and hourlyPrice
     * amounts are specified. At this time, the only supported currency is
     * USD.
     */
    val currencyCode: CurrencyCodeValues? = builder.currencyCode
    /**
     * The length of the reservation's term, specified in seconds. Can be 31536000
     * (1 year) | 94608000 (3 years).
     */
    val duration: Int? = builder.duration
    /**
     * The date and time that the reservation ends.
     */
    val end: Instant? = builder.end
    /**
     * The IDs of the Dedicated Hosts associated with the reservation.
     */
    val hostIdSet: List<String>? = builder.hostIdSet
    /**
     * The ID of the reservation that specifies the associated Dedicated Hosts.
     */
    val hostReservationId: String? = builder.hostReservationId
    /**
     * The hourly price of the reservation.
     */
    val hourlyPrice: String? = builder.hourlyPrice
    /**
     * The instance family of the Dedicated Host Reservation. The instance family on the
     * Dedicated Host must be the same in order for it to benefit from the
     * reservation.
     */
    val instanceFamily: String? = builder.instanceFamily
    /**
     * The ID of the reservation. This remains the same regardless of which Dedicated
     * Hosts are associated with it.
     */
    val offeringId: String? = builder.offeringId
    /**
     * The payment option selected for this reservation.
     */
    val paymentOption: PaymentOption? = builder.paymentOption
    /**
     * The date and time that the reservation started.
     */
    val start: Instant? = builder.start
    /**
     * The state of the reservation.
     */
    val state: ReservationState? = builder.state
    /**
     * Any tags assigned to the Dedicated Host Reservation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The upfront price of the reservation.
     */
    val upfrontPrice: String? = builder.upfrontPrice

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HostReservation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HostReservation(")
        append("count=$count,")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("end=$end,")
        append("hostIdSet=$hostIdSet,")
        append("hostReservationId=$hostReservationId,")
        append("hourlyPrice=$hourlyPrice,")
        append("instanceFamily=$instanceFamily,")
        append("offeringId=$offeringId,")
        append("paymentOption=$paymentOption,")
        append("start=$start,")
        append("state=$state,")
        append("tags=$tags,")
        append("upfrontPrice=$upfrontPrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = count ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (end?.hashCode() ?: 0)
        result = 31 * result + (hostIdSet?.hashCode() ?: 0)
        result = 31 * result + (hostReservationId?.hashCode() ?: 0)
        result = 31 * result + (hourlyPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceFamily?.hashCode() ?: 0)
        result = 31 * result + (offeringId?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (start?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (upfrontPrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HostReservation

        if (count != other.count) return false
        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (end != other.end) return false
        if (hostIdSet != other.hostIdSet) return false
        if (hostReservationId != other.hostReservationId) return false
        if (hourlyPrice != other.hourlyPrice) return false
        if (instanceFamily != other.instanceFamily) return false
        if (offeringId != other.offeringId) return false
        if (paymentOption != other.paymentOption) return false
        if (start != other.start) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (upfrontPrice != other.upfrontPrice) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HostReservation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HostReservation
        /**
         * The number of Dedicated Hosts the reservation is associated with.
         */
        fun count(count: Int): FluentBuilder
        /**
         * The currency in which the upfrontPrice and hourlyPrice
         * amounts are specified. At this time, the only supported currency is
         * USD.
         */
        fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder
        /**
         * The length of the reservation's term, specified in seconds. Can be 31536000
         * (1 year) | 94608000 (3 years).
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The date and time that the reservation ends.
         */
        fun end(end: Instant): FluentBuilder
        /**
         * The IDs of the Dedicated Hosts associated with the reservation.
         */
        fun hostIdSet(hostIdSet: List<String>): FluentBuilder
        /**
         * The ID of the reservation that specifies the associated Dedicated Hosts.
         */
        fun hostReservationId(hostReservationId: String): FluentBuilder
        /**
         * The hourly price of the reservation.
         */
        fun hourlyPrice(hourlyPrice: String): FluentBuilder
        /**
         * The instance family of the Dedicated Host Reservation. The instance family on the
         * Dedicated Host must be the same in order for it to benefit from the
         * reservation.
         */
        fun instanceFamily(instanceFamily: String): FluentBuilder
        /**
         * The ID of the reservation. This remains the same regardless of which Dedicated
         * Hosts are associated with it.
         */
        fun offeringId(offeringId: String): FluentBuilder
        /**
         * The payment option selected for this reservation.
         */
        fun paymentOption(paymentOption: PaymentOption): FluentBuilder
        /**
         * The date and time that the reservation started.
         */
        fun start(start: Instant): FluentBuilder
        /**
         * The state of the reservation.
         */
        fun state(state: ReservationState): FluentBuilder
        /**
         * Any tags assigned to the Dedicated Host Reservation.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The upfront price of the reservation.
         */
        fun upfrontPrice(upfrontPrice: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of Dedicated Hosts the reservation is associated with.
         */
        var count: Int?
        /**
         * The currency in which the upfrontPrice and hourlyPrice
         * amounts are specified. At this time, the only supported currency is
         * USD.
         */
        var currencyCode: CurrencyCodeValues?
        /**
         * The length of the reservation's term, specified in seconds. Can be 31536000
         * (1 year) | 94608000 (3 years).
         */
        var duration: Int?
        /**
         * The date and time that the reservation ends.
         */
        var end: Instant?
        /**
         * The IDs of the Dedicated Hosts associated with the reservation.
         */
        var hostIdSet: List<String>?
        /**
         * The ID of the reservation that specifies the associated Dedicated Hosts.
         */
        var hostReservationId: String?
        /**
         * The hourly price of the reservation.
         */
        var hourlyPrice: String?
        /**
         * The instance family of the Dedicated Host Reservation. The instance family on the
         * Dedicated Host must be the same in order for it to benefit from the
         * reservation.
         */
        var instanceFamily: String?
        /**
         * The ID of the reservation. This remains the same regardless of which Dedicated
         * Hosts are associated with it.
         */
        var offeringId: String?
        /**
         * The payment option selected for this reservation.
         */
        var paymentOption: PaymentOption?
        /**
         * The date and time that the reservation started.
         */
        var start: Instant?
        /**
         * The state of the reservation.
         */
        var state: ReservationState?
        /**
         * Any tags assigned to the Dedicated Host Reservation.
         */
        var tags: List<Tag>?
        /**
         * The upfront price of the reservation.
         */
        var upfrontPrice: String?

        fun build(): HostReservation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var count: Int? = null
        override var currencyCode: CurrencyCodeValues? = null
        override var duration: Int? = null
        override var end: Instant? = null
        override var hostIdSet: List<String>? = null
        override var hostReservationId: String? = null
        override var hourlyPrice: String? = null
        override var instanceFamily: String? = null
        override var offeringId: String? = null
        override var paymentOption: PaymentOption? = null
        override var start: Instant? = null
        override var state: ReservationState? = null
        override var tags: List<Tag>? = null
        override var upfrontPrice: String? = null

        constructor(x: HostReservation) : this() {
            this.count = x.count
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.end = x.end
            this.hostIdSet = x.hostIdSet
            this.hostReservationId = x.hostReservationId
            this.hourlyPrice = x.hourlyPrice
            this.instanceFamily = x.instanceFamily
            this.offeringId = x.offeringId
            this.paymentOption = x.paymentOption
            this.start = x.start
            this.state = x.state
            this.tags = x.tags
            this.upfrontPrice = x.upfrontPrice
        }

        override fun build(): HostReservation = HostReservation(this)
        override fun count(count: Int): FluentBuilder = apply { this.count = count }
        override fun currencyCode(currencyCode: CurrencyCodeValues): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun end(end: Instant): FluentBuilder = apply { this.end = end }
        override fun hostIdSet(hostIdSet: List<String>): FluentBuilder = apply { this.hostIdSet = hostIdSet }
        override fun hostReservationId(hostReservationId: String): FluentBuilder = apply { this.hostReservationId = hostReservationId }
        override fun hourlyPrice(hourlyPrice: String): FluentBuilder = apply { this.hourlyPrice = hourlyPrice }
        override fun instanceFamily(instanceFamily: String): FluentBuilder = apply { this.instanceFamily = instanceFamily }
        override fun offeringId(offeringId: String): FluentBuilder = apply { this.offeringId = offeringId }
        override fun paymentOption(paymentOption: PaymentOption): FluentBuilder = apply { this.paymentOption = paymentOption }
        override fun start(start: Instant): FluentBuilder = apply { this.start = start }
        override fun state(state: ReservationState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun upfrontPrice(upfrontPrice: String): FluentBuilder = apply { this.upfrontPrice = upfrontPrice }
    }
}
