// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an association between an IAM instance profile and an instance.
 */
class IamInstanceProfileAssociation private constructor(builder: BuilderImpl) {
    /**
     * The ID of the association.
     */
    val associationId: String? = builder.associationId
    /**
     * The IAM instance profile.
     */
    val iamInstanceProfile: IamInstanceProfile? = builder.iamInstanceProfile
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The state of the association.
     */
    val state: IamInstanceProfileAssociationState? = builder.state
    /**
     * The time the IAM instance profile was associated with the instance.
     */
    val timestamp: Instant? = builder.timestamp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IamInstanceProfileAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IamInstanceProfileAssociation(")
        append("associationId=$associationId,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("instanceId=$instanceId,")
        append("state=$state,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IamInstanceProfileAssociation

        if (associationId != other.associationId) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (instanceId != other.instanceId) return false
        if (state != other.state) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IamInstanceProfileAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IamInstanceProfileAssociation
        /**
         * The ID of the association.
         */
        fun associationId(associationId: String): FluentBuilder
        /**
         * The IAM instance profile.
         */
        fun iamInstanceProfile(iamInstanceProfile: IamInstanceProfile): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The state of the association.
         */
        fun state(state: IamInstanceProfileAssociationState): FluentBuilder
        /**
         * The time the IAM instance profile was associated with the instance.
         */
        fun timestamp(timestamp: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the association.
         */
        var associationId: String?
        /**
         * The IAM instance profile.
         */
        var iamInstanceProfile: IamInstanceProfile?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * The state of the association.
         */
        var state: IamInstanceProfileAssociationState?
        /**
         * The time the IAM instance profile was associated with the instance.
         */
        var timestamp: Instant?

        fun build(): IamInstanceProfileAssociation
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IamInstanceProfile] inside the given [block]
         */
        fun iamInstanceProfile(block: IamInstanceProfile.DslBuilder.() -> kotlin.Unit) {
            this.iamInstanceProfile = IamInstanceProfile.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associationId: String? = null
        override var iamInstanceProfile: IamInstanceProfile? = null
        override var instanceId: String? = null
        override var state: IamInstanceProfileAssociationState? = null
        override var timestamp: Instant? = null

        constructor(x: IamInstanceProfileAssociation) : this() {
            this.associationId = x.associationId
            this.iamInstanceProfile = x.iamInstanceProfile
            this.instanceId = x.instanceId
            this.state = x.state
            this.timestamp = x.timestamp
        }

        override fun build(): IamInstanceProfileAssociation = IamInstanceProfileAssociation(this)
        override fun associationId(associationId: String): FluentBuilder = apply { this.associationId = associationId }
        override fun iamInstanceProfile(iamInstanceProfile: IamInstanceProfile): FluentBuilder = apply { this.iamInstanceProfile = iamInstanceProfile }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun state(state: IamInstanceProfileAssociationState): FluentBuilder = apply { this.state = state }
        override fun timestamp(timestamp: Instant): FluentBuilder = apply { this.timestamp = timestamp }
    }
}
