// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an image.
 */
class Image private constructor(builder: BuilderImpl) {
    /**
     * The architecture of the image.
     */
    val architecture: ArchitectureValues? = builder.architecture
    /**
     * Any block device mapping entries.
     */
    val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The boot mode of the image. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val bootMode: BootModeValues? = builder.bootMode
    /**
     * The date and time the image was created.
     */
    val creationDate: String? = builder.creationDate
    /**
     * The date and time to deprecate the AMI, in UTC, in the following format:
     * YYYY-MM-DDTHH:MM:SSZ.
     * If you specified a value for seconds, Amazon EC2 rounds the seconds to the
     * nearest minute.
     */
    val deprecationTime: String? = builder.deprecationTime
    /**
     * The description of the AMI that was provided during image creation.
     */
    val description: String? = builder.description
    /**
     * Specifies whether enhanced networking with ENA is enabled.
     */
    val enaSupport: Boolean? = builder.enaSupport
    /**
     * The hypervisor type of the image.
     */
    val hypervisor: HypervisorType? = builder.hypervisor
    /**
     * The ID of the AMI.
     */
    val imageId: String? = builder.imageId
    /**
     * The location of the AMI.
     */
    val imageLocation: String? = builder.imageLocation
    /**
     * The Amazon Web Services account alias (for example, amazon, self) or
     * the Amazon Web Services account ID of the AMI owner.
     */
    val imageOwnerAlias: String? = builder.imageOwnerAlias
    /**
     * The type of image.
     */
    val imageType: ImageTypeValues? = builder.imageType
    /**
     * The kernel associated with the image, if any. Only applicable for machine images.
     */
    val kernelId: String? = builder.kernelId
    /**
     * The name of the AMI that was provided during image creation.
     */
    val name: String? = builder.name
    /**
     * The ID of the Amazon Web Services account that owns the image.
     */
    val ownerId: String? = builder.ownerId
    /**
     * This value is set to windows for Windows AMIs; otherwise, it is blank.
     */
    val platform: PlatformValues? = builder.platform
    /**
     * The platform details associated with the billing code of the AMI. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understanding
     * AMI billing in the Amazon Elastic Compute Cloud User Guide.
     */
    val platformDetails: String? = builder.platformDetails
    /**
     * Any product codes associated with the AMI.
     */
    val productCodes: List<ProductCode>? = builder.productCodes
    /**
     * Indicates whether the image has public launch permissions. The value is true if
     * this image has public launch permissions or false
     * if it has only implicit and explicit launch permissions.
     */
    val public: Boolean? = builder.public
    /**
     * The RAM disk associated with the image, if any. Only applicable for machine images.
     */
    val ramdiskId: String? = builder.ramdiskId
    /**
     * The device name of the root device volume (for example, /dev/sda1).
     */
    val rootDeviceName: String? = builder.rootDeviceName
    /**
     * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
     */
    val rootDeviceType: DeviceType? = builder.rootDeviceType
    /**
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    val sriovNetSupport: String? = builder.sriovNetSupport
    /**
     * The current state of the AMI. If the state is available, the image is successfully registered and can be used to launch an instance.
     */
    val state: ImageState? = builder.state
    /**
     * The reason for the state change.
     */
    val stateReason: StateReason? = builder.stateReason
    /**
     * Any tags assigned to the image.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
     * usageOperation corresponds to the <a href="https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation">lineitem/Operation column on your Amazon Web Services Cost and Usage Report and in the <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html">Amazon Web Services Price
     * List API. You can view these fields on the Instances or
     * AMIs pages in the Amazon EC2 console, or in the responses that are
     * returned by the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">DescribeImages
     * command in the Amazon EC2 API, or the <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html">describe-images
     * command in the CLI.
     */
    val usageOperation: String? = builder.usageOperation
    /**
     * The type of virtualization of the AMI.
     */
    val virtualizationType: VirtualizationType? = builder.virtualizationType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Image = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Image(")
        append("architecture=$architecture,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("bootMode=$bootMode,")
        append("creationDate=$creationDate,")
        append("deprecationTime=$deprecationTime,")
        append("description=$description,")
        append("enaSupport=$enaSupport,")
        append("hypervisor=$hypervisor,")
        append("imageId=$imageId,")
        append("imageLocation=$imageLocation,")
        append("imageOwnerAlias=$imageOwnerAlias,")
        append("imageType=$imageType,")
        append("kernelId=$kernelId,")
        append("name=$name,")
        append("ownerId=$ownerId,")
        append("platform=$platform,")
        append("platformDetails=$platformDetails,")
        append("productCodes=$productCodes,")
        append("public=$public,")
        append("ramdiskId=$ramdiskId,")
        append("rootDeviceName=$rootDeviceName,")
        append("rootDeviceType=$rootDeviceType,")
        append("sriovNetSupport=$sriovNetSupport,")
        append("state=$state,")
        append("stateReason=$stateReason,")
        append("tags=$tags,")
        append("usageOperation=$usageOperation,")
        append("virtualizationType=$virtualizationType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (bootMode?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (deprecationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (hypervisor?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (imageLocation?.hashCode() ?: 0)
        result = 31 * result + (imageOwnerAlias?.hashCode() ?: 0)
        result = 31 * result + (imageType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (platformDetails?.hashCode() ?: 0)
        result = 31 * result + (productCodes?.hashCode() ?: 0)
        result = 31 * result + (public?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceName?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceType?.hashCode() ?: 0)
        result = 31 * result + (sriovNetSupport?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usageOperation?.hashCode() ?: 0)
        result = 31 * result + (virtualizationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Image

        if (architecture != other.architecture) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (bootMode != other.bootMode) return false
        if (creationDate != other.creationDate) return false
        if (deprecationTime != other.deprecationTime) return false
        if (description != other.description) return false
        if (enaSupport != other.enaSupport) return false
        if (hypervisor != other.hypervisor) return false
        if (imageId != other.imageId) return false
        if (imageLocation != other.imageLocation) return false
        if (imageOwnerAlias != other.imageOwnerAlias) return false
        if (imageType != other.imageType) return false
        if (kernelId != other.kernelId) return false
        if (name != other.name) return false
        if (ownerId != other.ownerId) return false
        if (platform != other.platform) return false
        if (platformDetails != other.platformDetails) return false
        if (productCodes != other.productCodes) return false
        if (public != other.public) return false
        if (ramdiskId != other.ramdiskId) return false
        if (rootDeviceName != other.rootDeviceName) return false
        if (rootDeviceType != other.rootDeviceType) return false
        if (sriovNetSupport != other.sriovNetSupport) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false
        if (tags != other.tags) return false
        if (usageOperation != other.usageOperation) return false
        if (virtualizationType != other.virtualizationType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Image = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Image
        /**
         * The architecture of the image.
         */
        fun architecture(architecture: ArchitectureValues): FluentBuilder
        /**
         * Any block device mapping entries.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<BlockDeviceMapping>): FluentBuilder
        /**
         * The boot mode of the image. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun bootMode(bootMode: BootModeValues): FluentBuilder
        /**
         * The date and time the image was created.
         */
        fun creationDate(creationDate: String): FluentBuilder
        /**
         * The date and time to deprecate the AMI, in UTC, in the following format:
         * YYYY-MM-DDTHH:MM:SSZ.
         * If you specified a value for seconds, Amazon EC2 rounds the seconds to the
         * nearest minute.
         */
        fun deprecationTime(deprecationTime: String): FluentBuilder
        /**
         * The description of the AMI that was provided during image creation.
         */
        fun description(description: String): FluentBuilder
        /**
         * Specifies whether enhanced networking with ENA is enabled.
         */
        fun enaSupport(enaSupport: Boolean): FluentBuilder
        /**
         * The hypervisor type of the image.
         */
        fun hypervisor(hypervisor: HypervisorType): FluentBuilder
        /**
         * The ID of the AMI.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The location of the AMI.
         */
        fun imageLocation(imageLocation: String): FluentBuilder
        /**
         * The Amazon Web Services account alias (for example, amazon, self) or
         * the Amazon Web Services account ID of the AMI owner.
         */
        fun imageOwnerAlias(imageOwnerAlias: String): FluentBuilder
        /**
         * The type of image.
         */
        fun imageType(imageType: ImageTypeValues): FluentBuilder
        /**
         * The kernel associated with the image, if any. Only applicable for machine images.
         */
        fun kernelId(kernelId: String): FluentBuilder
        /**
         * The name of the AMI that was provided during image creation.
         */
        fun name(name: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the image.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * This value is set to windows for Windows AMIs; otherwise, it is blank.
         */
        fun platform(platform: PlatformValues): FluentBuilder
        /**
         * The platform details associated with the billing code of the AMI. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understanding
         * AMI billing in the Amazon Elastic Compute Cloud User Guide.
         */
        fun platformDetails(platformDetails: String): FluentBuilder
        /**
         * Any product codes associated with the AMI.
         */
        fun productCodes(productCodes: List<ProductCode>): FluentBuilder
        /**
         * Indicates whether the image has public launch permissions. The value is true if
         * this image has public launch permissions or false
         * if it has only implicit and explicit launch permissions.
         */
        fun public(public: Boolean): FluentBuilder
        /**
         * The RAM disk associated with the image, if any. Only applicable for machine images.
         */
        fun ramdiskId(ramdiskId: String): FluentBuilder
        /**
         * The device name of the root device volume (for example, /dev/sda1).
         */
        fun rootDeviceName(rootDeviceName: String): FluentBuilder
        /**
         * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
         */
        fun rootDeviceType(rootDeviceType: DeviceType): FluentBuilder
        /**
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         */
        fun sriovNetSupport(sriovNetSupport: String): FluentBuilder
        /**
         * The current state of the AMI. If the state is available, the image is successfully registered and can be used to launch an instance.
         */
        fun state(state: ImageState): FluentBuilder
        /**
         * The reason for the state change.
         */
        fun stateReason(stateReason: StateReason): FluentBuilder
        /**
         * Any tags assigned to the image.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
         * usageOperation corresponds to the <a href="https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation">lineitem/Operation column on your Amazon Web Services Cost and Usage Report and in the <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html">Amazon Web Services Price
         * List API. You can view these fields on the Instances or
         * AMIs pages in the Amazon EC2 console, or in the responses that are
         * returned by the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">DescribeImages
         * command in the Amazon EC2 API, or the <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html">describe-images
         * command in the CLI.
         */
        fun usageOperation(usageOperation: String): FluentBuilder
        /**
         * The type of virtualization of the AMI.
         */
        fun virtualizationType(virtualizationType: VirtualizationType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The architecture of the image.
         */
        var architecture: ArchitectureValues?
        /**
         * Any block device mapping entries.
         */
        var blockDeviceMappings: List<BlockDeviceMapping>?
        /**
         * The boot mode of the image. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var bootMode: BootModeValues?
        /**
         * The date and time the image was created.
         */
        var creationDate: String?
        /**
         * The date and time to deprecate the AMI, in UTC, in the following format:
         * YYYY-MM-DDTHH:MM:SSZ.
         * If you specified a value for seconds, Amazon EC2 rounds the seconds to the
         * nearest minute.
         */
        var deprecationTime: String?
        /**
         * The description of the AMI that was provided during image creation.
         */
        var description: String?
        /**
         * Specifies whether enhanced networking with ENA is enabled.
         */
        var enaSupport: Boolean?
        /**
         * The hypervisor type of the image.
         */
        var hypervisor: HypervisorType?
        /**
         * The ID of the AMI.
         */
        var imageId: String?
        /**
         * The location of the AMI.
         */
        var imageLocation: String?
        /**
         * The Amazon Web Services account alias (for example, amazon, self) or
         * the Amazon Web Services account ID of the AMI owner.
         */
        var imageOwnerAlias: String?
        /**
         * The type of image.
         */
        var imageType: ImageTypeValues?
        /**
         * The kernel associated with the image, if any. Only applicable for machine images.
         */
        var kernelId: String?
        /**
         * The name of the AMI that was provided during image creation.
         */
        var name: String?
        /**
         * The ID of the Amazon Web Services account that owns the image.
         */
        var ownerId: String?
        /**
         * This value is set to windows for Windows AMIs; otherwise, it is blank.
         */
        var platform: PlatformValues?
        /**
         * The platform details associated with the billing code of the AMI. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understanding
         * AMI billing in the Amazon Elastic Compute Cloud User Guide.
         */
        var platformDetails: String?
        /**
         * Any product codes associated with the AMI.
         */
        var productCodes: List<ProductCode>?
        /**
         * Indicates whether the image has public launch permissions. The value is true if
         * this image has public launch permissions or false
         * if it has only implicit and explicit launch permissions.
         */
        var public: Boolean?
        /**
         * The RAM disk associated with the image, if any. Only applicable for machine images.
         */
        var ramdiskId: String?
        /**
         * The device name of the root device volume (for example, /dev/sda1).
         */
        var rootDeviceName: String?
        /**
         * The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.
         */
        var rootDeviceType: DeviceType?
        /**
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         */
        var sriovNetSupport: String?
        /**
         * The current state of the AMI. If the state is available, the image is successfully registered and can be used to launch an instance.
         */
        var state: ImageState?
        /**
         * The reason for the state change.
         */
        var stateReason: StateReason?
        /**
         * Any tags assigned to the image.
         */
        var tags: List<Tag>?
        /**
         * The operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
         * usageOperation corresponds to the <a href="https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation">lineitem/Operation column on your Amazon Web Services Cost and Usage Report and in the <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html">Amazon Web Services Price
         * List API. You can view these fields on the Instances or
         * AMIs pages in the Amazon EC2 console, or in the responses that are
         * returned by the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">DescribeImages
         * command in the Amazon EC2 API, or the <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html">describe-images
         * command in the CLI.
         */
        var usageOperation: String?
        /**
         * The type of virtualization of the AMI.
         */
        var virtualizationType: VirtualizationType?

        fun build(): Image
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.StateReason] inside the given [block]
         */
        fun stateReason(block: StateReason.DslBuilder.() -> kotlin.Unit) {
            this.stateReason = StateReason.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var architecture: ArchitectureValues? = null
        override var blockDeviceMappings: List<BlockDeviceMapping>? = null
        override var bootMode: BootModeValues? = null
        override var creationDate: String? = null
        override var deprecationTime: String? = null
        override var description: String? = null
        override var enaSupport: Boolean? = null
        override var hypervisor: HypervisorType? = null
        override var imageId: String? = null
        override var imageLocation: String? = null
        override var imageOwnerAlias: String? = null
        override var imageType: ImageTypeValues? = null
        override var kernelId: String? = null
        override var name: String? = null
        override var ownerId: String? = null
        override var platform: PlatformValues? = null
        override var platformDetails: String? = null
        override var productCodes: List<ProductCode>? = null
        override var public: Boolean? = null
        override var ramdiskId: String? = null
        override var rootDeviceName: String? = null
        override var rootDeviceType: DeviceType? = null
        override var sriovNetSupport: String? = null
        override var state: ImageState? = null
        override var stateReason: StateReason? = null
        override var tags: List<Tag>? = null
        override var usageOperation: String? = null
        override var virtualizationType: VirtualizationType? = null

        constructor(x: Image) : this() {
            this.architecture = x.architecture
            this.blockDeviceMappings = x.blockDeviceMappings
            this.bootMode = x.bootMode
            this.creationDate = x.creationDate
            this.deprecationTime = x.deprecationTime
            this.description = x.description
            this.enaSupport = x.enaSupport
            this.hypervisor = x.hypervisor
            this.imageId = x.imageId
            this.imageLocation = x.imageLocation
            this.imageOwnerAlias = x.imageOwnerAlias
            this.imageType = x.imageType
            this.kernelId = x.kernelId
            this.name = x.name
            this.ownerId = x.ownerId
            this.platform = x.platform
            this.platformDetails = x.platformDetails
            this.productCodes = x.productCodes
            this.public = x.public
            this.ramdiskId = x.ramdiskId
            this.rootDeviceName = x.rootDeviceName
            this.rootDeviceType = x.rootDeviceType
            this.sriovNetSupport = x.sriovNetSupport
            this.state = x.state
            this.stateReason = x.stateReason
            this.tags = x.tags
            this.usageOperation = x.usageOperation
            this.virtualizationType = x.virtualizationType
        }

        override fun build(): Image = Image(this)
        override fun architecture(architecture: ArchitectureValues): FluentBuilder = apply { this.architecture = architecture }
        override fun blockDeviceMappings(blockDeviceMappings: List<BlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun bootMode(bootMode: BootModeValues): FluentBuilder = apply { this.bootMode = bootMode }
        override fun creationDate(creationDate: String): FluentBuilder = apply { this.creationDate = creationDate }
        override fun deprecationTime(deprecationTime: String): FluentBuilder = apply { this.deprecationTime = deprecationTime }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun enaSupport(enaSupport: Boolean): FluentBuilder = apply { this.enaSupport = enaSupport }
        override fun hypervisor(hypervisor: HypervisorType): FluentBuilder = apply { this.hypervisor = hypervisor }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun imageLocation(imageLocation: String): FluentBuilder = apply { this.imageLocation = imageLocation }
        override fun imageOwnerAlias(imageOwnerAlias: String): FluentBuilder = apply { this.imageOwnerAlias = imageOwnerAlias }
        override fun imageType(imageType: ImageTypeValues): FluentBuilder = apply { this.imageType = imageType }
        override fun kernelId(kernelId: String): FluentBuilder = apply { this.kernelId = kernelId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun platform(platform: PlatformValues): FluentBuilder = apply { this.platform = platform }
        override fun platformDetails(platformDetails: String): FluentBuilder = apply { this.platformDetails = platformDetails }
        override fun productCodes(productCodes: List<ProductCode>): FluentBuilder = apply { this.productCodes = productCodes }
        override fun public(public: Boolean): FluentBuilder = apply { this.public = public }
        override fun ramdiskId(ramdiskId: String): FluentBuilder = apply { this.ramdiskId = ramdiskId }
        override fun rootDeviceName(rootDeviceName: String): FluentBuilder = apply { this.rootDeviceName = rootDeviceName }
        override fun rootDeviceType(rootDeviceType: DeviceType): FluentBuilder = apply { this.rootDeviceType = rootDeviceType }
        override fun sriovNetSupport(sriovNetSupport: String): FluentBuilder = apply { this.sriovNetSupport = sriovNetSupport }
        override fun state(state: ImageState): FluentBuilder = apply { this.state = state }
        override fun stateReason(stateReason: StateReason): FluentBuilder = apply { this.stateReason = stateReason }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun usageOperation(usageOperation: String): FluentBuilder = apply { this.usageOperation = usageOperation }
        override fun virtualizationType(virtualizationType: VirtualizationType): FluentBuilder = apply { this.virtualizationType = virtualizationType }
    }
}
