// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the disk container object for an import image task.
 */
class ImageDiskContainer private constructor(builder: BuilderImpl) {
    /**
     * The description of the disk image.
     */
    val description: String? = builder.description
    /**
     * The block device mapping for the disk.
     */
    val deviceName: String? = builder.deviceName
    /**
     * The format of the disk image being imported.
     * Valid values: OVA | VHD | VHDX | VMDK | RAW
     */
    val format: String? = builder.format
    /**
     * The ID of the EBS snapshot to be used for importing the snapshot.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an
     * Amazon S3 URL (s3://..)
     */
    val url: String? = builder.url
    /**
     * The S3 bucket for the disk image.
     */
    val userBucket: UserBucket? = builder.userBucket

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImageDiskContainer = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImageDiskContainer(")
        append("description=$description,")
        append("deviceName=$deviceName,")
        append("format=$format,")
        append("snapshotId=$snapshotId,")
        append("url=$url,")
        append("userBucket=$userBucket)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (userBucket?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImageDiskContainer

        if (description != other.description) return false
        if (deviceName != other.deviceName) return false
        if (format != other.format) return false
        if (snapshotId != other.snapshotId) return false
        if (url != other.url) return false
        if (userBucket != other.userBucket) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImageDiskContainer = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImageDiskContainer
        /**
         * The description of the disk image.
         */
        fun description(description: String): FluentBuilder
        /**
         * The block device mapping for the disk.
         */
        fun deviceName(deviceName: String): FluentBuilder
        /**
         * The format of the disk image being imported.
         * Valid values: OVA | VHD | VHDX | VMDK | RAW
         */
        fun format(format: String): FluentBuilder
        /**
         * The ID of the EBS snapshot to be used for importing the snapshot.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an
         * Amazon S3 URL (s3://..)
         */
        fun url(url: String): FluentBuilder
        /**
         * The S3 bucket for the disk image.
         */
        fun userBucket(userBucket: UserBucket): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the disk image.
         */
        var description: String?
        /**
         * The block device mapping for the disk.
         */
        var deviceName: String?
        /**
         * The format of the disk image being imported.
         * Valid values: OVA | VHD | VHDX | VMDK | RAW
         */
        var format: String?
        /**
         * The ID of the EBS snapshot to be used for importing the snapshot.
         */
        var snapshotId: String?
        /**
         * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an
         * Amazon S3 URL (s3://..)
         */
        var url: String?
        /**
         * The S3 bucket for the disk image.
         */
        var userBucket: UserBucket?

        fun build(): ImageDiskContainer
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.UserBucket] inside the given [block]
         */
        fun userBucket(block: UserBucket.DslBuilder.() -> kotlin.Unit) {
            this.userBucket = UserBucket.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var deviceName: String? = null
        override var format: String? = null
        override var snapshotId: String? = null
        override var url: String? = null
        override var userBucket: UserBucket? = null

        constructor(x: ImageDiskContainer) : this() {
            this.description = x.description
            this.deviceName = x.deviceName
            this.format = x.format
            this.snapshotId = x.snapshotId
            this.url = x.url
            this.userBucket = x.userBucket
        }

        override fun build(): ImageDiskContainer = ImageDiskContainer(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun deviceName(deviceName: String): FluentBuilder = apply { this.deviceName = deviceName }
        override fun format(format: String): FluentBuilder = apply { this.format = format }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun url(url: String): FluentBuilder = apply { this.url = url }
        override fun userBucket(userBucket: UserBucket): FluentBuilder = apply { this.userBucket = userBucket }
    }
}
