// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ImportImageRequest private constructor(builder: BuilderImpl) {
    /**
     * The architecture of the virtual machine.
     * Valid values: i386 | x86_64 | arm64
     */
    val architecture: String? = builder.architecture
    /**
     * The boot mode of the virtual machine.
     */
    val bootMode: BootModeValues? = builder.bootMode
    /**
     * The client-specific data.
     */
    val clientData: ClientData? = builder.clientData
    /**
     * The token to enable idempotency for VM import requests.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A description string for the import image task.
     */
    val description: String? = builder.description
    /**
     * Information about the disk containers.
     */
    val diskContainers: List<ImageDiskContainer>? = builder.diskContainers
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS is used
     * unless you specify a non-default KMS key using KmsKeyId. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * The target hypervisor platform.
     * Valid values: xen
     */
    val hypervisor: String? = builder.hypervisor
    /**
     * An identifier for the symmetric KMS key to use when creating the
     * encrypted AMI. This parameter is only required if you want to use a non-default KMS key; if this
     * parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is
     * specified, the Encrypted flag must also be set.
     * The KMS key identifier may be provided in any of the following formats:
     * Key ID
     * Key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     * ARN using key ID. The ID ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the key namespace, and then the key ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
     * ARN using key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     * Amazon Web Services parses KmsKeyId asynchronously, meaning that the action you call may appear to complete even
     * though you provided an invalid identifier. This action will eventually report failure.
     * The specified KMS key must exist in the Region that the AMI is being copied to.
     * Amazon EBS does not support asymmetric KMS keys.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The ARNs of the license configurations.
     */
    val licenseSpecifications: List<ImportImageLicenseConfigurationRequest>? = builder.licenseSpecifications
    /**
     * The license type to be used for the Amazon Machine Image (AMI) after importing.
     * By default, we detect the source-system operating system (OS) and apply the appropriate license. Specify
     * AWS to replace the source-system license with an Amazon Web Services license, if appropriate. Specify BYOL
     * to retain the source-system license, if appropriate.
     * To use BYOL, you must have existing licenses with rights to use these licenses in a third party
     * cloud, such as Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image">Prerequisites in the
     * VM Import/Export User Guide.
     */
    val licenseType: String? = builder.licenseType
    /**
     * The operating system of the virtual machine.
     * Valid values: Windows | Linux
     */
    val platform: String? = builder.platform
    /**
     * The name of the role to use when not using the default role, 'vmimport'.
     */
    val roleName: String? = builder.roleName
    /**
     * The tags to apply to the import image task during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The usage operation value. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing options in the VM Import/Export User Guide.
     */
    val usageOperation: String? = builder.usageOperation

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportImageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportImageRequest(")
        append("architecture=$architecture,")
        append("bootMode=$bootMode,")
        append("clientData=$clientData,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("diskContainers=$diskContainers,")
        append("dryRun=$dryRun,")
        append("encrypted=$encrypted,")
        append("hypervisor=$hypervisor,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseSpecifications=$licenseSpecifications,")
        append("licenseType=$licenseType,")
        append("platform=$platform,")
        append("roleName=$roleName,")
        append("tagSpecifications=$tagSpecifications,")
        append("usageOperation=$usageOperation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (bootMode?.hashCode() ?: 0)
        result = 31 * result + (clientData?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (diskContainers?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (hypervisor?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseSpecifications?.hashCode() ?: 0)
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (usageOperation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportImageRequest

        if (architecture != other.architecture) return false
        if (bootMode != other.bootMode) return false
        if (clientData != other.clientData) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (diskContainers != other.diskContainers) return false
        if (dryRun != other.dryRun) return false
        if (encrypted != other.encrypted) return false
        if (hypervisor != other.hypervisor) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseSpecifications != other.licenseSpecifications) return false
        if (licenseType != other.licenseType) return false
        if (platform != other.platform) return false
        if (roleName != other.roleName) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (usageOperation != other.usageOperation) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportImageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportImageRequest
        /**
         * The architecture of the virtual machine.
         * Valid values: i386 | x86_64 | arm64
         */
        fun architecture(architecture: String): FluentBuilder
        /**
         * The boot mode of the virtual machine.
         */
        fun bootMode(bootMode: BootModeValues): FluentBuilder
        /**
         * The client-specific data.
         */
        fun clientData(clientData: ClientData): FluentBuilder
        /**
         * The token to enable idempotency for VM import requests.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A description string for the import image task.
         */
        fun description(description: String): FluentBuilder
        /**
         * Information about the disk containers.
         */
        fun diskContainers(diskContainers: List<ImageDiskContainer>): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS is used
         * unless you specify a non-default KMS key using KmsKeyId. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * The target hypervisor platform.
         * Valid values: xen
         */
        fun hypervisor(hypervisor: String): FluentBuilder
        /**
         * An identifier for the symmetric KMS key to use when creating the
         * encrypted AMI. This parameter is only required if you want to use a non-default KMS key; if this
         * parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is
         * specified, the Encrypted flag must also be set.
         * The KMS key identifier may be provided in any of the following formats:
         * Key ID
         * Key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * ARN using key ID. The ID ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the key namespace, and then the key ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
         * ARN using key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * Amazon Web Services parses KmsKeyId asynchronously, meaning that the action you call may appear to complete even
         * though you provided an invalid identifier. This action will eventually report failure.
         * The specified KMS key must exist in the Region that the AMI is being copied to.
         * Amazon EBS does not support asymmetric KMS keys.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The ARNs of the license configurations.
         */
        fun licenseSpecifications(licenseSpecifications: List<ImportImageLicenseConfigurationRequest>): FluentBuilder
        /**
         * The license type to be used for the Amazon Machine Image (AMI) after importing.
         * By default, we detect the source-system operating system (OS) and apply the appropriate license. Specify
         * AWS to replace the source-system license with an Amazon Web Services license, if appropriate. Specify BYOL
         * to retain the source-system license, if appropriate.
         * To use BYOL, you must have existing licenses with rights to use these licenses in a third party
         * cloud, such as Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image">Prerequisites in the
         * VM Import/Export User Guide.
         */
        fun licenseType(licenseType: String): FluentBuilder
        /**
         * The operating system of the virtual machine.
         * Valid values: Windows | Linux
         */
        fun platform(platform: String): FluentBuilder
        /**
         * The name of the role to use when not using the default role, 'vmimport'.
         */
        fun roleName(roleName: String): FluentBuilder
        /**
         * The tags to apply to the import image task during creation.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The usage operation value. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing options in the VM Import/Export User Guide.
         */
        fun usageOperation(usageOperation: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The architecture of the virtual machine.
         * Valid values: i386 | x86_64 | arm64
         */
        var architecture: String?
        /**
         * The boot mode of the virtual machine.
         */
        var bootMode: BootModeValues?
        /**
         * The client-specific data.
         */
        var clientData: ClientData?
        /**
         * The token to enable idempotency for VM import requests.
         */
        var clientToken: String?
        /**
         * A description string for the import image task.
         */
        var description: String?
        /**
         * Information about the disk containers.
         */
        var diskContainers: List<ImageDiskContainer>?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Specifies whether the destination AMI of the imported image should be encrypted. The default KMS key for EBS is used
         * unless you specify a non-default KMS key using KmsKeyId. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var encrypted: Boolean?
        /**
         * The target hypervisor platform.
         * Valid values: xen
         */
        var hypervisor: String?
        /**
         * An identifier for the symmetric KMS key to use when creating the
         * encrypted AMI. This parameter is only required if you want to use a non-default KMS key; if this
         * parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is
         * specified, the Encrypted flag must also be set.
         * The KMS key identifier may be provided in any of the following formats:
         * Key ID
         * Key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * ARN using key ID. The ID ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the key namespace, and then the key ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
         * ARN using key alias. The alias ARN contains the arn:aws:kms namespace, followed by the Region of the key, the Amazon Web Services account ID of the key owner, the alias namespace, and then the key alias. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * Amazon Web Services parses KmsKeyId asynchronously, meaning that the action you call may appear to complete even
         * though you provided an invalid identifier. This action will eventually report failure.
         * The specified KMS key must exist in the Region that the AMI is being copied to.
         * Amazon EBS does not support asymmetric KMS keys.
         */
        var kmsKeyId: String?
        /**
         * The ARNs of the license configurations.
         */
        var licenseSpecifications: List<ImportImageLicenseConfigurationRequest>?
        /**
         * The license type to be used for the Amazon Machine Image (AMI) after importing.
         * By default, we detect the source-system operating system (OS) and apply the appropriate license. Specify
         * AWS to replace the source-system license with an Amazon Web Services license, if appropriate. Specify BYOL
         * to retain the source-system license, if appropriate.
         * To use BYOL, you must have existing licenses with rights to use these licenses in a third party
         * cloud, such as Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image">Prerequisites in the
         * VM Import/Export User Guide.
         */
        var licenseType: String?
        /**
         * The operating system of the virtual machine.
         * Valid values: Windows | Linux
         */
        var platform: String?
        /**
         * The name of the role to use when not using the default role, 'vmimport'.
         */
        var roleName: String?
        /**
         * The tags to apply to the import image task during creation.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The usage operation value. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#prerequisites">Licensing options in the VM Import/Export User Guide.
         */
        var usageOperation: String?

        fun build(): ImportImageRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientData] inside the given [block]
         */
        fun clientData(block: ClientData.DslBuilder.() -> kotlin.Unit) {
            this.clientData = ClientData.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var architecture: String? = null
        override var bootMode: BootModeValues? = null
        override var clientData: ClientData? = null
        override var clientToken: String? = null
        override var description: String? = null
        override var diskContainers: List<ImageDiskContainer>? = null
        override var dryRun: Boolean? = null
        override var encrypted: Boolean? = null
        override var hypervisor: String? = null
        override var kmsKeyId: String? = null
        override var licenseSpecifications: List<ImportImageLicenseConfigurationRequest>? = null
        override var licenseType: String? = null
        override var platform: String? = null
        override var roleName: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var usageOperation: String? = null

        constructor(x: ImportImageRequest) : this() {
            this.architecture = x.architecture
            this.bootMode = x.bootMode
            this.clientData = x.clientData
            this.clientToken = x.clientToken
            this.description = x.description
            this.diskContainers = x.diskContainers
            this.dryRun = x.dryRun
            this.encrypted = x.encrypted
            this.hypervisor = x.hypervisor
            this.kmsKeyId = x.kmsKeyId
            this.licenseSpecifications = x.licenseSpecifications
            this.licenseType = x.licenseType
            this.platform = x.platform
            this.roleName = x.roleName
            this.tagSpecifications = x.tagSpecifications
            this.usageOperation = x.usageOperation
        }

        override fun build(): ImportImageRequest = ImportImageRequest(this)
        override fun architecture(architecture: String): FluentBuilder = apply { this.architecture = architecture }
        override fun bootMode(bootMode: BootModeValues): FluentBuilder = apply { this.bootMode = bootMode }
        override fun clientData(clientData: ClientData): FluentBuilder = apply { this.clientData = clientData }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun diskContainers(diskContainers: List<ImageDiskContainer>): FluentBuilder = apply { this.diskContainers = diskContainers }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun hypervisor(hypervisor: String): FluentBuilder = apply { this.hypervisor = hypervisor }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun licenseSpecifications(licenseSpecifications: List<ImportImageLicenseConfigurationRequest>): FluentBuilder = apply { this.licenseSpecifications = licenseSpecifications }
        override fun licenseType(licenseType: String): FluentBuilder = apply { this.licenseType = licenseType }
        override fun platform(platform: String): FluentBuilder = apply { this.platform = platform }
        override fun roleName(roleName: String): FluentBuilder = apply { this.roleName = roleName }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun usageOperation(usageOperation: String): FluentBuilder = apply { this.usageOperation = usageOperation }
    }
}
