// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the launch specification for VM import.
 */
class ImportInstanceLaunchSpecification private constructor(builder: BuilderImpl) {
    /**
     * Reserved.
     */
    val additionalInfo: String? = builder.additionalInfo
    /**
     * The architecture of the instance.
     */
    val architecture: ArchitectureValues? = builder.architecture
    /**
     * The security group IDs.
     */
    val groupIds: List<String>? = builder.groupIds
    /**
     * The security group names.
     */
    val groupNames: List<String>? = builder.groupNames
    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     */
    val instanceInitiatedShutdownBehavior: ShutdownBehavior? = builder.instanceInitiatedShutdownBehavior
    /**
     * The instance type. For more information about the instance types that you can import, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-instance-types">Instance Types in the
     * VM Import/Export User Guide.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * Indicates whether monitoring is enabled.
     */
    val monitoring: Boolean? = builder.monitoring
    /**
     * The placement information for the instance.
     */
    val placement: Placement? = builder.placement
    /**
     * &#91;EC2-VPC&#93; An available IP address from the IP address range of the subnet.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * &#91;EC2-VPC&#93; The ID of the subnet in which to launch the instance.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The Base64-encoded user data to make available to the instance.
     */
    val userData: UserData? = builder.userData

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportInstanceLaunchSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportInstanceLaunchSpecification(")
        append("additionalInfo=$additionalInfo,")
        append("architecture=$architecture,")
        append("groupIds=$groupIds,")
        append("groupNames=$groupNames,")
        append("instanceInitiatedShutdownBehavior=$instanceInitiatedShutdownBehavior,")
        append("instanceType=$instanceType,")
        append("monitoring=$monitoring,")
        append("placement=$placement,")
        append("privateIpAddress=$privateIpAddress,")
        append("subnetId=$subnetId,")
        append("userData=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (groupIds?.hashCode() ?: 0)
        result = 31 * result + (groupNames?.hashCode() ?: 0)
        result = 31 * result + (instanceInitiatedShutdownBehavior?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportInstanceLaunchSpecification

        if (additionalInfo != other.additionalInfo) return false
        if (architecture != other.architecture) return false
        if (groupIds != other.groupIds) return false
        if (groupNames != other.groupNames) return false
        if (instanceInitiatedShutdownBehavior != other.instanceInitiatedShutdownBehavior) return false
        if (instanceType != other.instanceType) return false
        if (monitoring != other.monitoring) return false
        if (placement != other.placement) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (subnetId != other.subnetId) return false
        if (userData != other.userData) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportInstanceLaunchSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportInstanceLaunchSpecification
        /**
         * Reserved.
         */
        fun additionalInfo(additionalInfo: String): FluentBuilder
        /**
         * The architecture of the instance.
         */
        fun architecture(architecture: ArchitectureValues): FluentBuilder
        /**
         * The security group IDs.
         */
        fun groupIds(groupIds: List<String>): FluentBuilder
        /**
         * The security group names.
         */
        fun groupNames(groupNames: List<String>): FluentBuilder
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         */
        fun instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior: ShutdownBehavior): FluentBuilder
        /**
         * The instance type. For more information about the instance types that you can import, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-instance-types">Instance Types in the
         * VM Import/Export User Guide.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * Indicates whether monitoring is enabled.
         */
        fun monitoring(monitoring: Boolean): FluentBuilder
        /**
         * The placement information for the instance.
         */
        fun placement(placement: Placement): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; An available IP address from the IP address range of the subnet.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; The ID of the subnet in which to launch the instance.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The Base64-encoded user data to make available to the instance.
         */
        fun userData(userData: UserData): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Reserved.
         */
        var additionalInfo: String?
        /**
         * The architecture of the instance.
         */
        var architecture: ArchitectureValues?
        /**
         * The security group IDs.
         */
        var groupIds: List<String>?
        /**
         * The security group names.
         */
        var groupNames: List<String>?
        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         */
        var instanceInitiatedShutdownBehavior: ShutdownBehavior?
        /**
         * The instance type. For more information about the instance types that you can import, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-instance-types">Instance Types in the
         * VM Import/Export User Guide.
         */
        var instanceType: InstanceType?
        /**
         * Indicates whether monitoring is enabled.
         */
        var monitoring: Boolean?
        /**
         * The placement information for the instance.
         */
        var placement: Placement?
        /**
         * &#91;EC2-VPC&#93; An available IP address from the IP address range of the subnet.
         */
        var privateIpAddress: String?
        /**
         * &#91;EC2-VPC&#93; The ID of the subnet in which to launch the instance.
         */
        var subnetId: String?
        /**
         * The Base64-encoded user data to make available to the instance.
         */
        var userData: UserData?

        fun build(): ImportInstanceLaunchSpecification
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Placement] inside the given [block]
         */
        fun placement(block: Placement.DslBuilder.() -> kotlin.Unit) {
            this.placement = Placement.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.UserData] inside the given [block]
         */
        fun userData(block: UserData.DslBuilder.() -> kotlin.Unit) {
            this.userData = UserData.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalInfo: String? = null
        override var architecture: ArchitectureValues? = null
        override var groupIds: List<String>? = null
        override var groupNames: List<String>? = null
        override var instanceInitiatedShutdownBehavior: ShutdownBehavior? = null
        override var instanceType: InstanceType? = null
        override var monitoring: Boolean? = null
        override var placement: Placement? = null
        override var privateIpAddress: String? = null
        override var subnetId: String? = null
        override var userData: UserData? = null

        constructor(x: ImportInstanceLaunchSpecification) : this() {
            this.additionalInfo = x.additionalInfo
            this.architecture = x.architecture
            this.groupIds = x.groupIds
            this.groupNames = x.groupNames
            this.instanceInitiatedShutdownBehavior = x.instanceInitiatedShutdownBehavior
            this.instanceType = x.instanceType
            this.monitoring = x.monitoring
            this.placement = x.placement
            this.privateIpAddress = x.privateIpAddress
            this.subnetId = x.subnetId
            this.userData = x.userData
        }

        override fun build(): ImportInstanceLaunchSpecification = ImportInstanceLaunchSpecification(this)
        override fun additionalInfo(additionalInfo: String): FluentBuilder = apply { this.additionalInfo = additionalInfo }
        override fun architecture(architecture: ArchitectureValues): FluentBuilder = apply { this.architecture = architecture }
        override fun groupIds(groupIds: List<String>): FluentBuilder = apply { this.groupIds = groupIds }
        override fun groupNames(groupNames: List<String>): FluentBuilder = apply { this.groupNames = groupNames }
        override fun instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior: ShutdownBehavior): FluentBuilder = apply { this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun monitoring(monitoring: Boolean): FluentBuilder = apply { this.monitoring = monitoring }
        override fun placement(placement: Placement): FluentBuilder = apply { this.placement = placement }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun userData(userData: UserData): FluentBuilder = apply { this.userData = userData }
    }
}
