// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ImportKeyPairRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * A unique name for the key pair.
     */
    val keyName: String? = builder.keyName
    /**
     * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.
     */
    val publicKeyMaterial: ByteArray? = builder.publicKeyMaterial
    /**
     * The tags to apply to the imported key pair.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportKeyPairRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportKeyPairRequest(")
        append("dryRun=$dryRun,")
        append("keyName=$keyName,")
        append("publicKeyMaterial=$publicKeyMaterial,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (publicKeyMaterial?.contentHashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportKeyPairRequest

        if (dryRun != other.dryRun) return false
        if (keyName != other.keyName) return false
        if (publicKeyMaterial != null) {
            if (other.publicKeyMaterial == null) return false
            if (!publicKeyMaterial.contentEquals(other.publicKeyMaterial)) return false
        } else if (other.publicKeyMaterial != null) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportKeyPairRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportKeyPairRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * A unique name for the key pair.
         */
        fun keyName(keyName: String): FluentBuilder
        /**
         * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.
         */
        fun publicKeyMaterial(publicKeyMaterial: ByteArray): FluentBuilder
        /**
         * The tags to apply to the imported key pair.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * A unique name for the key pair.
         */
        var keyName: String?
        /**
         * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.
         */
        var publicKeyMaterial: ByteArray?
        /**
         * The tags to apply to the imported key pair.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): ImportKeyPairRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var keyName: String? = null
        override var publicKeyMaterial: ByteArray? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: ImportKeyPairRequest) : this() {
            this.dryRun = x.dryRun
            this.keyName = x.keyName
            this.publicKeyMaterial = x.publicKeyMaterial
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): ImportKeyPairRequest = ImportKeyPairRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun keyName(keyName: String): FluentBuilder = apply { this.keyName = keyName }
        override fun publicKeyMaterial(publicKeyMaterial: ByteArray): FluentBuilder = apply { this.publicKeyMaterial = publicKeyMaterial }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
