// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an instance.
 */
class Instance private constructor(builder: BuilderImpl) {
    /**
     * The AMI launch index, which can be used to find this instance in the launch
     * group.
     */
    val amiLaunchIndex: Int? = builder.amiLaunchIndex
    /**
     * The architecture of the image.
     */
    val architecture: ArchitectureValues? = builder.architecture
    /**
     * Any block device mapping entries for the instance.
     */
    val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The boot mode of the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
     * Amazon EC2 User Guide.
     */
    val bootMode: BootModeValues? = builder.bootMode
    /**
     * The ID of the Capacity Reservation.
     */
    val capacityReservationId: String? = builder.capacityReservationId
    /**
     * Information about the Capacity Reservation targeting option.
     */
    val capacityReservationSpecification: CapacityReservationSpecificationResponse? = builder.capacityReservationSpecification
    /**
     * The idempotency token you provided when you launched the instance, if
     * applicable.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The CPU options for the instance.
     */
    val cpuOptions: CpuOptions? = builder.cpuOptions
    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
     * provides dedicated throughput to Amazon EBS and an optimized configuration stack to
     * provide optimal I/O performance. This optimization isn't available with all instance
     * types. Additional usage charges apply when using an EBS Optimized instance.
     */
    val ebsOptimized: Boolean? = builder.ebsOptimized
    /**
     * The Elastic GPU associated with the instance.
     */
    val elasticGpuAssociations: List<ElasticGpuAssociation>? = builder.elasticGpuAssociations
    /**
     * The elastic inference accelerator associated with the instance.
     */
    val elasticInferenceAcceleratorAssociations: List<ElasticInferenceAcceleratorAssociation>? = builder.elasticInferenceAcceleratorAssociations
    /**
     * Specifies whether enhanced networking with ENA is enabled.
     */
    val enaSupport: Boolean? = builder.enaSupport
    /**
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
     */
    val enclaveOptions: EnclaveOptions? = builder.enclaveOptions
    /**
     * Indicates whether the instance is enabled for hibernation.
     */
    val hibernationOptions: HibernationOptions? = builder.hibernationOptions
    /**
     * The hypervisor type of the instance. The value xen is used for both Xen and
     * Nitro hypervisors.
     */
    val hypervisor: HypervisorType? = builder.hypervisor
    /**
     * The IAM instance profile associated with the instance, if applicable.
     */
    val iamInstanceProfile: IamInstanceProfile? = builder.iamInstanceProfile
    /**
     * The ID of the AMI used to launch the instance.
     */
    val imageId: String? = builder.imageId
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     */
    val instanceLifecycle: InstanceLifecycleType? = builder.instanceLifecycle
    /**
     * The instance type.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * The kernel associated with this instance, if applicable.
     */
    val kernelId: String? = builder.kernelId
    /**
     * The name of the key pair, if this instance was launched with an associated key
     * pair.
     */
    val keyName: String? = builder.keyName
    /**
     * The time the instance was launched.
     */
    val launchTime: Instant? = builder.launchTime
    /**
     * The license configurations for the instance.
     */
    val licenses: List<LicenseConfiguration>? = builder.licenses
    /**
     * The metadata options for the instance.
     */
    val metadataOptions: InstanceMetadataOptionsResponse? = builder.metadataOptions
    /**
     * The monitoring for the instance.
     */
    val monitoring: Monitoring? = builder.monitoring
    /**
     * &#91;EC2-VPC&#93; The network interfaces for the instance.
     */
    val networkInterfaces: List<InstanceNetworkInterface>? = builder.networkInterfaces
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The location where the instance launched, if applicable.
     */
    val placement: Placement? = builder.placement
    /**
     * The value is Windows for Windows instances; otherwise blank.
     */
    val platform: PlatformValues? = builder.platform
    /**
     * The platform details value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI
     * billing information fields in the
     * Amazon EC2 User Guide.
     */
    val platformDetails: String? = builder.platformDetails
    /**
     * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname
     * can only be used inside the Amazon EC2 network. This name is not available until the
     * instance enters the running state.
     * &#91;EC2-VPC&#93; The Amazon-provided DNS server resolves Amazon-provided private DNS
     * hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not
     * using the Amazon-provided DNS server in your VPC, your custom domain name servers must
     * resolve the hostname as appropriate.
     */
    val privateDnsName: String? = builder.privateDnsName
    /**
     * The private IPv4 address assigned to the instance.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * The product codes attached to this instance, if applicable.
     */
    val productCodes: List<ProductCode>? = builder.productCodes
    /**
     * (IPv4 only) The public DNS name assigned to the instance. This name is not available
     * until the instance enters the running state. For EC2-VPC, this name is only
     * available if you've enabled DNS hostnames for your VPC.
     */
    val publicDnsName: String? = builder.publicDnsName
    /**
     * The public IPv4 address, or the Carrier IP address assigned to the instance, if
     * applicable.
     * A Carrier IP address only applies to an instance launched in a subnet associated with
     * a Wavelength Zone.
     */
    val publicIpAddress: String? = builder.publicIpAddress
    /**
     * The RAM disk associated with this instance, if applicable.
     */
    val ramdiskId: String? = builder.ramdiskId
    /**
     * The device name of the root device volume (for example,
     * /dev/sda1).
     */
    val rootDeviceName: String? = builder.rootDeviceName
    /**
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance
     * store volume.
     */
    val rootDeviceType: DeviceType? = builder.rootDeviceType
    /**
     * The security groups for the instance.
     */
    val securityGroups: List<GroupIdentifier>? = builder.securityGroups
    /**
     * Indicates whether source/destination checking is enabled.
     */
    val sourceDestCheck: Boolean? = builder.sourceDestCheck
    /**
     * If the request is a Spot Instance request, the ID of the request.
     */
    val spotInstanceRequestId: String? = builder.spotInstanceRequestId
    /**
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface
     * is enabled.
     */
    val sriovNetSupport: String? = builder.sriovNetSupport
    /**
     * The current state of the instance.
     */
    val state: InstanceState? = builder.state
    /**
     * The reason for the most recent state transition.
     */
    val stateReason: StateReason? = builder.stateReason
    /**
     * The reason for the most recent state transition. This might be an empty string.
     */
    val stateTransitionReason: String? = builder.stateTransitionReason
    /**
     * &#91;EC2-VPC&#93; The ID of the subnet in which the instance is running.
     */
    val subnetId: String? = builder.subnetId
    /**
     * Any tags assigned to the instance.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The usage operation value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields
     * in the Amazon EC2 User Guide.
     */
    val usageOperation: String? = builder.usageOperation
    /**
     * The time that the usage operation was last updated.
     */
    val usageOperationUpdateTime: Instant? = builder.usageOperationUpdateTime
    /**
     * The virtualization type of the instance.
     */
    val virtualizationType: VirtualizationType? = builder.virtualizationType
    /**
     * &#91;EC2-VPC&#93; The ID of the VPC in which the instance is running.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Instance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("amiLaunchIndex=$amiLaunchIndex,")
        append("architecture=$architecture,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("bootMode=$bootMode,")
        append("capacityReservationId=$capacityReservationId,")
        append("capacityReservationSpecification=$capacityReservationSpecification,")
        append("clientToken=$clientToken,")
        append("cpuOptions=$cpuOptions,")
        append("ebsOptimized=$ebsOptimized,")
        append("elasticGpuAssociations=$elasticGpuAssociations,")
        append("elasticInferenceAcceleratorAssociations=$elasticInferenceAcceleratorAssociations,")
        append("enaSupport=$enaSupport,")
        append("enclaveOptions=$enclaveOptions,")
        append("hibernationOptions=$hibernationOptions,")
        append("hypervisor=$hypervisor,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceId=$instanceId,")
        append("instanceLifecycle=$instanceLifecycle,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("launchTime=$launchTime,")
        append("licenses=$licenses,")
        append("metadataOptions=$metadataOptions,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("outpostArn=$outpostArn,")
        append("placement=$placement,")
        append("platform=$platform,")
        append("platformDetails=$platformDetails,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress,")
        append("productCodes=$productCodes,")
        append("publicDnsName=$publicDnsName,")
        append("publicIpAddress=$publicIpAddress,")
        append("ramdiskId=$ramdiskId,")
        append("rootDeviceName=$rootDeviceName,")
        append("rootDeviceType=$rootDeviceType,")
        append("securityGroups=$securityGroups,")
        append("sourceDestCheck=$sourceDestCheck,")
        append("spotInstanceRequestId=$spotInstanceRequestId,")
        append("sriovNetSupport=$sriovNetSupport,")
        append("state=$state,")
        append("stateReason=$stateReason,")
        append("stateTransitionReason=$stateTransitionReason,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("usageOperation=$usageOperation,")
        append("usageOperationUpdateTime=$usageOperationUpdateTime,")
        append("virtualizationType=$virtualizationType,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiLaunchIndex ?: 0
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (bootMode?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationId?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationSpecification?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (cpuOptions?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuAssociations?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAcceleratorAssociations?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (enclaveOptions?.hashCode() ?: 0)
        result = 31 * result + (hibernationOptions?.hashCode() ?: 0)
        result = 31 * result + (hypervisor?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceLifecycle?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (launchTime?.hashCode() ?: 0)
        result = 31 * result + (licenses?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (platformDetails?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (productCodes?.hashCode() ?: 0)
        result = 31 * result + (publicDnsName?.hashCode() ?: 0)
        result = 31 * result + (publicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceName?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceType?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sourceDestCheck?.hashCode() ?: 0)
        result = 31 * result + (spotInstanceRequestId?.hashCode() ?: 0)
        result = 31 * result + (sriovNetSupport?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (stateTransitionReason?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usageOperation?.hashCode() ?: 0)
        result = 31 * result + (usageOperationUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (virtualizationType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Instance

        if (amiLaunchIndex != other.amiLaunchIndex) return false
        if (architecture != other.architecture) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (bootMode != other.bootMode) return false
        if (capacityReservationId != other.capacityReservationId) return false
        if (capacityReservationSpecification != other.capacityReservationSpecification) return false
        if (clientToken != other.clientToken) return false
        if (cpuOptions != other.cpuOptions) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (elasticGpuAssociations != other.elasticGpuAssociations) return false
        if (elasticInferenceAcceleratorAssociations != other.elasticInferenceAcceleratorAssociations) return false
        if (enaSupport != other.enaSupport) return false
        if (enclaveOptions != other.enclaveOptions) return false
        if (hibernationOptions != other.hibernationOptions) return false
        if (hypervisor != other.hypervisor) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceId != other.instanceId) return false
        if (instanceLifecycle != other.instanceLifecycle) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (launchTime != other.launchTime) return false
        if (licenses != other.licenses) return false
        if (metadataOptions != other.metadataOptions) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (outpostArn != other.outpostArn) return false
        if (placement != other.placement) return false
        if (platform != other.platform) return false
        if (platformDetails != other.platformDetails) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (productCodes != other.productCodes) return false
        if (publicDnsName != other.publicDnsName) return false
        if (publicIpAddress != other.publicIpAddress) return false
        if (ramdiskId != other.ramdiskId) return false
        if (rootDeviceName != other.rootDeviceName) return false
        if (rootDeviceType != other.rootDeviceType) return false
        if (securityGroups != other.securityGroups) return false
        if (sourceDestCheck != other.sourceDestCheck) return false
        if (spotInstanceRequestId != other.spotInstanceRequestId) return false
        if (sriovNetSupport != other.sriovNetSupport) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false
        if (stateTransitionReason != other.stateTransitionReason) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (usageOperation != other.usageOperation) return false
        if (usageOperationUpdateTime != other.usageOperationUpdateTime) return false
        if (virtualizationType != other.virtualizationType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Instance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Instance
        /**
         * The AMI launch index, which can be used to find this instance in the launch
         * group.
         */
        fun amiLaunchIndex(amiLaunchIndex: Int): FluentBuilder
        /**
         * The architecture of the image.
         */
        fun architecture(architecture: ArchitectureValues): FluentBuilder
        /**
         * Any block device mapping entries for the instance.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder
        /**
         * The boot mode of the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
         * Amazon EC2 User Guide.
         */
        fun bootMode(bootMode: BootModeValues): FluentBuilder
        /**
         * The ID of the Capacity Reservation.
         */
        fun capacityReservationId(capacityReservationId: String): FluentBuilder
        /**
         * Information about the Capacity Reservation targeting option.
         */
        fun capacityReservationSpecification(capacityReservationSpecification: CapacityReservationSpecificationResponse): FluentBuilder
        /**
         * The idempotency token you provided when you launched the instance, if
         * applicable.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The CPU options for the instance.
         */
        fun cpuOptions(cpuOptions: CpuOptions): FluentBuilder
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
         * provides dedicated throughput to Amazon EBS and an optimized configuration stack to
         * provide optimal I/O performance. This optimization isn't available with all instance
         * types. Additional usage charges apply when using an EBS Optimized instance.
         */
        fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder
        /**
         * The Elastic GPU associated with the instance.
         */
        fun elasticGpuAssociations(elasticGpuAssociations: List<ElasticGpuAssociation>): FluentBuilder
        /**
         * The elastic inference accelerator associated with the instance.
         */
        fun elasticInferenceAcceleratorAssociations(elasticInferenceAcceleratorAssociations: List<ElasticInferenceAcceleratorAssociation>): FluentBuilder
        /**
         * Specifies whether enhanced networking with ENA is enabled.
         */
        fun enaSupport(enaSupport: Boolean): FluentBuilder
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         */
        fun enclaveOptions(enclaveOptions: EnclaveOptions): FluentBuilder
        /**
         * Indicates whether the instance is enabled for hibernation.
         */
        fun hibernationOptions(hibernationOptions: HibernationOptions): FluentBuilder
        /**
         * The hypervisor type of the instance. The value xen is used for both Xen and
         * Nitro hypervisors.
         */
        fun hypervisor(hypervisor: HypervisorType): FluentBuilder
        /**
         * The IAM instance profile associated with the instance, if applicable.
         */
        fun iamInstanceProfile(iamInstanceProfile: IamInstanceProfile): FluentBuilder
        /**
         * The ID of the AMI used to launch the instance.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         */
        fun instanceLifecycle(instanceLifecycle: InstanceLifecycleType): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * The kernel associated with this instance, if applicable.
         */
        fun kernelId(kernelId: String): FluentBuilder
        /**
         * The name of the key pair, if this instance was launched with an associated key
         * pair.
         */
        fun keyName(keyName: String): FluentBuilder
        /**
         * The time the instance was launched.
         */
        fun launchTime(launchTime: Instant): FluentBuilder
        /**
         * The license configurations for the instance.
         */
        fun licenses(licenses: List<LicenseConfiguration>): FluentBuilder
        /**
         * The metadata options for the instance.
         */
        fun metadataOptions(metadataOptions: InstanceMetadataOptionsResponse): FluentBuilder
        /**
         * The monitoring for the instance.
         */
        fun monitoring(monitoring: Monitoring): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; The network interfaces for the instance.
         */
        fun networkInterfaces(networkInterfaces: List<InstanceNetworkInterface>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The location where the instance launched, if applicable.
         */
        fun placement(placement: Placement): FluentBuilder
        /**
         * The value is Windows for Windows instances; otherwise blank.
         */
        fun platform(platform: PlatformValues): FluentBuilder
        /**
         * The platform details value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI
         * billing information fields in the
         * Amazon EC2 User Guide.
         */
        fun platformDetails(platformDetails: String): FluentBuilder
        /**
         * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname
         * can only be used inside the Amazon EC2 network. This name is not available until the
         * instance enters the running state.
         * &#91;EC2-VPC&#93; The Amazon-provided DNS server resolves Amazon-provided private DNS
         * hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not
         * using the Amazon-provided DNS server in your VPC, your custom domain name servers must
         * resolve the hostname as appropriate.
         */
        fun privateDnsName(privateDnsName: String): FluentBuilder
        /**
         * The private IPv4 address assigned to the instance.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * The product codes attached to this instance, if applicable.
         */
        fun productCodes(productCodes: List<ProductCode>): FluentBuilder
        /**
         * (IPv4 only) The public DNS name assigned to the instance. This name is not available
         * until the instance enters the running state. For EC2-VPC, this name is only
         * available if you've enabled DNS hostnames for your VPC.
         */
        fun publicDnsName(publicDnsName: String): FluentBuilder
        /**
         * The public IPv4 address, or the Carrier IP address assigned to the instance, if
         * applicable.
         * A Carrier IP address only applies to an instance launched in a subnet associated with
         * a Wavelength Zone.
         */
        fun publicIpAddress(publicIpAddress: String): FluentBuilder
        /**
         * The RAM disk associated with this instance, if applicable.
         */
        fun ramdiskId(ramdiskId: String): FluentBuilder
        /**
         * The device name of the root device volume (for example,
         * /dev/sda1).
         */
        fun rootDeviceName(rootDeviceName: String): FluentBuilder
        /**
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance
         * store volume.
         */
        fun rootDeviceType(rootDeviceType: DeviceType): FluentBuilder
        /**
         * The security groups for the instance.
         */
        fun securityGroups(securityGroups: List<GroupIdentifier>): FluentBuilder
        /**
         * Indicates whether source/destination checking is enabled.
         */
        fun sourceDestCheck(sourceDestCheck: Boolean): FluentBuilder
        /**
         * If the request is a Spot Instance request, the ID of the request.
         */
        fun spotInstanceRequestId(spotInstanceRequestId: String): FluentBuilder
        /**
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface
         * is enabled.
         */
        fun sriovNetSupport(sriovNetSupport: String): FluentBuilder
        /**
         * The current state of the instance.
         */
        fun state(state: InstanceState): FluentBuilder
        /**
         * The reason for the most recent state transition.
         */
        fun stateReason(stateReason: StateReason): FluentBuilder
        /**
         * The reason for the most recent state transition. This might be an empty string.
         */
        fun stateTransitionReason(stateTransitionReason: String): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; The ID of the subnet in which the instance is running.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * Any tags assigned to the instance.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The usage operation value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields
         * in the Amazon EC2 User Guide.
         */
        fun usageOperation(usageOperation: String): FluentBuilder
        /**
         * The time that the usage operation was last updated.
         */
        fun usageOperationUpdateTime(usageOperationUpdateTime: Instant): FluentBuilder
        /**
         * The virtualization type of the instance.
         */
        fun virtualizationType(virtualizationType: VirtualizationType): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; The ID of the VPC in which the instance is running.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The AMI launch index, which can be used to find this instance in the launch
         * group.
         */
        var amiLaunchIndex: Int?
        /**
         * The architecture of the image.
         */
        var architecture: ArchitectureValues?
        /**
         * Any block device mapping entries for the instance.
         */
        var blockDeviceMappings: List<InstanceBlockDeviceMapping>?
        /**
         * The boot mode of the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
         * Amazon EC2 User Guide.
         */
        var bootMode: BootModeValues?
        /**
         * The ID of the Capacity Reservation.
         */
        var capacityReservationId: String?
        /**
         * Information about the Capacity Reservation targeting option.
         */
        var capacityReservationSpecification: CapacityReservationSpecificationResponse?
        /**
         * The idempotency token you provided when you launched the instance, if
         * applicable.
         */
        var clientToken: String?
        /**
         * The CPU options for the instance.
         */
        var cpuOptions: CpuOptions?
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
         * provides dedicated throughput to Amazon EBS and an optimized configuration stack to
         * provide optimal I/O performance. This optimization isn't available with all instance
         * types. Additional usage charges apply when using an EBS Optimized instance.
         */
        var ebsOptimized: Boolean?
        /**
         * The Elastic GPU associated with the instance.
         */
        var elasticGpuAssociations: List<ElasticGpuAssociation>?
        /**
         * The elastic inference accelerator associated with the instance.
         */
        var elasticInferenceAcceleratorAssociations: List<ElasticInferenceAcceleratorAssociation>?
        /**
         * Specifies whether enhanced networking with ENA is enabled.
         */
        var enaSupport: Boolean?
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         */
        var enclaveOptions: EnclaveOptions?
        /**
         * Indicates whether the instance is enabled for hibernation.
         */
        var hibernationOptions: HibernationOptions?
        /**
         * The hypervisor type of the instance. The value xen is used for both Xen and
         * Nitro hypervisors.
         */
        var hypervisor: HypervisorType?
        /**
         * The IAM instance profile associated with the instance, if applicable.
         */
        var iamInstanceProfile: IamInstanceProfile?
        /**
         * The ID of the AMI used to launch the instance.
         */
        var imageId: String?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         */
        var instanceLifecycle: InstanceLifecycleType?
        /**
         * The instance type.
         */
        var instanceType: InstanceType?
        /**
         * The kernel associated with this instance, if applicable.
         */
        var kernelId: String?
        /**
         * The name of the key pair, if this instance was launched with an associated key
         * pair.
         */
        var keyName: String?
        /**
         * The time the instance was launched.
         */
        var launchTime: Instant?
        /**
         * The license configurations for the instance.
         */
        var licenses: List<LicenseConfiguration>?
        /**
         * The metadata options for the instance.
         */
        var metadataOptions: InstanceMetadataOptionsResponse?
        /**
         * The monitoring for the instance.
         */
        var monitoring: Monitoring?
        /**
         * &#91;EC2-VPC&#93; The network interfaces for the instance.
         */
        var networkInterfaces: List<InstanceNetworkInterface>?
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        var outpostArn: String?
        /**
         * The location where the instance launched, if applicable.
         */
        var placement: Placement?
        /**
         * The value is Windows for Windows instances; otherwise blank.
         */
        var platform: PlatformValues?
        /**
         * The platform details value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI
         * billing information fields in the
         * Amazon EC2 User Guide.
         */
        var platformDetails: String?
        /**
         * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname
         * can only be used inside the Amazon EC2 network. This name is not available until the
         * instance enters the running state.
         * &#91;EC2-VPC&#93; The Amazon-provided DNS server resolves Amazon-provided private DNS
         * hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not
         * using the Amazon-provided DNS server in your VPC, your custom domain name servers must
         * resolve the hostname as appropriate.
         */
        var privateDnsName: String?
        /**
         * The private IPv4 address assigned to the instance.
         */
        var privateIpAddress: String?
        /**
         * The product codes attached to this instance, if applicable.
         */
        var productCodes: List<ProductCode>?
        /**
         * (IPv4 only) The public DNS name assigned to the instance. This name is not available
         * until the instance enters the running state. For EC2-VPC, this name is only
         * available if you've enabled DNS hostnames for your VPC.
         */
        var publicDnsName: String?
        /**
         * The public IPv4 address, or the Carrier IP address assigned to the instance, if
         * applicable.
         * A Carrier IP address only applies to an instance launched in a subnet associated with
         * a Wavelength Zone.
         */
        var publicIpAddress: String?
        /**
         * The RAM disk associated with this instance, if applicable.
         */
        var ramdiskId: String?
        /**
         * The device name of the root device volume (for example,
         * /dev/sda1).
         */
        var rootDeviceName: String?
        /**
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance
         * store volume.
         */
        var rootDeviceType: DeviceType?
        /**
         * The security groups for the instance.
         */
        var securityGroups: List<GroupIdentifier>?
        /**
         * Indicates whether source/destination checking is enabled.
         */
        var sourceDestCheck: Boolean?
        /**
         * If the request is a Spot Instance request, the ID of the request.
         */
        var spotInstanceRequestId: String?
        /**
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface
         * is enabled.
         */
        var sriovNetSupport: String?
        /**
         * The current state of the instance.
         */
        var state: InstanceState?
        /**
         * The reason for the most recent state transition.
         */
        var stateReason: StateReason?
        /**
         * The reason for the most recent state transition. This might be an empty string.
         */
        var stateTransitionReason: String?
        /**
         * &#91;EC2-VPC&#93; The ID of the subnet in which the instance is running.
         */
        var subnetId: String?
        /**
         * Any tags assigned to the instance.
         */
        var tags: List<Tag>?
        /**
         * The usage operation value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields
         * in the Amazon EC2 User Guide.
         */
        var usageOperation: String?
        /**
         * The time that the usage operation was last updated.
         */
        var usageOperationUpdateTime: Instant?
        /**
         * The virtualization type of the instance.
         */
        var virtualizationType: VirtualizationType?
        /**
         * &#91;EC2-VPC&#93; The ID of the VPC in which the instance is running.
         */
        var vpcId: String?

        fun build(): Instance
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse] inside the given [block]
         */
        fun capacityReservationSpecification(block: CapacityReservationSpecificationResponse.DslBuilder.() -> kotlin.Unit) {
            this.capacityReservationSpecification = CapacityReservationSpecificationResponse.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CpuOptions] inside the given [block]
         */
        fun cpuOptions(block: CpuOptions.DslBuilder.() -> kotlin.Unit) {
            this.cpuOptions = CpuOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EnclaveOptions] inside the given [block]
         */
        fun enclaveOptions(block: EnclaveOptions.DslBuilder.() -> kotlin.Unit) {
            this.enclaveOptions = EnclaveOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.HibernationOptions] inside the given [block]
         */
        fun hibernationOptions(block: HibernationOptions.DslBuilder.() -> kotlin.Unit) {
            this.hibernationOptions = HibernationOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IamInstanceProfile] inside the given [block]
         */
        fun iamInstanceProfile(block: IamInstanceProfile.DslBuilder.() -> kotlin.Unit) {
            this.iamInstanceProfile = IamInstanceProfile.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsResponse] inside the given [block]
         */
        fun metadataOptions(block: InstanceMetadataOptionsResponse.DslBuilder.() -> kotlin.Unit) {
            this.metadataOptions = InstanceMetadataOptionsResponse.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Monitoring] inside the given [block]
         */
        fun monitoring(block: Monitoring.DslBuilder.() -> kotlin.Unit) {
            this.monitoring = Monitoring.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Placement] inside the given [block]
         */
        fun placement(block: Placement.DslBuilder.() -> kotlin.Unit) {
            this.placement = Placement.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceState] inside the given [block]
         */
        fun state(block: InstanceState.DslBuilder.() -> kotlin.Unit) {
            this.state = InstanceState.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.StateReason] inside the given [block]
         */
        fun stateReason(block: StateReason.DslBuilder.() -> kotlin.Unit) {
            this.stateReason = StateReason.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amiLaunchIndex: Int? = null
        override var architecture: ArchitectureValues? = null
        override var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        override var bootMode: BootModeValues? = null
        override var capacityReservationId: String? = null
        override var capacityReservationSpecification: CapacityReservationSpecificationResponse? = null
        override var clientToken: String? = null
        override var cpuOptions: CpuOptions? = null
        override var ebsOptimized: Boolean? = null
        override var elasticGpuAssociations: List<ElasticGpuAssociation>? = null
        override var elasticInferenceAcceleratorAssociations: List<ElasticInferenceAcceleratorAssociation>? = null
        override var enaSupport: Boolean? = null
        override var enclaveOptions: EnclaveOptions? = null
        override var hibernationOptions: HibernationOptions? = null
        override var hypervisor: HypervisorType? = null
        override var iamInstanceProfile: IamInstanceProfile? = null
        override var imageId: String? = null
        override var instanceId: String? = null
        override var instanceLifecycle: InstanceLifecycleType? = null
        override var instanceType: InstanceType? = null
        override var kernelId: String? = null
        override var keyName: String? = null
        override var launchTime: Instant? = null
        override var licenses: List<LicenseConfiguration>? = null
        override var metadataOptions: InstanceMetadataOptionsResponse? = null
        override var monitoring: Monitoring? = null
        override var networkInterfaces: List<InstanceNetworkInterface>? = null
        override var outpostArn: String? = null
        override var placement: Placement? = null
        override var platform: PlatformValues? = null
        override var platformDetails: String? = null
        override var privateDnsName: String? = null
        override var privateIpAddress: String? = null
        override var productCodes: List<ProductCode>? = null
        override var publicDnsName: String? = null
        override var publicIpAddress: String? = null
        override var ramdiskId: String? = null
        override var rootDeviceName: String? = null
        override var rootDeviceType: DeviceType? = null
        override var securityGroups: List<GroupIdentifier>? = null
        override var sourceDestCheck: Boolean? = null
        override var spotInstanceRequestId: String? = null
        override var sriovNetSupport: String? = null
        override var state: InstanceState? = null
        override var stateReason: StateReason? = null
        override var stateTransitionReason: String? = null
        override var subnetId: String? = null
        override var tags: List<Tag>? = null
        override var usageOperation: String? = null
        override var usageOperationUpdateTime: Instant? = null
        override var virtualizationType: VirtualizationType? = null
        override var vpcId: String? = null

        constructor(x: Instance) : this() {
            this.amiLaunchIndex = x.amiLaunchIndex
            this.architecture = x.architecture
            this.blockDeviceMappings = x.blockDeviceMappings
            this.bootMode = x.bootMode
            this.capacityReservationId = x.capacityReservationId
            this.capacityReservationSpecification = x.capacityReservationSpecification
            this.clientToken = x.clientToken
            this.cpuOptions = x.cpuOptions
            this.ebsOptimized = x.ebsOptimized
            this.elasticGpuAssociations = x.elasticGpuAssociations
            this.elasticInferenceAcceleratorAssociations = x.elasticInferenceAcceleratorAssociations
            this.enaSupport = x.enaSupport
            this.enclaveOptions = x.enclaveOptions
            this.hibernationOptions = x.hibernationOptions
            this.hypervisor = x.hypervisor
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceId = x.instanceId
            this.instanceLifecycle = x.instanceLifecycle
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.launchTime = x.launchTime
            this.licenses = x.licenses
            this.metadataOptions = x.metadataOptions
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.outpostArn = x.outpostArn
            this.placement = x.placement
            this.platform = x.platform
            this.platformDetails = x.platformDetails
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
            this.productCodes = x.productCodes
            this.publicDnsName = x.publicDnsName
            this.publicIpAddress = x.publicIpAddress
            this.ramdiskId = x.ramdiskId
            this.rootDeviceName = x.rootDeviceName
            this.rootDeviceType = x.rootDeviceType
            this.securityGroups = x.securityGroups
            this.sourceDestCheck = x.sourceDestCheck
            this.spotInstanceRequestId = x.spotInstanceRequestId
            this.sriovNetSupport = x.sriovNetSupport
            this.state = x.state
            this.stateReason = x.stateReason
            this.stateTransitionReason = x.stateTransitionReason
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.usageOperation = x.usageOperation
            this.usageOperationUpdateTime = x.usageOperationUpdateTime
            this.virtualizationType = x.virtualizationType
            this.vpcId = x.vpcId
        }

        override fun build(): Instance = Instance(this)
        override fun amiLaunchIndex(amiLaunchIndex: Int): FluentBuilder = apply { this.amiLaunchIndex = amiLaunchIndex }
        override fun architecture(architecture: ArchitectureValues): FluentBuilder = apply { this.architecture = architecture }
        override fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun bootMode(bootMode: BootModeValues): FluentBuilder = apply { this.bootMode = bootMode }
        override fun capacityReservationId(capacityReservationId: String): FluentBuilder = apply { this.capacityReservationId = capacityReservationId }
        override fun capacityReservationSpecification(capacityReservationSpecification: CapacityReservationSpecificationResponse): FluentBuilder = apply { this.capacityReservationSpecification = capacityReservationSpecification }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun cpuOptions(cpuOptions: CpuOptions): FluentBuilder = apply { this.cpuOptions = cpuOptions }
        override fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun elasticGpuAssociations(elasticGpuAssociations: List<ElasticGpuAssociation>): FluentBuilder = apply { this.elasticGpuAssociations = elasticGpuAssociations }
        override fun elasticInferenceAcceleratorAssociations(elasticInferenceAcceleratorAssociations: List<ElasticInferenceAcceleratorAssociation>): FluentBuilder = apply { this.elasticInferenceAcceleratorAssociations = elasticInferenceAcceleratorAssociations }
        override fun enaSupport(enaSupport: Boolean): FluentBuilder = apply { this.enaSupport = enaSupport }
        override fun enclaveOptions(enclaveOptions: EnclaveOptions): FluentBuilder = apply { this.enclaveOptions = enclaveOptions }
        override fun hibernationOptions(hibernationOptions: HibernationOptions): FluentBuilder = apply { this.hibernationOptions = hibernationOptions }
        override fun hypervisor(hypervisor: HypervisorType): FluentBuilder = apply { this.hypervisor = hypervisor }
        override fun iamInstanceProfile(iamInstanceProfile: IamInstanceProfile): FluentBuilder = apply { this.iamInstanceProfile = iamInstanceProfile }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceLifecycle(instanceLifecycle: InstanceLifecycleType): FluentBuilder = apply { this.instanceLifecycle = instanceLifecycle }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun kernelId(kernelId: String): FluentBuilder = apply { this.kernelId = kernelId }
        override fun keyName(keyName: String): FluentBuilder = apply { this.keyName = keyName }
        override fun launchTime(launchTime: Instant): FluentBuilder = apply { this.launchTime = launchTime }
        override fun licenses(licenses: List<LicenseConfiguration>): FluentBuilder = apply { this.licenses = licenses }
        override fun metadataOptions(metadataOptions: InstanceMetadataOptionsResponse): FluentBuilder = apply { this.metadataOptions = metadataOptions }
        override fun monitoring(monitoring: Monitoring): FluentBuilder = apply { this.monitoring = monitoring }
        override fun networkInterfaces(networkInterfaces: List<InstanceNetworkInterface>): FluentBuilder = apply { this.networkInterfaces = networkInterfaces }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun placement(placement: Placement): FluentBuilder = apply { this.placement = placement }
        override fun platform(platform: PlatformValues): FluentBuilder = apply { this.platform = platform }
        override fun platformDetails(platformDetails: String): FluentBuilder = apply { this.platformDetails = platformDetails }
        override fun privateDnsName(privateDnsName: String): FluentBuilder = apply { this.privateDnsName = privateDnsName }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun productCodes(productCodes: List<ProductCode>): FluentBuilder = apply { this.productCodes = productCodes }
        override fun publicDnsName(publicDnsName: String): FluentBuilder = apply { this.publicDnsName = publicDnsName }
        override fun publicIpAddress(publicIpAddress: String): FluentBuilder = apply { this.publicIpAddress = publicIpAddress }
        override fun ramdiskId(ramdiskId: String): FluentBuilder = apply { this.ramdiskId = ramdiskId }
        override fun rootDeviceName(rootDeviceName: String): FluentBuilder = apply { this.rootDeviceName = rootDeviceName }
        override fun rootDeviceType(rootDeviceType: DeviceType): FluentBuilder = apply { this.rootDeviceType = rootDeviceType }
        override fun securityGroups(securityGroups: List<GroupIdentifier>): FluentBuilder = apply { this.securityGroups = securityGroups }
        override fun sourceDestCheck(sourceDestCheck: Boolean): FluentBuilder = apply { this.sourceDestCheck = sourceDestCheck }
        override fun spotInstanceRequestId(spotInstanceRequestId: String): FluentBuilder = apply { this.spotInstanceRequestId = spotInstanceRequestId }
        override fun sriovNetSupport(sriovNetSupport: String): FluentBuilder = apply { this.sriovNetSupport = sriovNetSupport }
        override fun state(state: InstanceState): FluentBuilder = apply { this.state = state }
        override fun stateReason(stateReason: StateReason): FluentBuilder = apply { this.stateReason = stateReason }
        override fun stateTransitionReason(stateTransitionReason: String): FluentBuilder = apply { this.stateTransitionReason = stateTransitionReason }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun usageOperation(usageOperation: String): FluentBuilder = apply { this.usageOperation = usageOperation }
        override fun usageOperationUpdateTime(usageOperationUpdateTime: Instant): FluentBuilder = apply { this.usageOperationUpdateTime = usageOperationUpdateTime }
        override fun virtualizationType(virtualizationType: VirtualizationType): FluentBuilder = apply { this.virtualizationType = virtualizationType }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
