// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a block device mapping entry.
 */
class InstanceBlockDeviceMappingSpecification private constructor(builder: BuilderImpl) {
    /**
     * The device name (for example, /dev/sdh or xvdh).
     */
    val deviceName: String? = builder.deviceName
    /**
     * Parameters used to automatically set up EBS volumes when the instance is
     * launched.
     */
    val ebs: EbsInstanceBlockDeviceSpecification? = builder.ebs
    /**
     * suppress the specified device included in the block device mapping.
     */
    val noDevice: String? = builder.noDevice
    /**
     * The virtual device name.
     */
    val virtualName: String? = builder.virtualName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceBlockDeviceMappingSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceBlockDeviceMappingSpecification(")
        append("deviceName=$deviceName,")
        append("ebs=$ebs,")
        append("noDevice=$noDevice,")
        append("virtualName=$virtualName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceName?.hashCode() ?: 0
        result = 31 * result + (ebs?.hashCode() ?: 0)
        result = 31 * result + (noDevice?.hashCode() ?: 0)
        result = 31 * result + (virtualName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceBlockDeviceMappingSpecification

        if (deviceName != other.deviceName) return false
        if (ebs != other.ebs) return false
        if (noDevice != other.noDevice) return false
        if (virtualName != other.virtualName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceBlockDeviceMappingSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceBlockDeviceMappingSpecification
        /**
         * The device name (for example, /dev/sdh or xvdh).
         */
        fun deviceName(deviceName: String): FluentBuilder
        /**
         * Parameters used to automatically set up EBS volumes when the instance is
         * launched.
         */
        fun ebs(ebs: EbsInstanceBlockDeviceSpecification): FluentBuilder
        /**
         * suppress the specified device included in the block device mapping.
         */
        fun noDevice(noDevice: String): FluentBuilder
        /**
         * The virtual device name.
         */
        fun virtualName(virtualName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The device name (for example, /dev/sdh or xvdh).
         */
        var deviceName: String?
        /**
         * Parameters used to automatically set up EBS volumes when the instance is
         * launched.
         */
        var ebs: EbsInstanceBlockDeviceSpecification?
        /**
         * suppress the specified device included in the block device mapping.
         */
        var noDevice: String?
        /**
         * The virtual device name.
         */
        var virtualName: String?

        fun build(): InstanceBlockDeviceMappingSpecification
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EbsInstanceBlockDeviceSpecification] inside the given [block]
         */
        fun ebs(block: EbsInstanceBlockDeviceSpecification.DslBuilder.() -> kotlin.Unit) {
            this.ebs = EbsInstanceBlockDeviceSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deviceName: String? = null
        override var ebs: EbsInstanceBlockDeviceSpecification? = null
        override var noDevice: String? = null
        override var virtualName: String? = null

        constructor(x: InstanceBlockDeviceMappingSpecification) : this() {
            this.deviceName = x.deviceName
            this.ebs = x.ebs
            this.noDevice = x.noDevice
            this.virtualName = x.virtualName
        }

        override fun build(): InstanceBlockDeviceMappingSpecification = InstanceBlockDeviceMappingSpecification(this)
        override fun deviceName(deviceName: String): FluentBuilder = apply { this.deviceName = deviceName }
        override fun ebs(ebs: EbsInstanceBlockDeviceSpecification): FluentBuilder = apply { this.ebs = ebs }
        override fun noDevice(noDevice: String): FluentBuilder = apply { this.noDevice = noDevice }
        override fun virtualName(virtualName: String): FluentBuilder = apply { this.virtualName = virtualName }
    }
}
