// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about the number of instances that can be launched onto the Dedicated
 * Host.
 */
class InstanceCapacity private constructor(builder: BuilderImpl) {
    /**
     * The number of instances that can be launched onto the Dedicated Host based on the
     * host's available capacity.
     */
    val availableCapacity: Int? = builder.availableCapacity
    /**
     * The instance type supported by the Dedicated Host.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The total number of instances that can be launched onto the Dedicated Host if there
     * are no instances running on it.
     */
    val totalCapacity: Int? = builder.totalCapacity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceCapacity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceCapacity(")
        append("availableCapacity=$availableCapacity,")
        append("instanceType=$instanceType,")
        append("totalCapacity=$totalCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availableCapacity ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (totalCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceCapacity

        if (availableCapacity != other.availableCapacity) return false
        if (instanceType != other.instanceType) return false
        if (totalCapacity != other.totalCapacity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceCapacity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceCapacity
        /**
         * The number of instances that can be launched onto the Dedicated Host based on the
         * host's available capacity.
         */
        fun availableCapacity(availableCapacity: Int): FluentBuilder
        /**
         * The instance type supported by the Dedicated Host.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The total number of instances that can be launched onto the Dedicated Host if there
         * are no instances running on it.
         */
        fun totalCapacity(totalCapacity: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of instances that can be launched onto the Dedicated Host based on the
         * host's available capacity.
         */
        var availableCapacity: Int?
        /**
         * The instance type supported by the Dedicated Host.
         */
        var instanceType: String?
        /**
         * The total number of instances that can be launched onto the Dedicated Host if there
         * are no instances running on it.
         */
        var totalCapacity: Int?

        fun build(): InstanceCapacity
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availableCapacity: Int? = null
        override var instanceType: String? = null
        override var totalCapacity: Int? = null

        constructor(x: InstanceCapacity) : this() {
            this.availableCapacity = x.availableCapacity
            this.instanceType = x.instanceType
            this.totalCapacity = x.totalCapacity
        }

        override fun build(): InstanceCapacity = InstanceCapacity(this)
        override fun availableCapacity(availableCapacity: Int): FluentBuilder = apply { this.availableCapacity = availableCapacity }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun totalCapacity(totalCapacity: Int): FluentBuilder = apply { this.totalCapacity = totalCapacity }
    }
}
