// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the credit option for CPU usage of a burstable performance instance.
 */
class InstanceCreditSpecificationRequest private constructor(builder: BuilderImpl) {
    /**
     * The credit option for CPU usage of the instance. Valid values are
     * standard and unlimited.
     * T3 instances with host tenancy do not support the unlimited
     * CPU credit option.
     */
    val cpuCredits: String? = builder.cpuCredits
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceCreditSpecificationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceCreditSpecificationRequest(")
        append("cpuCredits=$cpuCredits,")
        append("instanceId=$instanceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cpuCredits?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceCreditSpecificationRequest

        if (cpuCredits != other.cpuCredits) return false
        if (instanceId != other.instanceId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceCreditSpecificationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceCreditSpecificationRequest
        /**
         * The credit option for CPU usage of the instance. Valid values are
         * standard and unlimited.
         * T3 instances with host tenancy do not support the unlimited
         * CPU credit option.
         */
        fun cpuCredits(cpuCredits: String): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The credit option for CPU usage of the instance. Valid values are
         * standard and unlimited.
         * T3 instances with host tenancy do not support the unlimited
         * CPU credit option.
         */
        var cpuCredits: String?
        /**
         * The ID of the instance.
         */
        var instanceId: String?

        fun build(): InstanceCreditSpecificationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cpuCredits: String? = null
        override var instanceId: String? = null

        constructor(x: InstanceCreditSpecificationRequest) : this() {
            this.cpuCredits = x.cpuCredits
            this.instanceId = x.instanceId
        }

        override fun build(): InstanceCreditSpecificationRequest = InstanceCreditSpecificationRequest(this)
        override fun cpuCredits(cpuCredits: String): FluentBuilder = apply { this.cpuCredits = cpuCredits }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
    }
}
