// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network interface.
 */
class InstanceNetworkInterface private constructor(builder: BuilderImpl) {
    /**
     * The association information for an Elastic IPv4 associated with the network
     * interface.
     */
    val association: InstanceNetworkInterfaceAssociation? = builder.association
    /**
     * The network interface attachment.
     */
    val attachment: InstanceNetworkInterfaceAttachment? = builder.attachment
    /**
     * The description.
     */
    val description: String? = builder.description
    /**
     * One or more security groups.
     */
    val groups: List<GroupIdentifier>? = builder.groups
    /**
     * Describes the type of network interface.
     * Valid values: interface | efa | trunk
     */
    val interfaceType: String? = builder.interfaceType
    /**
     * The IPv4 delegated prefixes that are assigned to the network interface.
     */
    val ipv4Prefixes: List<InstanceIpv4Prefix>? = builder.ipv4Prefixes
    /**
     * One or more IPv6 addresses associated with the network interface.
     */
    val ipv6Addresses: List<InstanceIpv6Address>? = builder.ipv6Addresses
    /**
     * The IPv6 delegated prefixes that are assigned to the network interface.
     */
    val ipv6Prefixes: List<InstanceIpv6Prefix>? = builder.ipv6Prefixes
    /**
     * The MAC address.
     */
    val macAddress: String? = builder.macAddress
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The ID of the Amazon Web Services account that created the network interface.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The private DNS name.
     */
    val privateDnsName: String? = builder.privateDnsName
    /**
     * The IPv4 address of the network interface within the subnet.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * One or more private IPv4 addresses associated with the network interface.
     */
    val privateIpAddresses: List<InstancePrivateIpAddress>? = builder.privateIpAddresses
    /**
     * Indicates whether source/destination checking is enabled.
     */
    val sourceDestCheck: Boolean? = builder.sourceDestCheck
    /**
     * The status of the network interface.
     */
    val status: NetworkInterfaceStatus? = builder.status
    /**
     * The ID of the subnet.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceNetworkInterface = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceNetworkInterface(")
        append("association=$association,")
        append("attachment=$attachment,")
        append("description=$description,")
        append("groups=$groups,")
        append("interfaceType=$interfaceType,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("ipv6Prefixes=$ipv6Prefixes,")
        append("macAddress=$macAddress,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("ownerId=$ownerId,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("sourceDestCheck=$sourceDestCheck,")
        append("status=$status,")
        append("subnetId=$subnetId,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = association?.hashCode() ?: 0
        result = 31 * result + (attachment?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (interfaceType?.hashCode() ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6Prefixes?.hashCode() ?: 0)
        result = 31 * result + (macAddress?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (sourceDestCheck?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceNetworkInterface

        if (association != other.association) return false
        if (attachment != other.attachment) return false
        if (description != other.description) return false
        if (groups != other.groups) return false
        if (interfaceType != other.interfaceType) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (ipv6Prefixes != other.ipv6Prefixes) return false
        if (macAddress != other.macAddress) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (ownerId != other.ownerId) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (sourceDestCheck != other.sourceDestCheck) return false
        if (status != other.status) return false
        if (subnetId != other.subnetId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceNetworkInterface = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceNetworkInterface
        /**
         * The association information for an Elastic IPv4 associated with the network
         * interface.
         */
        fun association(association: InstanceNetworkInterfaceAssociation): FluentBuilder
        /**
         * The network interface attachment.
         */
        fun attachment(attachment: InstanceNetworkInterfaceAttachment): FluentBuilder
        /**
         * The description.
         */
        fun description(description: String): FluentBuilder
        /**
         * One or more security groups.
         */
        fun groups(groups: List<GroupIdentifier>): FluentBuilder
        /**
         * Describes the type of network interface.
         * Valid values: interface | efa | trunk
         */
        fun interfaceType(interfaceType: String): FluentBuilder
        /**
         * The IPv4 delegated prefixes that are assigned to the network interface.
         */
        fun ipv4Prefixes(ipv4Prefixes: List<InstanceIpv4Prefix>): FluentBuilder
        /**
         * One or more IPv6 addresses associated with the network interface.
         */
        fun ipv6Addresses(ipv6Addresses: List<InstanceIpv6Address>): FluentBuilder
        /**
         * The IPv6 delegated prefixes that are assigned to the network interface.
         */
        fun ipv6Prefixes(ipv6Prefixes: List<InstanceIpv6Prefix>): FluentBuilder
        /**
         * The MAC address.
         */
        fun macAddress(macAddress: String): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that created the network interface.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The private DNS name.
         */
        fun privateDnsName(privateDnsName: String): FluentBuilder
        /**
         * The IPv4 address of the network interface within the subnet.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * One or more private IPv4 addresses associated with the network interface.
         */
        fun privateIpAddresses(privateIpAddresses: List<InstancePrivateIpAddress>): FluentBuilder
        /**
         * Indicates whether source/destination checking is enabled.
         */
        fun sourceDestCheck(sourceDestCheck: Boolean): FluentBuilder
        /**
         * The status of the network interface.
         */
        fun status(status: NetworkInterfaceStatus): FluentBuilder
        /**
         * The ID of the subnet.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The association information for an Elastic IPv4 associated with the network
         * interface.
         */
        var association: InstanceNetworkInterfaceAssociation?
        /**
         * The network interface attachment.
         */
        var attachment: InstanceNetworkInterfaceAttachment?
        /**
         * The description.
         */
        var description: String?
        /**
         * One or more security groups.
         */
        var groups: List<GroupIdentifier>?
        /**
         * Describes the type of network interface.
         * Valid values: interface | efa | trunk
         */
        var interfaceType: String?
        /**
         * The IPv4 delegated prefixes that are assigned to the network interface.
         */
        var ipv4Prefixes: List<InstanceIpv4Prefix>?
        /**
         * One or more IPv6 addresses associated with the network interface.
         */
        var ipv6Addresses: List<InstanceIpv6Address>?
        /**
         * The IPv6 delegated prefixes that are assigned to the network interface.
         */
        var ipv6Prefixes: List<InstanceIpv6Prefix>?
        /**
         * The MAC address.
         */
        var macAddress: String?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * The ID of the Amazon Web Services account that created the network interface.
         */
        var ownerId: String?
        /**
         * The private DNS name.
         */
        var privateDnsName: String?
        /**
         * The IPv4 address of the network interface within the subnet.
         */
        var privateIpAddress: String?
        /**
         * One or more private IPv4 addresses associated with the network interface.
         */
        var privateIpAddresses: List<InstancePrivateIpAddress>?
        /**
         * Indicates whether source/destination checking is enabled.
         */
        var sourceDestCheck: Boolean?
        /**
         * The status of the network interface.
         */
        var status: NetworkInterfaceStatus?
        /**
         * The ID of the subnet.
         */
        var subnetId: String?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): InstanceNetworkInterface
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceNetworkInterfaceAssociation] inside the given [block]
         */
        fun association(block: InstanceNetworkInterfaceAssociation.DslBuilder.() -> kotlin.Unit) {
            this.association = InstanceNetworkInterfaceAssociation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceNetworkInterfaceAttachment] inside the given [block]
         */
        fun attachment(block: InstanceNetworkInterfaceAttachment.DslBuilder.() -> kotlin.Unit) {
            this.attachment = InstanceNetworkInterfaceAttachment.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var association: InstanceNetworkInterfaceAssociation? = null
        override var attachment: InstanceNetworkInterfaceAttachment? = null
        override var description: String? = null
        override var groups: List<GroupIdentifier>? = null
        override var interfaceType: String? = null
        override var ipv4Prefixes: List<InstanceIpv4Prefix>? = null
        override var ipv6Addresses: List<InstanceIpv6Address>? = null
        override var ipv6Prefixes: List<InstanceIpv6Prefix>? = null
        override var macAddress: String? = null
        override var networkInterfaceId: String? = null
        override var ownerId: String? = null
        override var privateDnsName: String? = null
        override var privateIpAddress: String? = null
        override var privateIpAddresses: List<InstancePrivateIpAddress>? = null
        override var sourceDestCheck: Boolean? = null
        override var status: NetworkInterfaceStatus? = null
        override var subnetId: String? = null
        override var vpcId: String? = null

        constructor(x: InstanceNetworkInterface) : this() {
            this.association = x.association
            this.attachment = x.attachment
            this.description = x.description
            this.groups = x.groups
            this.interfaceType = x.interfaceType
            this.ipv4Prefixes = x.ipv4Prefixes
            this.ipv6Addresses = x.ipv6Addresses
            this.ipv6Prefixes = x.ipv6Prefixes
            this.macAddress = x.macAddress
            this.networkInterfaceId = x.networkInterfaceId
            this.ownerId = x.ownerId
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.sourceDestCheck = x.sourceDestCheck
            this.status = x.status
            this.subnetId = x.subnetId
            this.vpcId = x.vpcId
        }

        override fun build(): InstanceNetworkInterface = InstanceNetworkInterface(this)
        override fun association(association: InstanceNetworkInterfaceAssociation): FluentBuilder = apply { this.association = association }
        override fun attachment(attachment: InstanceNetworkInterfaceAttachment): FluentBuilder = apply { this.attachment = attachment }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun groups(groups: List<GroupIdentifier>): FluentBuilder = apply { this.groups = groups }
        override fun interfaceType(interfaceType: String): FluentBuilder = apply { this.interfaceType = interfaceType }
        override fun ipv4Prefixes(ipv4Prefixes: List<InstanceIpv4Prefix>): FluentBuilder = apply { this.ipv4Prefixes = ipv4Prefixes }
        override fun ipv6Addresses(ipv6Addresses: List<InstanceIpv6Address>): FluentBuilder = apply { this.ipv6Addresses = ipv6Addresses }
        override fun ipv6Prefixes(ipv6Prefixes: List<InstanceIpv6Prefix>): FluentBuilder = apply { this.ipv6Prefixes = ipv6Prefixes }
        override fun macAddress(macAddress: String): FluentBuilder = apply { this.macAddress = macAddress }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun privateDnsName(privateDnsName: String): FluentBuilder = apply { this.privateDnsName = privateDnsName }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun privateIpAddresses(privateIpAddresses: List<InstancePrivateIpAddress>): FluentBuilder = apply { this.privateIpAddresses = privateIpAddresses }
        override fun sourceDestCheck(sourceDestCheck: Boolean): FluentBuilder = apply { this.sourceDestCheck = sourceDestCheck }
        override fun status(status: NetworkInterfaceStatus): FluentBuilder = apply { this.status = status }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
