// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network interface.
 */
class InstanceNetworkInterfaceSpecification private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether to assign a carrier IP address to the network interface.
     * You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone.
     * For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength Developer Guide.
     */
    val associateCarrierIpAddress: Boolean? = builder.associateCarrierIpAddress
    /**
     * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The
     * public IP address can only be assigned to a network interface for eth0, and can only be
     * assigned to a new network interface, not an existing one. You cannot specify more than one
     * network interface in the request. If launching into a default subnet, the default value is
     * true.
     */
    val associatePublicIpAddress: Boolean? = builder.associatePublicIpAddress
    /**
     * If set to true, the interface is deleted when the instance is terminated. You can
     * specify true only if creating a new network interface when launching an
     * instance.
     */
    val deleteOnTermination: Boolean? = builder.deleteOnTermination
    /**
     * The description of the network interface. Applies only if creating a network interface when launching an instance.
     */
    val description: String? = builder.description
    /**
     * The position of the network interface in the attachment order.
     * A primary network interface has a device index of 0.
     * If you specify a network interface when launching an instance,
     * you must specify the device index.
     */
    val deviceIndex: Int? = builder.deviceIndex
    /**
     * The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.
     */
    val groups: List<String>? = builder.groups
    /**
     * The type of network interface.
     * To create an Elastic Fabric Adapter (EFA), specify
     * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter in the
     * Amazon Elastic Compute Cloud User Guide.
     * Valid values: interface | efa
     */
    val interfaceType: String? = builder.interfaceType
    /**
     * The number of IPv4 delegated prefixes to be automatically assigned to the network interface.
     * You cannot use this option if you use the Ipv4Prefix option.
     */
    val ipv4PrefixCount: Int? = builder.ipv4PrefixCount
    /**
     * One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot
     * use this option if you use the Ipv4PrefixCount option.
     */
    val ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>? = builder.ipv4Prefixes
    /**
     * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses
     * the IPv6 addresses from the range of the subnet. You cannot specify this option and the
     * option to assign specific IPv6 addresses in the same request. You can specify this
     * option if you've specified a minimum number of instances to launch.
     */
    val ipv6AddressCount: Int? = builder.ipv6AddressCount
    /**
     * One or more IPv6 addresses to assign to the network interface. You cannot specify
     * this option and the option to assign a number of IPv6 addresses in the same request. You
     * cannot specify this option if you've specified a minimum number of instances to
     * launch.
     */
    val ipv6Addresses: List<InstanceIpv6Address>? = builder.ipv6Addresses
    /**
     * The number of IPv6 delegated prefixes to be automatically assigned to the network interface.
     * You cannot use this option if you use the Ipv6Prefix option.
     */
    val ipv6PrefixCount: Int? = builder.ipv6PrefixCount
    /**
     * One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot
     * use this option if you use the Ipv6PrefixCount option.
     */
    val ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>? = builder.ipv6Prefixes
    /**
     * The index of the network card. Some instance types support multiple network cards.
     * The primary network interface must be assigned to network card index 0.
     * The default is network card index 0.
     * If you are using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances to create Spot Instances, omit this parameter because
     * you can’t specify the network card index when using this API. To specify the network
     * card index, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances.
     */
    val networkCardIndex: Int? = builder.networkCardIndex
    /**
     * The ID of the network interface.
     * If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching
     * more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're
     * launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
     */
    val privateIpAddresses: List<PrivateIpAddressSpecification>? = builder.privateIpAddresses
    /**
     * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're
     * launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
     */
    val secondaryPrivateIpAddressCount: Int? = builder.secondaryPrivateIpAddressCount
    /**
     * The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.
     */
    val subnetId: String? = builder.subnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceNetworkInterfaceSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceNetworkInterfaceSpecification(")
        append("associateCarrierIpAddress=$associateCarrierIpAddress,")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("description=$description,")
        append("deviceIndex=$deviceIndex,")
        append("groups=$groups,")
        append("interfaceType=$interfaceType,")
        append("ipv4PrefixCount=$ipv4PrefixCount,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("ipv6AddressCount=$ipv6AddressCount,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("ipv6PrefixCount=$ipv6PrefixCount,")
        append("ipv6Prefixes=$ipv6Prefixes,")
        append("networkCardIndex=$networkCardIndex,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("secondaryPrivateIpAddressCount=$secondaryPrivateIpAddressCount,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associateCarrierIpAddress?.hashCode() ?: 0
        result = 31 * result + (associatePublicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceIndex ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (interfaceType?.hashCode() ?: 0)
        result = 31 * result + (ipv4PrefixCount ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (ipv6AddressCount ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6PrefixCount ?: 0)
        result = 31 * result + (ipv6Prefixes?.hashCode() ?: 0)
        result = 31 * result + (networkCardIndex ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (secondaryPrivateIpAddressCount ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceNetworkInterfaceSpecification

        if (associateCarrierIpAddress != other.associateCarrierIpAddress) return false
        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (description != other.description) return false
        if (deviceIndex != other.deviceIndex) return false
        if (groups != other.groups) return false
        if (interfaceType != other.interfaceType) return false
        if (ipv4PrefixCount != other.ipv4PrefixCount) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (ipv6AddressCount != other.ipv6AddressCount) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (ipv6PrefixCount != other.ipv6PrefixCount) return false
        if (ipv6Prefixes != other.ipv6Prefixes) return false
        if (networkCardIndex != other.networkCardIndex) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (secondaryPrivateIpAddressCount != other.secondaryPrivateIpAddressCount) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceNetworkInterfaceSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceNetworkInterfaceSpecification
        /**
         * Indicates whether to assign a carrier IP address to the network interface.
         * You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone.
         * For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength Developer Guide.
         */
        fun associateCarrierIpAddress(associateCarrierIpAddress: Boolean): FluentBuilder
        /**
         * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The
         * public IP address can only be assigned to a network interface for eth0, and can only be
         * assigned to a new network interface, not an existing one. You cannot specify more than one
         * network interface in the request. If launching into a default subnet, the default value is
         * true.
         */
        fun associatePublicIpAddress(associatePublicIpAddress: Boolean): FluentBuilder
        /**
         * If set to true, the interface is deleted when the instance is terminated. You can
         * specify true only if creating a new network interface when launching an
         * instance.
         */
        fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder
        /**
         * The description of the network interface. Applies only if creating a network interface when launching an instance.
         */
        fun description(description: String): FluentBuilder
        /**
         * The position of the network interface in the attachment order.
         * A primary network interface has a device index of 0.
         * If you specify a network interface when launching an instance,
         * you must specify the device index.
         */
        fun deviceIndex(deviceIndex: Int): FluentBuilder
        /**
         * The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.
         */
        fun groups(groups: List<String>): FluentBuilder
        /**
         * The type of network interface.
         * To create an Elastic Fabric Adapter (EFA), specify
         * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter in the
         * Amazon Elastic Compute Cloud User Guide.
         * Valid values: interface | efa
         */
        fun interfaceType(interfaceType: String): FluentBuilder
        /**
         * The number of IPv4 delegated prefixes to be automatically assigned to the network interface.
         * You cannot use this option if you use the Ipv4Prefix option.
         */
        fun ipv4PrefixCount(ipv4PrefixCount: Int): FluentBuilder
        /**
         * One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot
         * use this option if you use the Ipv4PrefixCount option.
         */
        fun ipv4Prefixes(ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>): FluentBuilder
        /**
         * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses
         * the IPv6 addresses from the range of the subnet. You cannot specify this option and the
         * option to assign specific IPv6 addresses in the same request. You can specify this
         * option if you've specified a minimum number of instances to launch.
         */
        fun ipv6AddressCount(ipv6AddressCount: Int): FluentBuilder
        /**
         * One or more IPv6 addresses to assign to the network interface. You cannot specify
         * this option and the option to assign a number of IPv6 addresses in the same request. You
         * cannot specify this option if you've specified a minimum number of instances to
         * launch.
         */
        fun ipv6Addresses(ipv6Addresses: List<InstanceIpv6Address>): FluentBuilder
        /**
         * The number of IPv6 delegated prefixes to be automatically assigned to the network interface.
         * You cannot use this option if you use the Ipv6Prefix option.
         */
        fun ipv6PrefixCount(ipv6PrefixCount: Int): FluentBuilder
        /**
         * One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot
         * use this option if you use the Ipv6PrefixCount option.
         */
        fun ipv6Prefixes(ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>): FluentBuilder
        /**
         * The index of the network card. Some instance types support multiple network cards.
         * The primary network interface must be assigned to network card index 0.
         * The default is network card index 0.
         * If you are using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances to create Spot Instances, omit this parameter because
         * you can’t specify the network card index when using this API. To specify the network
         * card index, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances.
         */
        fun networkCardIndex(networkCardIndex: Int): FluentBuilder
        /**
         * The ID of the network interface.
         * If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching
         * more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're
         * launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
         */
        fun privateIpAddresses(privateIpAddresses: List<PrivateIpAddressSpecification>): FluentBuilder
        /**
         * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're
         * launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
         */
        fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder
        /**
         * The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.
         */
        fun subnetId(subnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether to assign a carrier IP address to the network interface.
         * You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone.
         * For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength Developer Guide.
         */
        var associateCarrierIpAddress: Boolean?
        /**
         * Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The
         * public IP address can only be assigned to a network interface for eth0, and can only be
         * assigned to a new network interface, not an existing one. You cannot specify more than one
         * network interface in the request. If launching into a default subnet, the default value is
         * true.
         */
        var associatePublicIpAddress: Boolean?
        /**
         * If set to true, the interface is deleted when the instance is terminated. You can
         * specify true only if creating a new network interface when launching an
         * instance.
         */
        var deleteOnTermination: Boolean?
        /**
         * The description of the network interface. Applies only if creating a network interface when launching an instance.
         */
        var description: String?
        /**
         * The position of the network interface in the attachment order.
         * A primary network interface has a device index of 0.
         * If you specify a network interface when launching an instance,
         * you must specify the device index.
         */
        var deviceIndex: Int?
        /**
         * The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.
         */
        var groups: List<String>?
        /**
         * The type of network interface.
         * To create an Elastic Fabric Adapter (EFA), specify
         * efa. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter in the
         * Amazon Elastic Compute Cloud User Guide.
         * Valid values: interface | efa
         */
        var interfaceType: String?
        /**
         * The number of IPv4 delegated prefixes to be automatically assigned to the network interface.
         * You cannot use this option if you use the Ipv4Prefix option.
         */
        var ipv4PrefixCount: Int?
        /**
         * One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot
         * use this option if you use the Ipv4PrefixCount option.
         */
        var ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>?
        /**
         * A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses
         * the IPv6 addresses from the range of the subnet. You cannot specify this option and the
         * option to assign specific IPv6 addresses in the same request. You can specify this
         * option if you've specified a minimum number of instances to launch.
         */
        var ipv6AddressCount: Int?
        /**
         * One or more IPv6 addresses to assign to the network interface. You cannot specify
         * this option and the option to assign a number of IPv6 addresses in the same request. You
         * cannot specify this option if you've specified a minimum number of instances to
         * launch.
         */
        var ipv6Addresses: List<InstanceIpv6Address>?
        /**
         * The number of IPv6 delegated prefixes to be automatically assigned to the network interface.
         * You cannot use this option if you use the Ipv6Prefix option.
         */
        var ipv6PrefixCount: Int?
        /**
         * One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot
         * use this option if you use the Ipv6PrefixCount option.
         */
        var ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>?
        /**
         * The index of the network card. Some instance types support multiple network cards.
         * The primary network interface must be assigned to network card index 0.
         * The default is network card index 0.
         * If you are using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances to create Spot Instances, omit this parameter because
         * you can’t specify the network card index when using this API. To specify the network
         * card index, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances.
         */
        var networkCardIndex: Int?
        /**
         * The ID of the network interface.
         * If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.
         */
        var networkInterfaceId: String?
        /**
         * The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching
         * more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
         */
        var privateIpAddress: String?
        /**
         * One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're
         * launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
         */
        var privateIpAddresses: List<PrivateIpAddressSpecification>?
        /**
         * The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're
         * launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances request.
         */
        var secondaryPrivateIpAddressCount: Int?
        /**
         * The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.
         */
        var subnetId: String?

        fun build(): InstanceNetworkInterfaceSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associateCarrierIpAddress: Boolean? = null
        override var associatePublicIpAddress: Boolean? = null
        override var deleteOnTermination: Boolean? = null
        override var description: String? = null
        override var deviceIndex: Int? = null
        override var groups: List<String>? = null
        override var interfaceType: String? = null
        override var ipv4PrefixCount: Int? = null
        override var ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>? = null
        override var ipv6AddressCount: Int? = null
        override var ipv6Addresses: List<InstanceIpv6Address>? = null
        override var ipv6PrefixCount: Int? = null
        override var ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>? = null
        override var networkCardIndex: Int? = null
        override var networkInterfaceId: String? = null
        override var privateIpAddress: String? = null
        override var privateIpAddresses: List<PrivateIpAddressSpecification>? = null
        override var secondaryPrivateIpAddressCount: Int? = null
        override var subnetId: String? = null

        constructor(x: InstanceNetworkInterfaceSpecification) : this() {
            this.associateCarrierIpAddress = x.associateCarrierIpAddress
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.deleteOnTermination = x.deleteOnTermination
            this.description = x.description
            this.deviceIndex = x.deviceIndex
            this.groups = x.groups
            this.interfaceType = x.interfaceType
            this.ipv4PrefixCount = x.ipv4PrefixCount
            this.ipv4Prefixes = x.ipv4Prefixes
            this.ipv6AddressCount = x.ipv6AddressCount
            this.ipv6Addresses = x.ipv6Addresses
            this.ipv6PrefixCount = x.ipv6PrefixCount
            this.ipv6Prefixes = x.ipv6Prefixes
            this.networkCardIndex = x.networkCardIndex
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.secondaryPrivateIpAddressCount = x.secondaryPrivateIpAddressCount
            this.subnetId = x.subnetId
        }

        override fun build(): InstanceNetworkInterfaceSpecification = InstanceNetworkInterfaceSpecification(this)
        override fun associateCarrierIpAddress(associateCarrierIpAddress: Boolean): FluentBuilder = apply { this.associateCarrierIpAddress = associateCarrierIpAddress }
        override fun associatePublicIpAddress(associatePublicIpAddress: Boolean): FluentBuilder = apply { this.associatePublicIpAddress = associatePublicIpAddress }
        override fun deleteOnTermination(deleteOnTermination: Boolean): FluentBuilder = apply { this.deleteOnTermination = deleteOnTermination }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun deviceIndex(deviceIndex: Int): FluentBuilder = apply { this.deviceIndex = deviceIndex }
        override fun groups(groups: List<String>): FluentBuilder = apply { this.groups = groups }
        override fun interfaceType(interfaceType: String): FluentBuilder = apply { this.interfaceType = interfaceType }
        override fun ipv4PrefixCount(ipv4PrefixCount: Int): FluentBuilder = apply { this.ipv4PrefixCount = ipv4PrefixCount }
        override fun ipv4Prefixes(ipv4Prefixes: List<Ipv4PrefixSpecificationRequest>): FluentBuilder = apply { this.ipv4Prefixes = ipv4Prefixes }
        override fun ipv6AddressCount(ipv6AddressCount: Int): FluentBuilder = apply { this.ipv6AddressCount = ipv6AddressCount }
        override fun ipv6Addresses(ipv6Addresses: List<InstanceIpv6Address>): FluentBuilder = apply { this.ipv6Addresses = ipv6Addresses }
        override fun ipv6PrefixCount(ipv6PrefixCount: Int): FluentBuilder = apply { this.ipv6PrefixCount = ipv6PrefixCount }
        override fun ipv6Prefixes(ipv6Prefixes: List<Ipv6PrefixSpecificationRequest>): FluentBuilder = apply { this.ipv6Prefixes = ipv6Prefixes }
        override fun networkCardIndex(networkCardIndex: Int): FluentBuilder = apply { this.networkCardIndex = networkCardIndex }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun privateIpAddresses(privateIpAddresses: List<PrivateIpAddressSpecification>): FluentBuilder = apply { this.privateIpAddresses = privateIpAddresses }
        override fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder = apply { this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
    }
}
