// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a private IPv4 address.
 */
class InstancePrivateIpAddress private constructor(builder: BuilderImpl) {
    /**
     * The association information for an Elastic IP address for the network interface.
     */
    val association: InstanceNetworkInterfaceAssociation? = builder.association
    /**
     * Indicates whether this IPv4 address is the primary private IP address of the network interface.
     */
    val primary: Boolean? = builder.primary
    /**
     * The private IPv4 DNS name.
     */
    val privateDnsName: String? = builder.privateDnsName
    /**
     * The private IPv4 address of the network interface.
     */
    val privateIpAddress: String? = builder.privateIpAddress

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstancePrivateIpAddress = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstancePrivateIpAddress(")
        append("association=$association,")
        append("primary=$primary,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress)")
    }

    override fun hashCode(): kotlin.Int {
        var result = association?.hashCode() ?: 0
        result = 31 * result + (primary?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstancePrivateIpAddress

        if (association != other.association) return false
        if (primary != other.primary) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstancePrivateIpAddress = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstancePrivateIpAddress
        /**
         * The association information for an Elastic IP address for the network interface.
         */
        fun association(association: InstanceNetworkInterfaceAssociation): FluentBuilder
        /**
         * Indicates whether this IPv4 address is the primary private IP address of the network interface.
         */
        fun primary(primary: Boolean): FluentBuilder
        /**
         * The private IPv4 DNS name.
         */
        fun privateDnsName(privateDnsName: String): FluentBuilder
        /**
         * The private IPv4 address of the network interface.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The association information for an Elastic IP address for the network interface.
         */
        var association: InstanceNetworkInterfaceAssociation?
        /**
         * Indicates whether this IPv4 address is the primary private IP address of the network interface.
         */
        var primary: Boolean?
        /**
         * The private IPv4 DNS name.
         */
        var privateDnsName: String?
        /**
         * The private IPv4 address of the network interface.
         */
        var privateIpAddress: String?

        fun build(): InstancePrivateIpAddress
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceNetworkInterfaceAssociation] inside the given [block]
         */
        fun association(block: InstanceNetworkInterfaceAssociation.DslBuilder.() -> kotlin.Unit) {
            this.association = InstanceNetworkInterfaceAssociation.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var association: InstanceNetworkInterfaceAssociation? = null
        override var primary: Boolean? = null
        override var privateDnsName: String? = null
        override var privateIpAddress: String? = null

        constructor(x: InstancePrivateIpAddress) : this() {
            this.association = x.association
            this.primary = x.primary
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
        }

        override fun build(): InstancePrivateIpAddress = InstancePrivateIpAddress(this)
        override fun association(association: InstanceNetworkInterfaceAssociation): FluentBuilder = apply { this.association = association }
        override fun primary(primary: Boolean): FluentBuilder = apply { this.primary = primary }
        override fun privateDnsName(privateDnsName: String): FluentBuilder = apply { this.privateDnsName = privateDnsName }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
    }
}
