// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the status of an instance.
 */
class InstanceStatus private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone of the instance.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * Any scheduled events associated with the instance.
     */
    val events: List<InstanceStatusEvent>? = builder.events
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The intended state of the instance. DescribeInstanceStatus requires
     * that an instance be in the running state.
     */
    val instanceState: InstanceState? = builder.instanceState
    /**
     * Reports impaired functionality that stems from issues internal to the instance, such
     * as impaired reachability.
     */
    val instanceStatus: InstanceStatusSummary? = builder.instanceStatus
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * Reports impaired functionality that stems from issues related to the systems that
     * support an instance, such as hardware failures and network connectivity problems.
     */
    val systemStatus: InstanceStatusSummary? = builder.systemStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceStatus(")
        append("availabilityZone=$availabilityZone,")
        append("events=$events,")
        append("instanceId=$instanceId,")
        append("instanceState=$instanceState,")
        append("instanceStatus=$instanceStatus,")
        append("outpostArn=$outpostArn,")
        append("systemStatus=$systemStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (events?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceState?.hashCode() ?: 0)
        result = 31 * result + (instanceStatus?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (systemStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceStatus

        if (availabilityZone != other.availabilityZone) return false
        if (events != other.events) return false
        if (instanceId != other.instanceId) return false
        if (instanceState != other.instanceState) return false
        if (instanceStatus != other.instanceStatus) return false
        if (outpostArn != other.outpostArn) return false
        if (systemStatus != other.systemStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceStatus
        /**
         * The Availability Zone of the instance.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * Any scheduled events associated with the instance.
         */
        fun events(events: List<InstanceStatusEvent>): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The intended state of the instance. DescribeInstanceStatus requires
         * that an instance be in the running state.
         */
        fun instanceState(instanceState: InstanceState): FluentBuilder
        /**
         * Reports impaired functionality that stems from issues internal to the instance, such
         * as impaired reachability.
         */
        fun instanceStatus(instanceStatus: InstanceStatusSummary): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * Reports impaired functionality that stems from issues related to the systems that
         * support an instance, such as hardware failures and network connectivity problems.
         */
        fun systemStatus(systemStatus: InstanceStatusSummary): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone of the instance.
         */
        var availabilityZone: String?
        /**
         * Any scheduled events associated with the instance.
         */
        var events: List<InstanceStatusEvent>?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * The intended state of the instance. DescribeInstanceStatus requires
         * that an instance be in the running state.
         */
        var instanceState: InstanceState?
        /**
         * Reports impaired functionality that stems from issues internal to the instance, such
         * as impaired reachability.
         */
        var instanceStatus: InstanceStatusSummary?
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        var outpostArn: String?
        /**
         * Reports impaired functionality that stems from issues related to the systems that
         * support an instance, such as hardware failures and network connectivity problems.
         */
        var systemStatus: InstanceStatusSummary?

        fun build(): InstanceStatus
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceState] inside the given [block]
         */
        fun instanceState(block: InstanceState.DslBuilder.() -> kotlin.Unit) {
            this.instanceState = InstanceState.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceStatusSummary] inside the given [block]
         */
        fun instanceStatus(block: InstanceStatusSummary.DslBuilder.() -> kotlin.Unit) {
            this.instanceStatus = InstanceStatusSummary.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceStatusSummary] inside the given [block]
         */
        fun systemStatus(block: InstanceStatusSummary.DslBuilder.() -> kotlin.Unit) {
            this.systemStatus = InstanceStatusSummary.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var events: List<InstanceStatusEvent>? = null
        override var instanceId: String? = null
        override var instanceState: InstanceState? = null
        override var instanceStatus: InstanceStatusSummary? = null
        override var outpostArn: String? = null
        override var systemStatus: InstanceStatusSummary? = null

        constructor(x: InstanceStatus) : this() {
            this.availabilityZone = x.availabilityZone
            this.events = x.events
            this.instanceId = x.instanceId
            this.instanceState = x.instanceState
            this.instanceStatus = x.instanceStatus
            this.outpostArn = x.outpostArn
            this.systemStatus = x.systemStatus
        }

        override fun build(): InstanceStatus = InstanceStatus(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun events(events: List<InstanceStatusEvent>): FluentBuilder = apply { this.events = events }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceState(instanceState: InstanceState): FluentBuilder = apply { this.instanceState = instanceState }
        override fun instanceStatus(instanceStatus: InstanceStatusSummary): FluentBuilder = apply { this.instanceStatus = instanceStatus }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun systemStatus(systemStatus: InstanceStatusSummary): FluentBuilder = apply { this.systemStatus = systemStatus }
    }
}
