// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a scheduled event for an instance.
 */
class InstanceStatusEvent private constructor(builder: BuilderImpl) {
    /**
     * The event code.
     */
    val code: EventCode? = builder.code
    /**
     * A description of the event.
     * After a scheduled event is completed, it can still be described for up to a week. If
     * the event has been completed, this description starts with the following text:
     * &#91;Completed&#93;.
     */
    val description: String? = builder.description
    /**
     * The ID of the event.
     */
    val instanceEventId: String? = builder.instanceEventId
    /**
     * The latest scheduled end time for the event.
     */
    val notAfter: Instant? = builder.notAfter
    /**
     * The earliest scheduled start time for the event.
     */
    val notBefore: Instant? = builder.notBefore
    /**
     * The deadline for starting the event.
     */
    val notBeforeDeadline: Instant? = builder.notBeforeDeadline

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceStatusEvent = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceStatusEvent(")
        append("code=$code,")
        append("description=$description,")
        append("instanceEventId=$instanceEventId,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("notBeforeDeadline=$notBeforeDeadline)")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceEventId?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (notBeforeDeadline?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceStatusEvent

        if (code != other.code) return false
        if (description != other.description) return false
        if (instanceEventId != other.instanceEventId) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (notBeforeDeadline != other.notBeforeDeadline) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceStatusEvent = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceStatusEvent
        /**
         * The event code.
         */
        fun code(code: EventCode): FluentBuilder
        /**
         * A description of the event.
         * After a scheduled event is completed, it can still be described for up to a week. If
         * the event has been completed, this description starts with the following text:
         * &#91;Completed&#93;.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the event.
         */
        fun instanceEventId(instanceEventId: String): FluentBuilder
        /**
         * The latest scheduled end time for the event.
         */
        fun notAfter(notAfter: Instant): FluentBuilder
        /**
         * The earliest scheduled start time for the event.
         */
        fun notBefore(notBefore: Instant): FluentBuilder
        /**
         * The deadline for starting the event.
         */
        fun notBeforeDeadline(notBeforeDeadline: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The event code.
         */
        var code: EventCode?
        /**
         * A description of the event.
         * After a scheduled event is completed, it can still be described for up to a week. If
         * the event has been completed, this description starts with the following text:
         * &#91;Completed&#93;.
         */
        var description: String?
        /**
         * The ID of the event.
         */
        var instanceEventId: String?
        /**
         * The latest scheduled end time for the event.
         */
        var notAfter: Instant?
        /**
         * The earliest scheduled start time for the event.
         */
        var notBefore: Instant?
        /**
         * The deadline for starting the event.
         */
        var notBeforeDeadline: Instant?

        fun build(): InstanceStatusEvent
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var code: EventCode? = null
        override var description: String? = null
        override var instanceEventId: String? = null
        override var notAfter: Instant? = null
        override var notBefore: Instant? = null
        override var notBeforeDeadline: Instant? = null

        constructor(x: InstanceStatusEvent) : this() {
            this.code = x.code
            this.description = x.description
            this.instanceEventId = x.instanceEventId
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.notBeforeDeadline = x.notBeforeDeadline
        }

        override fun build(): InstanceStatusEvent = InstanceStatusEvent(this)
        override fun code(code: EventCode): FluentBuilder = apply { this.code = code }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun instanceEventId(instanceEventId: String): FluentBuilder = apply { this.instanceEventId = instanceEventId }
        override fun notAfter(notAfter: Instant): FluentBuilder = apply { this.notAfter = notAfter }
        override fun notBefore(notBefore: Instant): FluentBuilder = apply { this.notBefore = notBefore }
        override fun notBeforeDeadline(notBeforeDeadline: Instant): FluentBuilder = apply { this.notBeforeDeadline = notBeforeDeadline }
    }
}
