// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the instance store features that are supported by the instance type.
 */
class InstanceStorageInfo private constructor(builder: BuilderImpl) {
    /**
     * Describes the disks that are available for the instance type.
     */
    val disks: List<DiskInfo>? = builder.disks
    /**
     * Indicates whether data is encrypted at rest.
     */
    val encryptionSupport: InstanceStorageEncryptionSupport? = builder.encryptionSupport
    /**
     * Indicates whether non-volatile memory express (NVMe) is supported.
     */
    val nvmeSupport: EphemeralNvmeSupport? = builder.nvmeSupport
    /**
     * The total size of the disks, in GB.
     */
    val totalSizeInGb: Long? = builder.totalSizeInGb

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceStorageInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceStorageInfo(")
        append("disks=$disks,")
        append("encryptionSupport=$encryptionSupport,")
        append("nvmeSupport=$nvmeSupport,")
        append("totalSizeInGb=$totalSizeInGb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = disks?.hashCode() ?: 0
        result = 31 * result + (encryptionSupport?.hashCode() ?: 0)
        result = 31 * result + (nvmeSupport?.hashCode() ?: 0)
        result = 31 * result + (totalSizeInGb?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceStorageInfo

        if (disks != other.disks) return false
        if (encryptionSupport != other.encryptionSupport) return false
        if (nvmeSupport != other.nvmeSupport) return false
        if (totalSizeInGb != other.totalSizeInGb) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceStorageInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceStorageInfo
        /**
         * Describes the disks that are available for the instance type.
         */
        fun disks(disks: List<DiskInfo>): FluentBuilder
        /**
         * Indicates whether data is encrypted at rest.
         */
        fun encryptionSupport(encryptionSupport: InstanceStorageEncryptionSupport): FluentBuilder
        /**
         * Indicates whether non-volatile memory express (NVMe) is supported.
         */
        fun nvmeSupport(nvmeSupport: EphemeralNvmeSupport): FluentBuilder
        /**
         * The total size of the disks, in GB.
         */
        fun totalSizeInGb(totalSizeInGb: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Describes the disks that are available for the instance type.
         */
        var disks: List<DiskInfo>?
        /**
         * Indicates whether data is encrypted at rest.
         */
        var encryptionSupport: InstanceStorageEncryptionSupport?
        /**
         * Indicates whether non-volatile memory express (NVMe) is supported.
         */
        var nvmeSupport: EphemeralNvmeSupport?
        /**
         * The total size of the disks, in GB.
         */
        var totalSizeInGb: Long?

        fun build(): InstanceStorageInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var disks: List<DiskInfo>? = null
        override var encryptionSupport: InstanceStorageEncryptionSupport? = null
        override var nvmeSupport: EphemeralNvmeSupport? = null
        override var totalSizeInGb: Long? = null

        constructor(x: InstanceStorageInfo) : this() {
            this.disks = x.disks
            this.encryptionSupport = x.encryptionSupport
            this.nvmeSupport = x.nvmeSupport
            this.totalSizeInGb = x.totalSizeInGb
        }

        override fun build(): InstanceStorageInfo = InstanceStorageInfo(this)
        override fun disks(disks: List<DiskInfo>): FluentBuilder = apply { this.disks = disks }
        override fun encryptionSupport(encryptionSupport: InstanceStorageEncryptionSupport): FluentBuilder = apply { this.encryptionSupport = encryptionSupport }
        override fun nvmeSupport(nvmeSupport: EphemeralNvmeSupport): FluentBuilder = apply { this.nvmeSupport = nvmeSupport }
        override fun totalSizeInGb(totalSizeInGb: Long): FluentBuilder = apply { this.totalSizeInGb = totalSizeInGb }
    }
}
