// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the instance type.
 */
class InstanceTypeInfo private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether auto recovery is supported.
     */
    val autoRecoverySupported: Boolean? = builder.autoRecoverySupported
    /**
     * Indicates whether the instance is a bare metal instance type.
     */
    val bareMetal: Boolean? = builder.bareMetal
    /**
     * Indicates whether the instance type is a burstable performance instance type.
     */
    val burstablePerformanceSupported: Boolean? = builder.burstablePerformanceSupported
    /**
     * Indicates whether the instance type is current generation.
     */
    val currentGeneration: Boolean? = builder.currentGeneration
    /**
     * Indicates whether Dedicated Hosts are supported on the instance type.
     */
    val dedicatedHostsSupported: Boolean? = builder.dedicatedHostsSupported
    /**
     * Describes the Amazon EBS settings for the instance type.
     */
    val ebsInfo: EbsInfo? = builder.ebsInfo
    /**
     * Describes the FPGA accelerator settings for the instance type.
     */
    val fpgaInfo: FpgaInfo? = builder.fpgaInfo
    /**
     * Indicates whether the instance type is eligible for the free tier.
     */
    val freeTierEligible: Boolean? = builder.freeTierEligible
    /**
     * Describes the GPU accelerator settings for the instance type.
     */
    val gpuInfo: GpuInfo? = builder.gpuInfo
    /**
     * Indicates whether On-Demand hibernation is supported.
     */
    val hibernationSupported: Boolean? = builder.hibernationSupported
    /**
     * The hypervisor for the instance type.
     */
    val hypervisor: InstanceTypeHypervisor? = builder.hypervisor
    /**
     * Describes the Inference accelerator settings for the instance type.
     */
    val inferenceAcceleratorInfo: InferenceAcceleratorInfo? = builder.inferenceAcceleratorInfo
    /**
     * Describes the instance storage for the instance type.
     */
    val instanceStorageInfo: InstanceStorageInfo? = builder.instanceStorageInfo
    /**
     * Indicates whether instance storage is supported.
     */
    val instanceStorageSupported: Boolean? = builder.instanceStorageSupported
    /**
     * The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types in the Amazon EC2 User Guide.
     */
    val instanceType: InstanceType? = builder.instanceType
    /**
     * Describes the memory for the instance type.
     */
    val memoryInfo: MemoryInfo? = builder.memoryInfo
    /**
     * Describes the network settings for the instance type.
     */
    val networkInfo: NetworkInfo? = builder.networkInfo
    /**
     * Describes the placement group settings for the instance type.
     */
    val placementGroupInfo: PlacementGroupInfo? = builder.placementGroupInfo
    /**
     * Describes the processor.
     */
    val processorInfo: ProcessorInfo? = builder.processorInfo
    /**
     * The supported boot modes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
     * Amazon EC2 User Guide.
     */
    val supportedBootModes: List<BootModeType>? = builder.supportedBootModes
    /**
     * The supported root device types.
     */
    val supportedRootDeviceTypes: List<RootDeviceType>? = builder.supportedRootDeviceTypes
    /**
     * Indicates whether the instance type is offered for spot or On-Demand.
     */
    val supportedUsageClasses: List<UsageClassType>? = builder.supportedUsageClasses
    /**
     * The supported virtualization types.
     */
    val supportedVirtualizationTypes: List<VirtualizationType>? = builder.supportedVirtualizationTypes
    /**
     * Describes the vCPU configurations for the instance type.
     */
    val vCpuInfo: VCpuInfo? = builder.vCpuInfo

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceTypeInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceTypeInfo(")
        append("autoRecoverySupported=$autoRecoverySupported,")
        append("bareMetal=$bareMetal,")
        append("burstablePerformanceSupported=$burstablePerformanceSupported,")
        append("currentGeneration=$currentGeneration,")
        append("dedicatedHostsSupported=$dedicatedHostsSupported,")
        append("ebsInfo=$ebsInfo,")
        append("fpgaInfo=$fpgaInfo,")
        append("freeTierEligible=$freeTierEligible,")
        append("gpuInfo=$gpuInfo,")
        append("hibernationSupported=$hibernationSupported,")
        append("hypervisor=$hypervisor,")
        append("inferenceAcceleratorInfo=$inferenceAcceleratorInfo,")
        append("instanceStorageInfo=$instanceStorageInfo,")
        append("instanceStorageSupported=$instanceStorageSupported,")
        append("instanceType=$instanceType,")
        append("memoryInfo=$memoryInfo,")
        append("networkInfo=$networkInfo,")
        append("placementGroupInfo=$placementGroupInfo,")
        append("processorInfo=$processorInfo,")
        append("supportedBootModes=$supportedBootModes,")
        append("supportedRootDeviceTypes=$supportedRootDeviceTypes,")
        append("supportedUsageClasses=$supportedUsageClasses,")
        append("supportedVirtualizationTypes=$supportedVirtualizationTypes,")
        append("vCpuInfo=$vCpuInfo)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoRecoverySupported?.hashCode() ?: 0
        result = 31 * result + (bareMetal?.hashCode() ?: 0)
        result = 31 * result + (burstablePerformanceSupported?.hashCode() ?: 0)
        result = 31 * result + (currentGeneration?.hashCode() ?: 0)
        result = 31 * result + (dedicatedHostsSupported?.hashCode() ?: 0)
        result = 31 * result + (ebsInfo?.hashCode() ?: 0)
        result = 31 * result + (fpgaInfo?.hashCode() ?: 0)
        result = 31 * result + (freeTierEligible?.hashCode() ?: 0)
        result = 31 * result + (gpuInfo?.hashCode() ?: 0)
        result = 31 * result + (hibernationSupported?.hashCode() ?: 0)
        result = 31 * result + (hypervisor?.hashCode() ?: 0)
        result = 31 * result + (inferenceAcceleratorInfo?.hashCode() ?: 0)
        result = 31 * result + (instanceStorageInfo?.hashCode() ?: 0)
        result = 31 * result + (instanceStorageSupported?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (memoryInfo?.hashCode() ?: 0)
        result = 31 * result + (networkInfo?.hashCode() ?: 0)
        result = 31 * result + (placementGroupInfo?.hashCode() ?: 0)
        result = 31 * result + (processorInfo?.hashCode() ?: 0)
        result = 31 * result + (supportedBootModes?.hashCode() ?: 0)
        result = 31 * result + (supportedRootDeviceTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedUsageClasses?.hashCode() ?: 0)
        result = 31 * result + (supportedVirtualizationTypes?.hashCode() ?: 0)
        result = 31 * result + (vCpuInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceTypeInfo

        if (autoRecoverySupported != other.autoRecoverySupported) return false
        if (bareMetal != other.bareMetal) return false
        if (burstablePerformanceSupported != other.burstablePerformanceSupported) return false
        if (currentGeneration != other.currentGeneration) return false
        if (dedicatedHostsSupported != other.dedicatedHostsSupported) return false
        if (ebsInfo != other.ebsInfo) return false
        if (fpgaInfo != other.fpgaInfo) return false
        if (freeTierEligible != other.freeTierEligible) return false
        if (gpuInfo != other.gpuInfo) return false
        if (hibernationSupported != other.hibernationSupported) return false
        if (hypervisor != other.hypervisor) return false
        if (inferenceAcceleratorInfo != other.inferenceAcceleratorInfo) return false
        if (instanceStorageInfo != other.instanceStorageInfo) return false
        if (instanceStorageSupported != other.instanceStorageSupported) return false
        if (instanceType != other.instanceType) return false
        if (memoryInfo != other.memoryInfo) return false
        if (networkInfo != other.networkInfo) return false
        if (placementGroupInfo != other.placementGroupInfo) return false
        if (processorInfo != other.processorInfo) return false
        if (supportedBootModes != other.supportedBootModes) return false
        if (supportedRootDeviceTypes != other.supportedRootDeviceTypes) return false
        if (supportedUsageClasses != other.supportedUsageClasses) return false
        if (supportedVirtualizationTypes != other.supportedVirtualizationTypes) return false
        if (vCpuInfo != other.vCpuInfo) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceTypeInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceTypeInfo
        /**
         * Indicates whether auto recovery is supported.
         */
        fun autoRecoverySupported(autoRecoverySupported: Boolean): FluentBuilder
        /**
         * Indicates whether the instance is a bare metal instance type.
         */
        fun bareMetal(bareMetal: Boolean): FluentBuilder
        /**
         * Indicates whether the instance type is a burstable performance instance type.
         */
        fun burstablePerformanceSupported(burstablePerformanceSupported: Boolean): FluentBuilder
        /**
         * Indicates whether the instance type is current generation.
         */
        fun currentGeneration(currentGeneration: Boolean): FluentBuilder
        /**
         * Indicates whether Dedicated Hosts are supported on the instance type.
         */
        fun dedicatedHostsSupported(dedicatedHostsSupported: Boolean): FluentBuilder
        /**
         * Describes the Amazon EBS settings for the instance type.
         */
        fun ebsInfo(ebsInfo: EbsInfo): FluentBuilder
        /**
         * Describes the FPGA accelerator settings for the instance type.
         */
        fun fpgaInfo(fpgaInfo: FpgaInfo): FluentBuilder
        /**
         * Indicates whether the instance type is eligible for the free tier.
         */
        fun freeTierEligible(freeTierEligible: Boolean): FluentBuilder
        /**
         * Describes the GPU accelerator settings for the instance type.
         */
        fun gpuInfo(gpuInfo: GpuInfo): FluentBuilder
        /**
         * Indicates whether On-Demand hibernation is supported.
         */
        fun hibernationSupported(hibernationSupported: Boolean): FluentBuilder
        /**
         * The hypervisor for the instance type.
         */
        fun hypervisor(hypervisor: InstanceTypeHypervisor): FluentBuilder
        /**
         * Describes the Inference accelerator settings for the instance type.
         */
        fun inferenceAcceleratorInfo(inferenceAcceleratorInfo: InferenceAcceleratorInfo): FluentBuilder
        /**
         * Describes the instance storage for the instance type.
         */
        fun instanceStorageInfo(instanceStorageInfo: InstanceStorageInfo): FluentBuilder
        /**
         * Indicates whether instance storage is supported.
         */
        fun instanceStorageSupported(instanceStorageSupported: Boolean): FluentBuilder
        /**
         * The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types in the Amazon EC2 User Guide.
         */
        fun instanceType(instanceType: InstanceType): FluentBuilder
        /**
         * Describes the memory for the instance type.
         */
        fun memoryInfo(memoryInfo: MemoryInfo): FluentBuilder
        /**
         * Describes the network settings for the instance type.
         */
        fun networkInfo(networkInfo: NetworkInfo): FluentBuilder
        /**
         * Describes the placement group settings for the instance type.
         */
        fun placementGroupInfo(placementGroupInfo: PlacementGroupInfo): FluentBuilder
        /**
         * Describes the processor.
         */
        fun processorInfo(processorInfo: ProcessorInfo): FluentBuilder
        /**
         * The supported boot modes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
         * Amazon EC2 User Guide.
         */
        fun supportedBootModes(supportedBootModes: List<BootModeType>): FluentBuilder
        /**
         * The supported root device types.
         */
        fun supportedRootDeviceTypes(supportedRootDeviceTypes: List<RootDeviceType>): FluentBuilder
        /**
         * Indicates whether the instance type is offered for spot or On-Demand.
         */
        fun supportedUsageClasses(supportedUsageClasses: List<UsageClassType>): FluentBuilder
        /**
         * The supported virtualization types.
         */
        fun supportedVirtualizationTypes(supportedVirtualizationTypes: List<VirtualizationType>): FluentBuilder
        /**
         * Describes the vCPU configurations for the instance type.
         */
        fun vCpuInfo(vCpuInfo: VCpuInfo): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether auto recovery is supported.
         */
        var autoRecoverySupported: Boolean?
        /**
         * Indicates whether the instance is a bare metal instance type.
         */
        var bareMetal: Boolean?
        /**
         * Indicates whether the instance type is a burstable performance instance type.
         */
        var burstablePerformanceSupported: Boolean?
        /**
         * Indicates whether the instance type is current generation.
         */
        var currentGeneration: Boolean?
        /**
         * Indicates whether Dedicated Hosts are supported on the instance type.
         */
        var dedicatedHostsSupported: Boolean?
        /**
         * Describes the Amazon EBS settings for the instance type.
         */
        var ebsInfo: EbsInfo?
        /**
         * Describes the FPGA accelerator settings for the instance type.
         */
        var fpgaInfo: FpgaInfo?
        /**
         * Indicates whether the instance type is eligible for the free tier.
         */
        var freeTierEligible: Boolean?
        /**
         * Describes the GPU accelerator settings for the instance type.
         */
        var gpuInfo: GpuInfo?
        /**
         * Indicates whether On-Demand hibernation is supported.
         */
        var hibernationSupported: Boolean?
        /**
         * The hypervisor for the instance type.
         */
        var hypervisor: InstanceTypeHypervisor?
        /**
         * Describes the Inference accelerator settings for the instance type.
         */
        var inferenceAcceleratorInfo: InferenceAcceleratorInfo?
        /**
         * Describes the instance storage for the instance type.
         */
        var instanceStorageInfo: InstanceStorageInfo?
        /**
         * Indicates whether instance storage is supported.
         */
        var instanceStorageSupported: Boolean?
        /**
         * The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types in the Amazon EC2 User Guide.
         */
        var instanceType: InstanceType?
        /**
         * Describes the memory for the instance type.
         */
        var memoryInfo: MemoryInfo?
        /**
         * Describes the network settings for the instance type.
         */
        var networkInfo: NetworkInfo?
        /**
         * Describes the placement group settings for the instance type.
         */
        var placementGroupInfo: PlacementGroupInfo?
        /**
         * Describes the processor.
         */
        var processorInfo: ProcessorInfo?
        /**
         * The supported boot modes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes in the
         * Amazon EC2 User Guide.
         */
        var supportedBootModes: List<BootModeType>?
        /**
         * The supported root device types.
         */
        var supportedRootDeviceTypes: List<RootDeviceType>?
        /**
         * Indicates whether the instance type is offered for spot or On-Demand.
         */
        var supportedUsageClasses: List<UsageClassType>?
        /**
         * The supported virtualization types.
         */
        var supportedVirtualizationTypes: List<VirtualizationType>?
        /**
         * Describes the vCPU configurations for the instance type.
         */
        var vCpuInfo: VCpuInfo?

        fun build(): InstanceTypeInfo
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EbsInfo] inside the given [block]
         */
        fun ebsInfo(block: EbsInfo.DslBuilder.() -> kotlin.Unit) {
            this.ebsInfo = EbsInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.FpgaInfo] inside the given [block]
         */
        fun fpgaInfo(block: FpgaInfo.DslBuilder.() -> kotlin.Unit) {
            this.fpgaInfo = FpgaInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.GpuInfo] inside the given [block]
         */
        fun gpuInfo(block: GpuInfo.DslBuilder.() -> kotlin.Unit) {
            this.gpuInfo = GpuInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InferenceAcceleratorInfo] inside the given [block]
         */
        fun inferenceAcceleratorInfo(block: InferenceAcceleratorInfo.DslBuilder.() -> kotlin.Unit) {
            this.inferenceAcceleratorInfo = InferenceAcceleratorInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceStorageInfo] inside the given [block]
         */
        fun instanceStorageInfo(block: InstanceStorageInfo.DslBuilder.() -> kotlin.Unit) {
            this.instanceStorageInfo = InstanceStorageInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.MemoryInfo] inside the given [block]
         */
        fun memoryInfo(block: MemoryInfo.DslBuilder.() -> kotlin.Unit) {
            this.memoryInfo = MemoryInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInfo] inside the given [block]
         */
        fun networkInfo(block: NetworkInfo.DslBuilder.() -> kotlin.Unit) {
            this.networkInfo = NetworkInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PlacementGroupInfo] inside the given [block]
         */
        fun placementGroupInfo(block: PlacementGroupInfo.DslBuilder.() -> kotlin.Unit) {
            this.placementGroupInfo = PlacementGroupInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ProcessorInfo] inside the given [block]
         */
        fun processorInfo(block: ProcessorInfo.DslBuilder.() -> kotlin.Unit) {
            this.processorInfo = ProcessorInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VCpuInfo] inside the given [block]
         */
        fun vCpuInfo(block: VCpuInfo.DslBuilder.() -> kotlin.Unit) {
            this.vCpuInfo = VCpuInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var autoRecoverySupported: Boolean? = null
        override var bareMetal: Boolean? = null
        override var burstablePerformanceSupported: Boolean? = null
        override var currentGeneration: Boolean? = null
        override var dedicatedHostsSupported: Boolean? = null
        override var ebsInfo: EbsInfo? = null
        override var fpgaInfo: FpgaInfo? = null
        override var freeTierEligible: Boolean? = null
        override var gpuInfo: GpuInfo? = null
        override var hibernationSupported: Boolean? = null
        override var hypervisor: InstanceTypeHypervisor? = null
        override var inferenceAcceleratorInfo: InferenceAcceleratorInfo? = null
        override var instanceStorageInfo: InstanceStorageInfo? = null
        override var instanceStorageSupported: Boolean? = null
        override var instanceType: InstanceType? = null
        override var memoryInfo: MemoryInfo? = null
        override var networkInfo: NetworkInfo? = null
        override var placementGroupInfo: PlacementGroupInfo? = null
        override var processorInfo: ProcessorInfo? = null
        override var supportedBootModes: List<BootModeType>? = null
        override var supportedRootDeviceTypes: List<RootDeviceType>? = null
        override var supportedUsageClasses: List<UsageClassType>? = null
        override var supportedVirtualizationTypes: List<VirtualizationType>? = null
        override var vCpuInfo: VCpuInfo? = null

        constructor(x: InstanceTypeInfo) : this() {
            this.autoRecoverySupported = x.autoRecoverySupported
            this.bareMetal = x.bareMetal
            this.burstablePerformanceSupported = x.burstablePerformanceSupported
            this.currentGeneration = x.currentGeneration
            this.dedicatedHostsSupported = x.dedicatedHostsSupported
            this.ebsInfo = x.ebsInfo
            this.fpgaInfo = x.fpgaInfo
            this.freeTierEligible = x.freeTierEligible
            this.gpuInfo = x.gpuInfo
            this.hibernationSupported = x.hibernationSupported
            this.hypervisor = x.hypervisor
            this.inferenceAcceleratorInfo = x.inferenceAcceleratorInfo
            this.instanceStorageInfo = x.instanceStorageInfo
            this.instanceStorageSupported = x.instanceStorageSupported
            this.instanceType = x.instanceType
            this.memoryInfo = x.memoryInfo
            this.networkInfo = x.networkInfo
            this.placementGroupInfo = x.placementGroupInfo
            this.processorInfo = x.processorInfo
            this.supportedBootModes = x.supportedBootModes
            this.supportedRootDeviceTypes = x.supportedRootDeviceTypes
            this.supportedUsageClasses = x.supportedUsageClasses
            this.supportedVirtualizationTypes = x.supportedVirtualizationTypes
            this.vCpuInfo = x.vCpuInfo
        }

        override fun build(): InstanceTypeInfo = InstanceTypeInfo(this)
        override fun autoRecoverySupported(autoRecoverySupported: Boolean): FluentBuilder = apply { this.autoRecoverySupported = autoRecoverySupported }
        override fun bareMetal(bareMetal: Boolean): FluentBuilder = apply { this.bareMetal = bareMetal }
        override fun burstablePerformanceSupported(burstablePerformanceSupported: Boolean): FluentBuilder = apply { this.burstablePerformanceSupported = burstablePerformanceSupported }
        override fun currentGeneration(currentGeneration: Boolean): FluentBuilder = apply { this.currentGeneration = currentGeneration }
        override fun dedicatedHostsSupported(dedicatedHostsSupported: Boolean): FluentBuilder = apply { this.dedicatedHostsSupported = dedicatedHostsSupported }
        override fun ebsInfo(ebsInfo: EbsInfo): FluentBuilder = apply { this.ebsInfo = ebsInfo }
        override fun fpgaInfo(fpgaInfo: FpgaInfo): FluentBuilder = apply { this.fpgaInfo = fpgaInfo }
        override fun freeTierEligible(freeTierEligible: Boolean): FluentBuilder = apply { this.freeTierEligible = freeTierEligible }
        override fun gpuInfo(gpuInfo: GpuInfo): FluentBuilder = apply { this.gpuInfo = gpuInfo }
        override fun hibernationSupported(hibernationSupported: Boolean): FluentBuilder = apply { this.hibernationSupported = hibernationSupported }
        override fun hypervisor(hypervisor: InstanceTypeHypervisor): FluentBuilder = apply { this.hypervisor = hypervisor }
        override fun inferenceAcceleratorInfo(inferenceAcceleratorInfo: InferenceAcceleratorInfo): FluentBuilder = apply { this.inferenceAcceleratorInfo = inferenceAcceleratorInfo }
        override fun instanceStorageInfo(instanceStorageInfo: InstanceStorageInfo): FluentBuilder = apply { this.instanceStorageInfo = instanceStorageInfo }
        override fun instanceStorageSupported(instanceStorageSupported: Boolean): FluentBuilder = apply { this.instanceStorageSupported = instanceStorageSupported }
        override fun instanceType(instanceType: InstanceType): FluentBuilder = apply { this.instanceType = instanceType }
        override fun memoryInfo(memoryInfo: MemoryInfo): FluentBuilder = apply { this.memoryInfo = memoryInfo }
        override fun networkInfo(networkInfo: NetworkInfo): FluentBuilder = apply { this.networkInfo = networkInfo }
        override fun placementGroupInfo(placementGroupInfo: PlacementGroupInfo): FluentBuilder = apply { this.placementGroupInfo = placementGroupInfo }
        override fun processorInfo(processorInfo: ProcessorInfo): FluentBuilder = apply { this.processorInfo = processorInfo }
        override fun supportedBootModes(supportedBootModes: List<BootModeType>): FluentBuilder = apply { this.supportedBootModes = supportedBootModes }
        override fun supportedRootDeviceTypes(supportedRootDeviceTypes: List<RootDeviceType>): FluentBuilder = apply { this.supportedRootDeviceTypes = supportedRootDeviceTypes }
        override fun supportedUsageClasses(supportedUsageClasses: List<UsageClassType>): FluentBuilder = apply { this.supportedUsageClasses = supportedUsageClasses }
        override fun supportedVirtualizationTypes(supportedVirtualizationTypes: List<VirtualizationType>): FluentBuilder = apply { this.supportedVirtualizationTypes = supportedVirtualizationTypes }
        override fun vCpuInfo(vCpuInfo: VCpuInfo): FluentBuilder = apply { this.vCpuInfo = vCpuInfo }
    }
}
