// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about the Capacity Reservation usage.
 */
class InstanceUsage private constructor(builder: BuilderImpl) {
    /**
     * The ID of the Amazon Web Services account that is making use of the Capacity Reservation.
     */
    val accountId: String? = builder.accountId
    /**
     * The number of instances the Amazon Web Services account currently has in the Capacity Reservation.
     */
    val usedInstanceCount: Int? = builder.usedInstanceCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InstanceUsage = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceUsage(")
        append("accountId=$accountId,")
        append("usedInstanceCount=$usedInstanceCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (usedInstanceCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceUsage

        if (accountId != other.accountId) return false
        if (usedInstanceCount != other.usedInstanceCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InstanceUsage = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InstanceUsage
        /**
         * The ID of the Amazon Web Services account that is making use of the Capacity Reservation.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The number of instances the Amazon Web Services account currently has in the Capacity Reservation.
         */
        fun usedInstanceCount(usedInstanceCount: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the Amazon Web Services account that is making use of the Capacity Reservation.
         */
        var accountId: String?
        /**
         * The number of instances the Amazon Web Services account currently has in the Capacity Reservation.
         */
        var usedInstanceCount: Int?

        fun build(): InstanceUsage
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var usedInstanceCount: Int? = null

        constructor(x: InstanceUsage) : this() {
            this.accountId = x.accountId
            this.usedInstanceCount = x.usedInstanceCount
        }

        override fun build(): InstanceUsage = InstanceUsage(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun usedInstanceCount(usedInstanceCount: Int): FluentBuilder = apply { this.usedInstanceCount = usedInstanceCount }
    }
}
