// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an internet gateway.
 */
class InternetGateway private constructor(builder: BuilderImpl) {
    /**
     * Any VPCs attached to the internet gateway.
     */
    val attachments: List<InternetGatewayAttachment>? = builder.attachments
    /**
     * The ID of the internet gateway.
     */
    val internetGatewayId: String? = builder.internetGatewayId
    /**
     * The ID of the Amazon Web Services account that owns the internet gateway.
     */
    val ownerId: String? = builder.ownerId
    /**
     * Any tags assigned to the internet gateway.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): InternetGateway = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("InternetGateway(")
        append("attachments=$attachments,")
        append("internetGatewayId=$internetGatewayId,")
        append("ownerId=$ownerId,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (internetGatewayId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InternetGateway

        if (attachments != other.attachments) return false
        if (internetGatewayId != other.internetGatewayId) return false
        if (ownerId != other.ownerId) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): InternetGateway = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): InternetGateway
        /**
         * Any VPCs attached to the internet gateway.
         */
        fun attachments(attachments: List<InternetGatewayAttachment>): FluentBuilder
        /**
         * The ID of the internet gateway.
         */
        fun internetGatewayId(internetGatewayId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the internet gateway.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * Any tags assigned to the internet gateway.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Any VPCs attached to the internet gateway.
         */
        var attachments: List<InternetGatewayAttachment>?
        /**
         * The ID of the internet gateway.
         */
        var internetGatewayId: String?
        /**
         * The ID of the Amazon Web Services account that owns the internet gateway.
         */
        var ownerId: String?
        /**
         * Any tags assigned to the internet gateway.
         */
        var tags: List<Tag>?

        fun build(): InternetGateway
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attachments: List<InternetGatewayAttachment>? = null
        override var internetGatewayId: String? = null
        override var ownerId: String? = null
        override var tags: List<Tag>? = null

        constructor(x: InternetGateway) : this() {
            this.attachments = x.attachments
            this.internetGatewayId = x.internetGatewayId
            this.ownerId = x.ownerId
            this.tags = x.tags
        }

        override fun build(): InternetGateway = InternetGateway(this)
        override fun attachments(attachments: List<InternetGatewayAttachment>): FluentBuilder = apply { this.attachments = attachments }
        override fun internetGatewayId(internetGatewayId: String): FluentBuilder = apply { this.internetGatewayId = internetGatewayId }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
