// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a key pair.
 */
class KeyPairInfo private constructor(builder: BuilderImpl) {
    /**
     * If you used CreateKeyPair to create the key pair:
     * For RSA key pairs, the key fingerprint is the SHA-1 digest of the DER encoded private key.
     * For ED25519 key pairs, the key fingerprint is the base64-encoded SHA-256 digest, which
     * is the default for OpenSSH, starting with <a href="http://www.openssh.com/txt/release-6.8">OpenSSH 6.8.
     * If you used ImportKeyPair to provide Amazon Web Services the public key:
     * For RSA key pairs, the key fingerprint is the MD5 public key fingerprint as specified in section 4 of RFC4716.
     * For ED25519 key pairs, the key fingerprint is the base64-encoded SHA-256
     * digest, which is the default for OpenSSH, starting with <a href="http://www.openssh.com/txt/release-6.8">OpenSSH 6.8.
     */
    val keyFingerprint: String? = builder.keyFingerprint
    /**
     * The name of the key pair.
     */
    val keyName: String? = builder.keyName
    /**
     * The ID of the key pair.
     */
    val keyPairId: String? = builder.keyPairId
    /**
     * The type of key pair.
     */
    val keyType: KeyType? = builder.keyType
    /**
     * Any tags applied to the key pair.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): KeyPairInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("KeyPairInfo(")
        append("keyFingerprint=$keyFingerprint,")
        append("keyName=$keyName,")
        append("keyPairId=$keyPairId,")
        append("keyType=$keyType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyFingerprint?.hashCode() ?: 0
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (keyPairId?.hashCode() ?: 0)
        result = 31 * result + (keyType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KeyPairInfo

        if (keyFingerprint != other.keyFingerprint) return false
        if (keyName != other.keyName) return false
        if (keyPairId != other.keyPairId) return false
        if (keyType != other.keyType) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): KeyPairInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): KeyPairInfo
        /**
         * If you used CreateKeyPair to create the key pair:
         * For RSA key pairs, the key fingerprint is the SHA-1 digest of the DER encoded private key.
         * For ED25519 key pairs, the key fingerprint is the base64-encoded SHA-256 digest, which
         * is the default for OpenSSH, starting with <a href="http://www.openssh.com/txt/release-6.8">OpenSSH 6.8.
         * If you used ImportKeyPair to provide Amazon Web Services the public key:
         * For RSA key pairs, the key fingerprint is the MD5 public key fingerprint as specified in section 4 of RFC4716.
         * For ED25519 key pairs, the key fingerprint is the base64-encoded SHA-256
         * digest, which is the default for OpenSSH, starting with <a href="http://www.openssh.com/txt/release-6.8">OpenSSH 6.8.
         */
        fun keyFingerprint(keyFingerprint: String): FluentBuilder
        /**
         * The name of the key pair.
         */
        fun keyName(keyName: String): FluentBuilder
        /**
         * The ID of the key pair.
         */
        fun keyPairId(keyPairId: String): FluentBuilder
        /**
         * The type of key pair.
         */
        fun keyType(keyType: KeyType): FluentBuilder
        /**
         * Any tags applied to the key pair.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * If you used CreateKeyPair to create the key pair:
         * For RSA key pairs, the key fingerprint is the SHA-1 digest of the DER encoded private key.
         * For ED25519 key pairs, the key fingerprint is the base64-encoded SHA-256 digest, which
         * is the default for OpenSSH, starting with <a href="http://www.openssh.com/txt/release-6.8">OpenSSH 6.8.
         * If you used ImportKeyPair to provide Amazon Web Services the public key:
         * For RSA key pairs, the key fingerprint is the MD5 public key fingerprint as specified in section 4 of RFC4716.
         * For ED25519 key pairs, the key fingerprint is the base64-encoded SHA-256
         * digest, which is the default for OpenSSH, starting with <a href="http://www.openssh.com/txt/release-6.8">OpenSSH 6.8.
         */
        var keyFingerprint: String?
        /**
         * The name of the key pair.
         */
        var keyName: String?
        /**
         * The ID of the key pair.
         */
        var keyPairId: String?
        /**
         * The type of key pair.
         */
        var keyType: KeyType?
        /**
         * Any tags applied to the key pair.
         */
        var tags: List<Tag>?

        fun build(): KeyPairInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var keyFingerprint: String? = null
        override var keyName: String? = null
        override var keyPairId: String? = null
        override var keyType: KeyType? = null
        override var tags: List<Tag>? = null

        constructor(x: KeyPairInfo) : this() {
            this.keyFingerprint = x.keyFingerprint
            this.keyName = x.keyName
            this.keyPairId = x.keyPairId
            this.keyType = x.keyType
            this.tags = x.tags
        }

        override fun build(): KeyPairInfo = KeyPairInfo(this)
        override fun keyFingerprint(keyFingerprint: String): FluentBuilder = apply { this.keyFingerprint = keyFingerprint }
        override fun keyName(keyName: String): FluentBuilder = apply { this.keyName = keyName }
        override fun keyPairId(keyPairId: String): FluentBuilder = apply { this.keyPairId = keyPairId }
        override fun keyType(keyType: KeyType): FluentBuilder = apply { this.keyType = keyType }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
