// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a block device mapping.
 */
class LaunchTemplateBlockDeviceMapping private constructor(builder: BuilderImpl) {
    /**
     * The device name.
     */
    val deviceName: String? = builder.deviceName
    /**
     * Information about the block device for an EBS volume.
     */
    val ebs: LaunchTemplateEbsBlockDevice? = builder.ebs
    /**
     * To omit the device from the block device mapping, specify an empty string.
     */
    val noDevice: String? = builder.noDevice
    /**
     * The virtual device name (ephemeralN).
     */
    val virtualName: String? = builder.virtualName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateBlockDeviceMapping = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateBlockDeviceMapping(")
        append("deviceName=$deviceName,")
        append("ebs=$ebs,")
        append("noDevice=$noDevice,")
        append("virtualName=$virtualName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceName?.hashCode() ?: 0
        result = 31 * result + (ebs?.hashCode() ?: 0)
        result = 31 * result + (noDevice?.hashCode() ?: 0)
        result = 31 * result + (virtualName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateBlockDeviceMapping

        if (deviceName != other.deviceName) return false
        if (ebs != other.ebs) return false
        if (noDevice != other.noDevice) return false
        if (virtualName != other.virtualName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateBlockDeviceMapping = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateBlockDeviceMapping
        /**
         * The device name.
         */
        fun deviceName(deviceName: String): FluentBuilder
        /**
         * Information about the block device for an EBS volume.
         */
        fun ebs(ebs: LaunchTemplateEbsBlockDevice): FluentBuilder
        /**
         * To omit the device from the block device mapping, specify an empty string.
         */
        fun noDevice(noDevice: String): FluentBuilder
        /**
         * The virtual device name (ephemeralN).
         */
        fun virtualName(virtualName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The device name.
         */
        var deviceName: String?
        /**
         * Information about the block device for an EBS volume.
         */
        var ebs: LaunchTemplateEbsBlockDevice?
        /**
         * To omit the device from the block device mapping, specify an empty string.
         */
        var noDevice: String?
        /**
         * The virtual device name (ephemeralN).
         */
        var virtualName: String?

        fun build(): LaunchTemplateBlockDeviceMapping
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateEbsBlockDevice] inside the given [block]
         */
        fun ebs(block: LaunchTemplateEbsBlockDevice.DslBuilder.() -> kotlin.Unit) {
            this.ebs = LaunchTemplateEbsBlockDevice.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deviceName: String? = null
        override var ebs: LaunchTemplateEbsBlockDevice? = null
        override var noDevice: String? = null
        override var virtualName: String? = null

        constructor(x: LaunchTemplateBlockDeviceMapping) : this() {
            this.deviceName = x.deviceName
            this.ebs = x.ebs
            this.noDevice = x.noDevice
            this.virtualName = x.virtualName
        }

        override fun build(): LaunchTemplateBlockDeviceMapping = LaunchTemplateBlockDeviceMapping(this)
        override fun deviceName(deviceName: String): FluentBuilder = apply { this.deviceName = deviceName }
        override fun ebs(ebs: LaunchTemplateEbsBlockDevice): FluentBuilder = apply { this.ebs = ebs }
        override fun noDevice(noDevice: String): FluentBuilder = apply { this.noDevice = noDevice }
        override fun virtualName(virtualName: String): FluentBuilder = apply { this.virtualName = virtualName }
    }
}
