// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a block device mapping.
 */
class LaunchTemplateBlockDeviceMappingRequest private constructor(builder: BuilderImpl) {
    /**
     * The device name (for example, /dev/sdh or xvdh).
     */
    val deviceName: String? = builder.deviceName
    /**
     * Parameters used to automatically set up EBS volumes when the instance is launched.
     */
    val ebs: LaunchTemplateEbsBlockDeviceRequest? = builder.ebs
    /**
     * To omit the device from the block device mapping, specify an empty string.
     */
    val noDevice: String? = builder.noDevice
    /**
     * The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0.
     * An instance type with 2 available instance store volumes can specify mappings for ephemeral0
     * and ephemeral1. The number of available instance store volumes depends on the instance type.
     * After you connect to the instance, you must mount the volume.
     */
    val virtualName: String? = builder.virtualName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LaunchTemplateBlockDeviceMappingRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateBlockDeviceMappingRequest(")
        append("deviceName=$deviceName,")
        append("ebs=$ebs,")
        append("noDevice=$noDevice,")
        append("virtualName=$virtualName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceName?.hashCode() ?: 0
        result = 31 * result + (ebs?.hashCode() ?: 0)
        result = 31 * result + (noDevice?.hashCode() ?: 0)
        result = 31 * result + (virtualName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LaunchTemplateBlockDeviceMappingRequest

        if (deviceName != other.deviceName) return false
        if (ebs != other.ebs) return false
        if (noDevice != other.noDevice) return false
        if (virtualName != other.virtualName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LaunchTemplateBlockDeviceMappingRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LaunchTemplateBlockDeviceMappingRequest
        /**
         * The device name (for example, /dev/sdh or xvdh).
         */
        fun deviceName(deviceName: String): FluentBuilder
        /**
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         */
        fun ebs(ebs: LaunchTemplateEbsBlockDeviceRequest): FluentBuilder
        /**
         * To omit the device from the block device mapping, specify an empty string.
         */
        fun noDevice(noDevice: String): FluentBuilder
        /**
         * The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0.
         * An instance type with 2 available instance store volumes can specify mappings for ephemeral0
         * and ephemeral1. The number of available instance store volumes depends on the instance type.
         * After you connect to the instance, you must mount the volume.
         */
        fun virtualName(virtualName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The device name (for example, /dev/sdh or xvdh).
         */
        var deviceName: String?
        /**
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         */
        var ebs: LaunchTemplateEbsBlockDeviceRequest?
        /**
         * To omit the device from the block device mapping, specify an empty string.
         */
        var noDevice: String?
        /**
         * The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0.
         * An instance type with 2 available instance store volumes can specify mappings for ephemeral0
         * and ephemeral1. The number of available instance store volumes depends on the instance type.
         * After you connect to the instance, you must mount the volume.
         */
        var virtualName: String?

        fun build(): LaunchTemplateBlockDeviceMappingRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest] inside the given [block]
         */
        fun ebs(block: LaunchTemplateEbsBlockDeviceRequest.DslBuilder.() -> kotlin.Unit) {
            this.ebs = LaunchTemplateEbsBlockDeviceRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deviceName: String? = null
        override var ebs: LaunchTemplateEbsBlockDeviceRequest? = null
        override var noDevice: String? = null
        override var virtualName: String? = null

        constructor(x: LaunchTemplateBlockDeviceMappingRequest) : this() {
            this.deviceName = x.deviceName
            this.ebs = x.ebs
            this.noDevice = x.noDevice
            this.virtualName = x.virtualName
        }

        override fun build(): LaunchTemplateBlockDeviceMappingRequest = LaunchTemplateBlockDeviceMappingRequest(this)
        override fun deviceName(deviceName: String): FluentBuilder = apply { this.deviceName = deviceName }
        override fun ebs(ebs: LaunchTemplateEbsBlockDeviceRequest): FluentBuilder = apply { this.ebs = ebs }
        override fun noDevice(noDevice: String): FluentBuilder = apply { this.noDevice = noDevice }
        override fun virtualName(virtualName: String): FluentBuilder = apply { this.virtualName = virtualName }
    }
}
